/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.actor.Address;
import akka.remote.transport.AssociationHandle;
import akka.remote.transport.netty.NettyTransportException;
import akka.remote.transport.netty.UdpAssociationHandle;
import akka.remote.transport.netty.UdpHandlers;
import akka.util.ByteString$;
import com.alibaba.schedulerx.shade.org.jboss.netty.buffer.ChannelBuffer;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelHandlerContext;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.MessageEvent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Predef$;
import scala.StringContext;
import scala.runtime.BoxedUnit;

public abstract class UdpHandlers$class {
    public static AssociationHandle createHandle(UdpHandlers $this, Channel channel, Address localAddress, Address remoteAddress) {
        return new UdpAssociationHandle(localAddress, remoteAddress, channel, $this.transport());
    }

    public static void registerListener(UdpHandlers $this, Channel channel, AssociationHandle.HandleEventListener listener, ChannelBuffer msg, InetSocketAddress remoteSocketAddress) {
        AssociationHandle.HandleEventListener handleEventListener = $this.transport().udpConnectionTable().putIfAbsent(remoteSocketAddress, listener);
        if (handleEventListener == null) {
            listener.notify(new AssociationHandle.InboundPayload(ByteString$.MODULE$.apply(msg.array())));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new NettyTransportException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listener ", " attempted to register for remote address ", " but ", " was already registered."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{listener, remoteSocketAddress, handleEventListener})));
    }

    public static void onMessage(UdpHandlers $this, ChannelHandlerContext ctx, MessageEvent e) {
        SocketAddress socketAddress = e.getRemoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            BoxedUnit boxedUnit;
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            if ($this.transport().udpConnectionTable().containsKey(inetSocketAddress)) {
                AssociationHandle.HandleEventListener listener = $this.transport().udpConnectionTable().get(inetSocketAddress);
                byte[] bytes = ((ChannelBuffer)e.getMessage()).array();
                if (bytes.length > 0) {
                    listener.notify(new AssociationHandle.InboundPayload(ByteString$.MODULE$.apply(bytes)));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                e.getChannel().setReadable(false);
                $this.initUdp(e.getChannel(), e.getRemoteAddress(), (ChannelBuffer)e.getMessage());
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static void $init$(UdpHandlers $this) {
    }
}

