/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery;

import akka.remote.artery.FlightRecorder$;
import akka.remote.artery.FlightRecorderReader;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Path;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SortedSet;
import scala.collection.SortedSet$;
import scala.collection.immutable.Seq$;
import scala.math.Ordering;
import scala.package$;

public final class FlightRecorderReader$ {
    public static final FlightRecorderReader$ MODULE$;
    private final FlightRecorderReader.SectionParameters AlertSectionParameters;
    private final FlightRecorderReader.SectionParameters LoFreqSectionParameters;
    private final FlightRecorderReader.SectionParameters HiFreqSectionParameters;

    static {
        new FlightRecorderReader$();
    }

    public FlightRecorderReader.SectionParameters AlertSectionParameters() {
        return this.AlertSectionParameters;
    }

    public FlightRecorderReader.SectionParameters LoFreqSectionParameters() {
        return this.LoFreqSectionParameters;
    }

    public FlightRecorderReader.SectionParameters HiFreqSectionParameters() {
        return this.HiFreqSectionParameters;
    }

    public void dumpToStdout(Path flightRecorderFile) {
        RandomAccessFile raFile = null;
        AbstractInterruptibleChannel channel = null;
        FlightRecorderReader reader = null;
        try {
            raFile = new RandomAccessFile(flightRecorderFile.toFile(), "rw");
            channel = raFile.getChannel();
            reader = new FlightRecorderReader((FileChannel)channel);
            Seq alerts = reader.structure().alertLog().logs().flatMap(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterator<FlightRecorderReader.RichEntry> apply(FlightRecorderReader.Log x$1) {
                    return x$1.richEntries();
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq hiFreq = reader.structure().hiFreqLog().logs().flatMap(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterator<FlightRecorderReader.CompactEntry> apply(FlightRecorderReader.Log x$2) {
                    return x$2.compactEntries();
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq loFreq = reader.structure().loFreqLog().logs().flatMap(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterator<FlightRecorderReader.RichEntry> apply(FlightRecorderReader.Log x$3) {
                    return x$3.richEntries();
                }
            }, Seq$.MODULE$.canBuildFrom());
            Ordering<FlightRecorderReader.Entry> ordering = package$.MODULE$.Ordering().fromLessThan(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(FlightRecorderReader.Entry a, FlightRecorderReader.Entry b) {
                    return a.timeStamp().isBefore(b.timeStamp());
                }
            });
            SortedSet sorted2 = (SortedSet)SortedSet$.MODULE$.apply(alerts, ordering).$plus$plus(hiFreq).$plus$plus(loFreq);
            Predef$.MODULE$.println("--- FLIGHT RECORDER LOG");
            sorted2.foreach(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Object x) {
                    Predef$.MODULE$.println(x);
                }
            });
            return;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (channel != null) {
                channel.close();
            }
            if (raFile != null) {
                raFile.close();
            }
        }
    }

    private FlightRecorderReader$() {
        MODULE$ = this;
        this.AlertSectionParameters = new FlightRecorderReader.SectionParameters(FlightRecorder$.MODULE$.AlertSectionOffset(), FlightRecorder$.MODULE$.AlertSectionSize(), FlightRecorder$.MODULE$.AlertLogSize(), FlightRecorder$.MODULE$.AlertWindow(), FlightRecorder$.MODULE$.AlertRecordSize(), 1L);
        this.LoFreqSectionParameters = new FlightRecorderReader.SectionParameters(FlightRecorder$.MODULE$.LoFreqSectionOffset(), FlightRecorder$.MODULE$.LoFreqSectionSize(), FlightRecorder$.MODULE$.LoFreqLogSize(), FlightRecorder$.MODULE$.LoFreqWindow(), FlightRecorder$.MODULE$.LoFreqRecordSize(), 1L);
        this.HiFreqSectionParameters = new FlightRecorderReader.SectionParameters(FlightRecorder$.MODULE$.HiFreqSectionOffset(), FlightRecorder$.MODULE$.HiFreqSectionSize(), FlightRecorder$.MODULE$.HiFreqLogSize(), FlightRecorder$.MODULE$.HiFreqWindow(), FlightRecorder$.MODULE$.HiFreqRecordSize(), FlightRecorder$.MODULE$.HiFreqBatchSize());
    }
}

