/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.serialization;

import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.persistence.serialization.Snapshot;
import akka.persistence.serialization.SnapshotHeader;
import akka.persistence.serialization.SnapshotSerializer$;
import akka.serialization.BaseSerializer;
import akka.serialization.BaseSerializer$class;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.Serializer$class;
import akka.serialization.SerializerWithStringManifest;
import akka.util.ByteString$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u0001%\u0011!c\u00158baNDw\u000e^*fe&\fG.\u001b>fe*\u00111\u0001B\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011a\u00039feNL7\u000f^3oG\u0016T\u0011aB\u0001\u0005C.\\\u0017m\u0001\u0001\u0014\u0007\u0001Q\u0001\u0003\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\t\u0003#Mi\u0011A\u0005\u0006\u0003\u0007\u0019I!\u0001\u0006\n\u0003\u001d\t\u000b7/Z*fe&\fG.\u001b>fe\"Aa\u0003\u0001BC\u0002\u0013\u0005q#\u0001\u0004tsN$X-\\\u000b\u00021A\u0011\u0011\u0004H\u0007\u00025)\u00111DB\u0001\u0006C\u000e$xN]\u0005\u0003;i\u00111#\u0012=uK:$W\rZ!di>\u00148+_:uK6D\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\bgf\u001cH/Z7!\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\u00111%\n\t\u0003I\u0001i\u0011A\u0001\u0005\u0006-\u0001\u0002\r\u0001\u0007\u0005\bO\u0001\u0011\r\u0011\"\u0011)\u0003=Ign\u00197vI\u0016l\u0015M\\5gKN$X#A\u0015\u0011\u0005-Q\u0013BA\u0016\r\u0005\u001d\u0011un\u001c7fC:Da!\f\u0001!\u0002\u0013I\u0013\u0001E5oG2,H-Z'b]&4Wm\u001d;!\u0011!\u0019\u0001\u0001#b\u0001\n\u0013yS#\u0001\u0019\u0011\u0005E\t\u0014B\u0001\u001a\u0013\u00055\u0019VM]5bY&T\u0018\r^5p]\"AA\u0007\u0001E\u0001B\u0003&\u0001'\u0001\btKJL\u0017\r\\5{CRLwN\u001c\u0011\t\u0011Y\u0002\u0001R1A\u0005\n]\nA\u0003\u001e:b]N\u0004xN\u001d;J]\u001a|'/\\1uS>tW#\u0001\u001d\u0011\u0007-I4(\u0003\u0002;\u0019\t1q\n\u001d;j_:\u0004\"\u0001P \u000f\u0005Ei\u0014B\u0001 \u0013\u00035\u0019VM]5bY&T\u0018\r^5p]&\u0011\u0001)\u0011\u0002\f\u0013:4wN]7bi&|gN\u0003\u0002?%!A1\t\u0001E\u0001B\u0003&\u0001(A\u000bue\u0006t7\u000f]8si&sgm\u001c:nCRLwN\u001c\u0011\t\u000b\u0015\u0003A\u0011\u0001$\u0002\u0011Q|')\u001b8bef$\"aR'\u0011\u0007-A%*\u0003\u0002J\u0019\t)\u0011I\u001d:bsB\u00111bS\u0005\u0003\u00192\u0011AAQ=uK\")a\n\u0012a\u0001\u0015\u0005\tq\u000eC\u0003Q\u0001\u0011\u0005\u0011+\u0001\u0006ge>l')\u001b8bef$2A\u0003*U\u0011\u0015\u0019v\n1\u0001H\u0003\u0015\u0011\u0017\u0010^3t\u0011\u0015)v\n1\u0001W\u0003!i\u0017M\\5gKN$\bcA\u0006:/B\u0012\u0001,\u0019\t\u00043r{fBA\u0006[\u0013\tYF\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003;z\u0013Qa\u00117bgNT!a\u0017\u0007\u0011\u0005\u0001\fG\u0002\u0001\u0003\nER\u000b\t\u0011!A\u0003\u0002\r\u00141a\u0018\u00132#\t!w\r\u0005\u0002\fK&\u0011a\r\u0004\u0002\b\u001d>$\b.\u001b8h!\tY\u0001.\u0003\u0002j\u0019\t\u0019\u0011I\\=\t\u000b-\u0004A\u0011\u00027\u0002!Mt\u0017\r]:i_R$vNQ5oCJLHCA$n\u0011\u0015q'\u000e1\u0001\u000b\u0003!\u0019h.\u00199tQ>$\b\"\u00029\u0001\t\u0013\t\u0018AE:oCB\u001c\bn\u001c;Ge>l')\u001b8bef$\"A\u0003:\t\u000bM{\u0007\u0019A$\t\u000bQ\u0004A\u0011B;\u0002\u0011]\u0014\u0018\u000e^3J]R$BA^=\u0002\bA\u00111b^\u0005\u0003q2\u0011A!\u00168ji\")!p\u001da\u0001w\u0006aq.\u001e;qkR\u001cFO]3b[B\u0019A0a\u0001\u000e\u0003uT!A`@\u0002\u0005%|'BAA\u0001\u0003\u0011Q\u0017M^1\n\u0007\u0005\u0015QP\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002\nM\u0004\r!a\u0003\u0002\u0003%\u00042aCA\u0007\u0013\r\ty\u0001\u0004\u0002\u0004\u0013:$\bbBA\n\u0001\u0011%\u0011QC\u0001\ne\u0016\fGm\u00155peR$B!a\u0003\u0002\u0018!A\u0011\u0011DA\t\u0001\u0004\tY\"A\u0006j]B,Ho\u0015;sK\u0006l\u0007c\u0001?\u0002\u001e%\u0019\u0011qD?\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003G\u0001A\u0011BA\u0013\u0003\u001d\u0011X-\u00193J]R$B!a\u0003\u0002(!A\u0011\u0011DA\u0011\u0001\u0004\tYbB\u0004\u0002,\tA\t!!\f\u0002%Ms\u0017\r]:i_R\u001cVM]5bY&TXM\u001d\t\u0004I\u0005=bAB\u0001\u0003\u0011\u0003\t\tdE\u0002\u00020)Aq!IA\u0018\t\u0003\t)\u0004\u0006\u0002\u0002.!Q\u0011\u0011HA\u0018\u0005\u0004%\t!a\u000f\u0002\u0007-,\u00170F\u0001H\u0011!\ty$a\f!\u0002\u00139\u0015\u0001B6fs\u0002B!\"a\u0011\u00020\t\u0007I\u0011AA#\u0003\u0019ygMZ:fiV\u0011\u00111\u0002\u0005\n\u0003\u0013\ny\u0003)A\u0005\u0003\u0017\tqa\u001c4gg\u0016$\b\u0005\u0003\u0006\u0002N\u0005=\"\u0019!C\u0001\u0003w\t1B]3qY\u0006\u001cW-\\3oi\"A\u0011\u0011KA\u0018A\u0003%q)\u0001\u0007sKBd\u0017mY3nK:$\b\u0005C\u0005\u0002V\u0005=\"\u0019!C\u0001Q\u00059Am\u001c)bi\u000eD\u0007\u0002CA-\u0003_\u0001\u000b\u0011B\u0015\u0002\u0011\u0011|\u0007+\u0019;dQ\u0002\u0002")
public class SnapshotSerializer
implements BaseSerializer {
    private final ExtendedActorSystem system;
    private final boolean includeManifest;
    private Serialization serialization;
    private Option<Serialization.Information> transportInformation;
    private final int identifier;
    private volatile byte bitmap$0;

    public static boolean doPatch() {
        return SnapshotSerializer$.MODULE$.doPatch();
    }

    public static byte[] replacement() {
        return SnapshotSerializer$.MODULE$.replacement();
    }

    public static int offset() {
        return SnapshotSerializer$.MODULE$.offset();
    }

    public static byte[] key() {
        return SnapshotSerializer$.MODULE$.key();
    }

    private Serialization serialization$lzycompute() {
        SnapshotSerializer snapshotSerializer = this;
        synchronized (snapshotSerializer) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.system());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.serialization;
        }
    }

    private Option transportInformation$lzycompute() {
        SnapshotSerializer snapshotSerializer = this;
        synchronized (snapshotSerializer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Address address = this.system().provider().getDefaultAddress();
                this.transportInformation = address.hasLocalScope() ? None$.MODULE$ : new Some<Serialization.Information>(new Serialization.Information(address, this.system()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.transportInformation;
        }
    }

    @Override
    public final String SerializationIdentifiers() {
        return "akka.actor.serialization-identifiers";
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void akka$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    @Override
    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer$class.identifierFromConfig(this);
    }

    @Override
    public final Object fromBinary(byte[] bytes) {
        return Serializer$class.fromBinary(this, bytes);
    }

    @Override
    public final Object fromBinary(byte[] bytes, Class<?> clazz) {
        return Serializer$class.fromBinary(this, bytes, clazz);
    }

    @Override
    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return this.includeManifest;
    }

    private Serialization serialization() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.serialization$lzycompute() : this.serialization;
    }

    private Option<Serialization.Information> transportInformation() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.transportInformation$lzycompute() : this.transportInformation;
    }

    @Override
    public byte[] toBinary(Object o) {
        Object object = o;
        if (object instanceof Snapshot) {
            Snapshot snapshot = (Snapshot)object;
            Object data = snapshot.data();
            byte[] byArray = this.snapshotToBinary(data);
            return byArray;
        }
        throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't serialize object of type ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{o.getClass()})));
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return new Snapshot(this.snapshotFromBinary(bytes));
    }

    private byte[] snapshotToBinary(Object snapshot) {
        Option<Serialization.Information> option;
        block4: {
            byte[] byArray;
            block3: {
                block2: {
                    option = this.transportInformation();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Serialization.Information ti = (Serialization.Information)some.x();
                    byArray = Serialization$.MODULE$.currentTransportInformation().withValue(ti, new Serializable(this, snapshot){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ SnapshotSerializer $outer;
                        private final Object snapshot$1;

                        public final byte[] apply() {
                            return this.$outer.akka$persistence$serialization$SnapshotSerializer$$serialize$1(this.snapshot$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.snapshot$1 = snapshot$1;
                        }
                    });
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                byArray = this.akka$persistence$serialization$SnapshotSerializer$$serialize$1(snapshot);
            }
            return byArray;
        }
        throw new MatchError(option);
    }

    private Object snapshotFromBinary(byte[] bytes) {
        Option option;
        ByteArrayInputStream in2 = new ByteArrayInputStream(bytes);
        int headerLength = this.akka$persistence$serialization$SnapshotSerializer$$readInt(in2);
        byte[] headerBytes = (byte[])Predef$.MODULE$.byteArrayOps(bytes).slice(4, headerLength + 4);
        byte[] snapshotBytes = (byte[])Predef$.MODULE$.byteArrayOps(bytes).drop(headerLength + 4);
        if (this.readShort(in2) == 60844) {
            byte[] b = SnapshotSerializer$.MODULE$.doPatch() ? this.patch$1(headerBytes) : headerBytes;
            option = this.serialization().deserialize(b, SnapshotHeader.class).toOption();
        } else {
            option = None$.MODULE$;
        }
        None$ oldHeader = option;
        SnapshotHeader header = oldHeader.getOrElse(new Serializable(this, headerBytes){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SnapshotSerializer $outer;
            private final byte[] headerBytes$1;

            public final SnapshotHeader apply() {
                Option option;
                ByteArrayInputStream headerIn = new ByteArrayInputStream(this.headerBytes$1);
                int serializerId = this.$outer.akka$persistence$serialization$SnapshotSerializer$$readInt(headerIn);
                int remaining = headerIn.available();
                if (remaining == 0) {
                    option = None$.MODULE$;
                } else {
                    byte[] manifestBytes = (byte[])Array$.MODULE$.ofDim(remaining, ClassTag$.MODULE$.Byte());
                    headerIn.read(manifestBytes);
                    option = new Some<String>(new String(manifestBytes, ByteString$.MODULE$.UTF_8()));
                }
                None$ manifest = option;
                return new SnapshotHeader(serializerId, manifest);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.headerBytes$1 = headerBytes$1;
            }
        });
        return this.serialization().deserialize(snapshotBytes, header.serializerId(), header.manifest().getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).get();
    }

    private void writeInt(OutputStream outputStream, int i) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 24).by(8).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, outputStream, i){
            public static final long serialVersionUID = 0L;
            private final OutputStream outputStream$1;
            private final int i$1;

            public final void apply(int shift) {
                this.apply$mcVI$sp(shift);
            }

            public void apply$mcVI$sp(int shift) {
                this.outputStream$1.write(this.i$1 >> shift);
            }
            {
                this.outputStream$1 = outputStream$1;
                this.i$1 = i$1;
            }
        }));
    }

    private int readShort(InputStream inputStream) {
        int ch1 = inputStream.read();
        int ch2 = inputStream.read();
        return ch2 << 8 | ch1;
    }

    public int akka$persistence$serialization$SnapshotSerializer$$readInt(InputStream inputStream) {
        int sh1 = this.readShort(inputStream);
        int sh2 = this.readShort(inputStream);
        return sh2 << 16 | sh1;
    }

    public final byte[] akka$persistence$serialization$SnapshotSerializer$$serialize$1(Object snapshot$1) {
        Serializer snapshotSerializer = this.serialization().findSerializerFor(snapshot$1);
        ByteArrayOutputStream headerOut = new ByteArrayOutputStream();
        this.writeInt(headerOut, snapshotSerializer.identifier());
        Serializer serializer = snapshotSerializer;
        if (serializer instanceof SerializerWithStringManifest) {
            BoxedUnit boxedUnit;
            String manifest;
            SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
            String string2 = manifest = serializerWithStringManifest.manifest(snapshot$1);
            String string3 = "";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                headerOut.write(manifest.getBytes(ByteString$.MODULE$.UTF_8()));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit;
            if (snapshotSerializer.includeManifest()) {
                headerOut.write(snapshot$1.getClass().getName().getBytes(ByteString$.MODULE$.UTF_8()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        }
        byte[] headerBytes = headerOut.toByteArray();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, headerBytes.length);
        out.write(headerBytes);
        out.write(snapshotSerializer.toBinary(snapshot$1));
        return out.toByteArray();
    }

    private final int find$1(int pos, int offset, byte[] b$1) {
        while (true) {
            block7: {
                int n;
                block6: {
                    block5: {
                        if (pos != b$1.length) break block5;
                        n = -1;
                        break block6;
                    }
                    if (offset != SnapshotSerializer$.MODULE$.key().length) break block7;
                    n = pos;
                }
                return n;
            }
            if (b$1[pos + offset] == SnapshotSerializer$.MODULE$.key()[offset]) {
                ++offset;
                continue;
            }
            offset = 0;
            ++pos;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] patch$1(byte[] b) {
        byte[] byArray;
        int found = this.find$1(0, 0, b);
        if (found == -1) {
            byArray = b;
        } else {
            void var3_3;
            byte[] n = new byte[b.length];
            int start2 = found + SnapshotSerializer$.MODULE$.offset();
            int end = start2 + SnapshotSerializer$.MODULE$.replacement().length;
            System.arraycopy(b, 0, n, 0, start2);
            System.arraycopy(SnapshotSerializer$.MODULE$.replacement(), 0, n, start2, SnapshotSerializer$.MODULE$.replacement().length);
            System.arraycopy(b, end, n, end, b.length - end);
            byArray = var3_3;
        }
        return byArray;
    }

    public SnapshotSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer$class.$init$(this);
        BaseSerializer$class.$init$(this);
        this.includeManifest = false;
    }
}

