/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.journal.leveldb;

import akka.dispatch.MessageDispatcher;
import akka.persistence.PersistentRepr;
import akka.persistence.journal.leveldb.Key;
import akka.persistence.journal.leveldb.Key$;
import akka.persistence.journal.leveldb.LeveldbJournal;
import akka.persistence.journal.leveldb.LeveldbStore;
import java.util.Map;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.ReadOptions;
import scala.Function1;
import scala.Serializable;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;

public abstract class LeveldbRecovery$class {
    public static String akka$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcherId(LeveldbStore $this) {
        return $this.config().getString("replay-dispatcher");
    }

    public static MessageDispatcher akka$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcher(LeveldbStore $this) {
        return $this.context().system().dispatchers().lookup($this.akka$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcherId());
    }

    public static Future asyncReadHighestSequenceNr(LeveldbStore $this, String persistenceId, long fromSequenceNr) {
        int nid = $this.numericId(persistenceId);
        return Future$.MODULE$.apply(new Serializable($this, nid){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeveldbStore $outer;
            private final int nid$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.readHighestSequenceNr(this.nid$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nid$1 = nid$1;
            }
        }, $this.akka$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcher());
    }

    public static Future asyncReplayMessages(LeveldbStore $this, String persistenceId, long fromSequenceNr, long toSequenceNr, long max2, Function1 replayCallback) {
        int nid = $this.numericId(persistenceId);
        return Future$.MODULE$.apply(new Serializable($this, nid, fromSequenceNr, toSequenceNr, max2, replayCallback){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeveldbStore $outer;
            private final int nid$2;
            private final long fromSequenceNr$1;
            private final long toSequenceNr$1;
            private final long max$1;
            private final Function1 replayCallback$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.replayMessages(this.nid$2, this.fromSequenceNr$1, this.toSequenceNr$1, this.max$1, this.replayCallback$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nid$2 = nid$2;
                this.fromSequenceNr$1 = fromSequenceNr$1;
                this.toSequenceNr$1 = toSequenceNr$1;
                this.max$1 = max$1;
                this.replayCallback$1 = replayCallback$1;
            }
        }, $this.akka$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcher());
    }

    public static void replayMessages(LeveldbStore $this, int persistenceId, long fromSequenceNr, long toSequenceNr, long max2, Function1 replayCallback) {
        $this.withIterator(new Serializable($this, persistenceId, fromSequenceNr, toSequenceNr, max2, replayCallback){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeveldbStore $outer;
            private final int persistenceId$1;
            private final long fromSequenceNr$2;
            private final long toSequenceNr$2;
            private final long max$2;
            private final Function1 replayCallback$2;

            public final void apply(DBIterator iter2) {
                Key startKey = new Key(this.persistenceId$1, this.fromSequenceNr$2 < 1L ? 1L : this.fromSequenceNr$2, 0);
                iter2.seek(Key$.MODULE$.keyToBytes(startKey));
                LeveldbRecovery$class.go$1(this.$outer, iter2, startKey, 0L, this.replayCallback$2, this.toSequenceNr$2, this.max$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.persistenceId$1 = persistenceId$1;
                this.fromSequenceNr$2 = fromSequenceNr$2;
                this.toSequenceNr$2 = toSequenceNr$2;
                this.max$2 = max$2;
                this.replayCallback$2 = replayCallback$2;
            }
        });
    }

    public static Future asyncReplayTaggedMessages(LeveldbStore $this, String tag, long fromSequenceNr, long toSequenceNr, long max2, Function1 replayCallback) {
        int tagNid = $this.tagNumericId(tag);
        return Future$.MODULE$.apply(new Serializable($this, tagNid, tag, fromSequenceNr, toSequenceNr, max2, replayCallback){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeveldbStore $outer;
            private final int tagNid$1;
            private final String tag$1;
            private final long fromSequenceNr$3;
            private final long toSequenceNr$3;
            private final long max$3;
            private final Function1 replayCallback$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.replayTaggedMessages(this.tag$1, this.tagNid$1, this.fromSequenceNr$3, this.toSequenceNr$3, this.max$3, this.replayCallback$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tagNid$1 = tagNid$1;
                this.tag$1 = tag$1;
                this.fromSequenceNr$3 = fromSequenceNr$3;
                this.toSequenceNr$3 = toSequenceNr$3;
                this.max$3 = max$3;
                this.replayCallback$3 = replayCallback$3;
            }
        }, $this.akka$persistence$journal$leveldb$LeveldbRecovery$$replayDispatcher());
    }

    public static void replayTaggedMessages(LeveldbStore $this, String tag, int tagNid, long fromSequenceNr, long toSequenceNr, long max2, Function1 replayCallback) {
        $this.withIterator(new Serializable($this, tag, tagNid, fromSequenceNr, toSequenceNr, max2, replayCallback){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeveldbStore $outer;
            private final String tag$2;
            private final int tagNid$2;
            private final long fromSequenceNr$4;
            private final long toSequenceNr$4;
            private final long max$4;
            private final Function1 replayCallback$4;

            public final void apply(DBIterator iter2) {
                Key startKey = new Key(this.tagNid$2, this.fromSequenceNr$4 < 1L ? 1L : this.fromSequenceNr$4, 0);
                iter2.seek(Key$.MODULE$.keyToBytes(startKey));
                LeveldbRecovery$class.go$2(this.$outer, iter2, startKey, 0L, this.replayCallback$4, this.tag$2, this.toSequenceNr$4, this.max$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tag$2 = tag$2;
                this.tagNid$2 = tagNid$2;
                this.fromSequenceNr$4 = fromSequenceNr$4;
                this.toSequenceNr$4 = toSequenceNr$4;
                this.max$4 = max$4;
                this.replayCallback$4 = replayCallback$4;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static long readHighestSequenceNr(LeveldbStore $this, int persistenceId) {
        long l;
        ReadOptions ro = $this.leveldbSnapshot();
        try {
            byte[] byArray = $this.leveldb().get(Key$.MODULE$.keyToBytes(Key$.MODULE$.counterKey(persistenceId)), ro);
            long l2 = byArray == null ? 0L : Key$.MODULE$.counterFromBytes(byArray);
            l = l2;
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.snapshot().close();
            throw throwable;
        }
        ro.snapshot().close();
        return l;
    }

    public static final void go$1(LeveldbStore $this, DBIterator iter2, Key key, long ctr, Function1 replayCallback, long toSequenceNr$2, long max$2) {
        block7: {
            BoxedUnit boxedUnit;
            while (iter2.hasNext()) {
                Map.Entry nextEntry = (Map.Entry)iter2.next();
                Key nextKey = Key$.MODULE$.keyFromBytes((byte[])nextEntry.getKey());
                if (nextKey.sequenceNr() > toSequenceNr$2) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (Key$.MODULE$.isDeletionKey(nextKey)) {
                        key = nextKey;
                        continue;
                    }
                    if (key.persistenceId() == nextKey.persistenceId()) {
                        PersistentRepr msg = $this.persistentFromBytes((byte[])nextEntry.getValue());
                        boolean del = LeveldbRecovery$class.deletion$1($this, iter2, nextKey);
                        if (ctr < max$2) {
                            BoxedUnit boxedUnit2 = del ? BoxedUnit.UNIT : replayCallback.apply(msg);
                            ++ctr;
                            key = nextKey;
                            continue;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                break block7;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final boolean deletion$1(LeveldbStore $this, DBIterator iter2, Key key) {
        boolean bl;
        if (iter2.hasNext()) {
            Map.Entry nextEntry = iter2.peekNext();
            Key nextKey = Key$.MODULE$.keyFromBytes((byte[])nextEntry.getKey());
            if (key.persistenceId() == nextKey.persistenceId() && key.sequenceNr() == nextKey.sequenceNr() && Key$.MODULE$.isDeletionKey(nextKey)) {
                iter2.next();
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static final void go$2(LeveldbStore $this, DBIterator iter2, Key key, long ctr, Function1 replayCallback, String tag$2, long toSequenceNr$4, long max$4) {
        block6: {
            BoxedUnit boxedUnit;
            while (iter2.hasNext()) {
                Map.Entry nextEntry = (Map.Entry)iter2.next();
                Key nextKey = Key$.MODULE$.keyFromBytes((byte[])nextEntry.getKey());
                if (nextKey.sequenceNr() > toSequenceNr$4) {
                    boxedUnit = BoxedUnit.UNIT;
                } else if (key.persistenceId() == nextKey.persistenceId()) {
                    PersistentRepr msg = $this.persistentFromBytes((byte[])nextEntry.getValue());
                    if (ctr < max$4) {
                        replayCallback.apply(new LeveldbJournal.ReplayedTaggedMessage(msg, tag$2, nextKey.sequenceNr()));
                        ++ctr;
                        key = nextKey;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                break block6;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static void $init$(LeveldbStore $this) {
    }
}

