/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.package$;
import akka.persistence.JournalProtocol;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.PersistentRepr;
import akka.persistence.PersistentView;
import akka.persistence.PersistentView$;
import akka.persistence.Recovery;
import akka.persistence.Recovery$;
import akka.persistence.SelectedSnapshot;
import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotOffer;
import akka.persistence.SnapshotProtocol;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.Update;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public abstract class PersistentView$class {
    public static ActorRef journal(PersistentView $this) {
        return $this.akka$persistence$PersistentView$$extension().journalFor($this.journalPluginId());
    }

    public static ActorRef snapshotStore(PersistentView $this) {
        return $this.akka$persistence$PersistentView$$extension().snapshotStoreFor($this.snapshotPluginId());
    }

    public static String snapshotterId(PersistentView $this) {
        return $this.viewId();
    }

    public static boolean isPersistent(PersistentView $this) {
        return $this.akka$persistence$PersistentView$$currentState().recoveryRunning();
    }

    public static boolean autoUpdate(PersistentView $this) {
        return $this.akka$persistence$PersistentView$$viewSettings().autoUpdate();
    }

    public static FiniteDuration autoUpdateInterval(PersistentView $this) {
        return $this.akka$persistence$PersistentView$$viewSettings().autoUpdateInterval();
    }

    public static long autoUpdateReplayMax(PersistentView $this) {
        long l = $this.akka$persistence$PersistentView$$viewSettings().autoUpdateReplayMax();
        long l2 = -1L == l ? Long.MAX_VALUE : l;
        return l2;
    }

    public static long lastSequenceNr(PersistentView $this) {
        return $this.akka$persistence$PersistentView$$_lastSequenceNr();
    }

    public static long snapshotSequenceNr(PersistentView $this) {
        return $this.lastSequenceNr();
    }

    public static void akka$persistence$PersistentView$$setLastSequenceNr(PersistentView $this, long value2) {
        $this.akka$persistence$PersistentView$$_lastSequenceNr_$eq(value2);
    }

    public static void akka$persistence$PersistentView$$updateLastSequenceNr(PersistentView $this, PersistentRepr persistent) {
        if (persistent.sequenceNr() > $this.akka$persistence$PersistentView$$_lastSequenceNr()) {
            $this.akka$persistence$PersistentView$$_lastSequenceNr_$eq(persistent.sequenceNr());
        }
    }

    public static Recovery recovery(PersistentView $this) {
        long x$2 = $this.autoUpdateReplayMax();
        SnapshotSelectionCriteria x$3 = Recovery$.MODULE$.apply$default$1();
        long x$4 = Recovery$.MODULE$.apply$default$2();
        return new Recovery(x$3, x$4, x$2);
    }

    public static void preStart(PersistentView $this) {
        PersistentView$class.startRecovery($this, $this.recovery());
        if ($this.autoUpdate()) {
            $this.akka$persistence$PersistentView$$schedule_$eq(new Some<Cancellable>($this.context().system().scheduler().schedule($this.autoUpdateInterval(), $this.autoUpdateInterval(), $this.self(), new PersistentView.ScheduledUpdate($this.autoUpdateReplayMax()), $this.context().dispatcher(), $this.self())));
        }
    }

    private static void startRecovery(PersistentView $this, Recovery recovery) {
        PersistentView$class.akka$persistence$PersistentView$$changeState($this, PersistentView$class.recoveryStarted($this, recovery.replayMax()));
        $this.loadSnapshot($this.snapshotterId(), recovery.fromSnapshot(), recovery.toSequenceNr());
    }

    public static void aroundReceive(PersistentView $this, PartialFunction receive2, Object message) {
        $this.akka$persistence$PersistentView$$currentState().stateReceive(receive2, message);
    }

    public static void aroundPreStart(PersistentView $this) {
        ActorRef j = $this.journal();
        ActorRef s2 = $this.snapshotStore();
        $this.akka$persistence$PersistentView$$super$aroundPreStart();
    }

    public static void preRestart(PersistentView $this, Throwable reason, Option message) {
        try {
            $this.akka$persistence$PersistentView$$internalStash().unstashAll();
            return;
        }
        finally {
            $this.akka$persistence$PersistentView$$super$preRestart(reason, message);
        }
    }

    public static void postStop(PersistentView $this) {
        $this.akka$persistence$PersistentView$$schedule().foreach(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Cancellable x$1) {
                return x$1.cancel();
            }
        });
        $this.akka$persistence$PersistentView$$super$postStop();
    }

    public static void onReplayError(PersistentView $this, Throwable cause) {
        $this.log().error(cause, "Persistence view failure when replaying events for persistenceId [{}]. Last known sequence number [{}]", (Object)$this.persistenceId(), (Object)BoxesRunTime.boxToLong($this.lastSequenceNr()));
    }

    public static void akka$persistence$PersistentView$$changeState(PersistentView $this, PersistentView.State state) {
        $this.akka$persistence$PersistentView$$currentState_$eq(state);
    }

    private static PersistentView.State recoveryStarted(PersistentView $this, long replayMax) {
        return new PersistentView.State($this, replayMax){
            private final /* synthetic */ PersistentView $outer;
            private final long replayMax$1;

            public String toString() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"recovery started (replayMax = [", "])"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.replayMax$1)}));
            }

            public boolean recoveryRunning() {
                return true;
            }

            public void stateReceive(PartialFunction<Object, BoxedUnit> receive2, Object message) {
                Object object = message;
                if (object instanceof SnapshotProtocol.LoadSnapshotResult) {
                    SnapshotProtocol.LoadSnapshotResult loadSnapshotResult = (SnapshotProtocol.LoadSnapshotResult)object;
                    Option<SelectedSnapshot> sso = loadSnapshotResult.snapshot();
                    long toSnr = loadSnapshotResult.toSequenceNr();
                    sso.foreach(new Serializable(this, receive2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ PersistentView$.anon.1 $outer;
                        private final PartialFunction receive$1;

                        public final void apply(SelectedSnapshot x0$1) {
                            SelectedSnapshot selectedSnapshot = x0$1;
                            if (selectedSnapshot != null) {
                                SnapshotMetadata metadata = selectedSnapshot.metadata();
                                Object snapshot = selectedSnapshot.snapshot();
                                PersistentView$class.akka$persistence$PersistentView$$setLastSequenceNr(this.$outer.akka$persistence$PersistentView$$anon$$$outer(), metadata.sequenceNr());
                                this.$outer.akka$persistence$PersistentView$$anon$$$outer().akka$persistence$PersistentView$$super$aroundReceive(this.receive$1, new SnapshotOffer(metadata, snapshot));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(selectedSnapshot);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.receive$1 = receive$1;
                        }
                    });
                    PersistentView$class.akka$persistence$PersistentView$$changeState(this.$outer, PersistentView$class.akka$persistence$PersistentView$$replayStarted(this.$outer, true));
                    package$.MODULE$.actorRef2Scala(this.$outer.journal()).$bang(new JournalProtocol.ReplayMessages(this.$outer.lastSequenceNr() + 1L, toSnr, this.replayMax$1, this.$outer.persistenceId(), this.$outer.self()), this.$outer.self());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.akka$persistence$PersistentView$$internalStash().stash();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public /* synthetic */ PersistentView akka$persistence$PersistentView$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replayMax$1 = replayMax$1;
            }
        };
    }

    public static PersistentView.State akka$persistence$PersistentView$$replayStarted(PersistentView $this, boolean await) {
        return new PersistentView.State($this, await){
            private final /* synthetic */ PersistentView $outer;
            private final boolean await$1;

            public String toString() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replay started"})).s(Nil$.MODULE$);
            }

            public boolean recoveryRunning() {
                return true;
            }

            /*
             * Loose catch block
             */
            public void stateReceive(PartialFunction<Object, BoxedUnit> receive2, Object message) {
                block14: {
                    BoxedUnit boxedUnit;
                    block18: {
                        BoxedUnit boxedUnit2;
                        Object object;
                        block17: {
                            block16: {
                                BoxedUnit boxedUnit3;
                                block15: {
                                    block13: {
                                        object = message;
                                        if (object instanceof JournalProtocol.ReplayedMessage) {
                                            JournalProtocol.ReplayedMessage replayedMessage = (JournalProtocol.ReplayedMessage)object;
                                            PersistentRepr p = replayedMessage.persistent();
                                            PersistentView$class.akka$persistence$PersistentView$$updateLastSequenceNr(this.$outer, p);
                                            this.$outer.akka$persistence$PersistentView$$super$aroundReceive(receive2, p.payload());
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        }
                                        if (!(object instanceof JournalProtocol.RecoverySuccess)) break block13;
                                        this.onReplayComplete();
                                        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                                        break block14;
                                    }
                                    if (object instanceof JournalProtocol.ReplayMessagesFailure) {
                                        JournalProtocol.ReplayMessagesFailure replayMessagesFailure = (JournalProtocol.ReplayMessagesFailure)object;
                                        Throwable cause = replayMessagesFailure.cause();
                                        this.$outer.onReplayError(cause);
                                        BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                                    }
                                    if (!(object instanceof PersistentView.ScheduledUpdate)) break block15;
                                    BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                                    break block14;
                                }
                                if (!(object instanceof Update)) break block16;
                                Update update2 = (Update)object;
                                boolean a = update2.await();
                                if (a) {
                                    this.$outer.akka$persistence$PersistentView$$internalStash().stash();
                                    boxedUnit3 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit3 = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit7 = boxedUnit3;
                                break block14;
                            }
                            if (!this.await$1) break block17;
                            this.$outer.akka$persistence$PersistentView$$internalStash().stash();
                            boxedUnit = BoxedUnit.UNIT;
                            break block18;
                        }
                        this.$outer.akka$persistence$PersistentView$$super$aroundReceive(receive2, object);
                        boxedUnit = BoxedUnit.UNIT;
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable t = option.get();
                            PersistentView$class.akka$persistence$PersistentView$$changeState(this.$outer, PersistentView$class.akka$persistence$PersistentView$$ignoreRemainingReplay(this.$outer, t));
                            BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit9 = boxedUnit2;
                        break block14;
                        finally {
                            this.onReplayComplete();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable3 = throwable;
                            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable3);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable t = option.get();
                            PersistentView$class.akka$persistence$PersistentView$$changeState(this.$outer, PersistentView$class.akka$persistence$PersistentView$$ignoreRemainingReplay(this.$outer, t));
                            BoxedUnit boxedUnit10 = BoxedUnit.UNIT;
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    BoxedUnit boxedUnit11 = boxedUnit;
                }
            }

            private void onReplayComplete() {
                PersistentView$class.akka$persistence$PersistentView$$changeState(this.$outer, this.$outer.akka$persistence$PersistentView$$idle());
                this.$outer.akka$persistence$PersistentView$$internalStash().unstashAll();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.await$1 = await$1;
            }
        };
    }

    public static PersistentView.State akka$persistence$PersistentView$$ignoreRemainingReplay(PersistentView $this, Throwable cause) {
        return new PersistentView.State($this, cause){
            private final /* synthetic */ PersistentView $outer;
            private final Throwable cause$1;

            public String toString() {
                return "replay failed";
            }

            public boolean recoveryRunning() {
                return true;
            }

            public void stateReceive(PartialFunction<Object, BoxedUnit> receive2, Object message) {
                Object object = message;
                if (object instanceof JournalProtocol.ReplayedMessage) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof JournalProtocol.ReplayMessagesFailure) {
                    this.replayCompleted(receive2);
                    PersistentView$class.akka$persistence$PersistentView$$setLastSequenceNr(this.$outer, Long.MAX_VALUE);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof JournalProtocol.RecoverySuccess) {
                    this.replayCompleted(receive2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.akka$persistence$PersistentView$$internalStash().stash();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public void replayCompleted(PartialFunction<Object, BoxedUnit> receive2) {
                PersistentView$class.akka$persistence$PersistentView$$changeState(this.$outer, this.$outer.akka$persistence$PersistentView$$idle());
                this.$outer.akka$persistence$PersistentView$$internalStash().unstashAll();
                throw this.cause$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.cause$1 = cause$1;
            }
        };
    }

    public static void $init$(PersistentView $this) {
        $this.akka$persistence$PersistentView$_setter_$akka$persistence$PersistentView$$extension_$eq((Persistence)Persistence$.MODULE$.apply($this.context().system()));
        $this.akka$persistence$PersistentView$_setter_$akka$persistence$PersistentView$$viewSettings_$eq($this.akka$persistence$PersistentView$$extension().settings().view());
        $this.akka$persistence$PersistentView$$schedule_$eq(None$.MODULE$);
        $this.akka$persistence$PersistentView$$_lastSequenceNr_$eq(0L);
        $this.akka$persistence$PersistentView$_setter_$akka$persistence$PersistentView$$internalStash_$eq($this.createStash($this.context(), $this.self()));
        $this.akka$persistence$PersistentView$$currentState_$eq(PersistentView$class.recoveryStarted($this, Long.MAX_VALUE));
        $this.akka$persistence$PersistentView$_setter_$akka$persistence$PersistentView$$idle_$eq(new PersistentView.State($this){
            private final /* synthetic */ PersistentView $outer;

            public String toString() {
                return "idle";
            }

            public boolean recoveryRunning() {
                return false;
            }

            public void stateReceive(PartialFunction<Object, BoxedUnit> receive2, Object message) {
                Object object = message;
                if (object instanceof JournalProtocol.ReplayedMessage) {
                    JournalProtocol.ReplayedMessage replayedMessage = (JournalProtocol.ReplayedMessage)object;
                    PersistentRepr p = replayedMessage.persistent();
                    this.$outer.akka$persistence$PersistentView$$super$aroundReceive(receive2, p.payload());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof PersistentView.ScheduledUpdate) {
                    PersistentView.ScheduledUpdate scheduledUpdate = (PersistentView.ScheduledUpdate)object;
                    long replayMax = scheduledUpdate.replayMax();
                    this.changeStateToReplayStarted(false, replayMax);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof Update) {
                    Update update2 = (Update)object;
                    boolean awaitUpdate = update2.await();
                    long replayMax = update2.replayMax();
                    this.changeStateToReplayStarted(awaitUpdate, replayMax);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.akka$persistence$PersistentView$$super$aroundReceive(receive2, object);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            private void changeStateToReplayStarted(boolean await, long replayMax) {
                PersistentView$class.akka$persistence$PersistentView$$changeState(this.$outer, PersistentView$class.akka$persistence$PersistentView$$replayStarted(this.$outer, await));
                package$.MODULE$.actorRef2Scala(this.$outer.journal()).$bang(new JournalProtocol.ReplayMessages(this.$outer.lastSequenceNr() + 1L, Long.MAX_VALUE, replayMax, this.$outer.persistenceId(), this.$outer.self()), this.$outer.self());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

