/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence;

import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.DeadLetter;
import akka.actor.StashOverflowException;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.persistence.AtomicWrite;
import akka.persistence.AtomicWrite$;
import akka.persistence.DeleteMessagesFailure;
import akka.persistence.DeleteSnapshotFailure;
import akka.persistence.DeleteSnapshotsFailure;
import akka.persistence.DiscardToDeadLetterStrategy$;
import akka.persistence.Eventsourced;
import akka.persistence.Eventsourced$;
import akka.persistence.JournalProtocol;
import akka.persistence.NonPersistentRepr;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.PersistentEnvelope;
import akka.persistence.PersistentRepr;
import akka.persistence.PersistentRepr$;
import akka.persistence.Recovery;
import akka.persistence.RecoveryCompleted$;
import akka.persistence.RecoveryPermitter$RecoveryPermitGranted$;
import akka.persistence.RecoveryPermitter$RequestRecoveryPermit$;
import akka.persistence.RecoveryPermitter$ReturnRecoveryPermit$;
import akka.persistence.RecoveryTimedOut;
import akka.persistence.ReplyToStrategy;
import akka.persistence.SaveSnapshotFailure;
import akka.persistence.SelectedSnapshot;
import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotOffer;
import akka.persistence.SnapshotProtocol;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.StashOverflowStrategy;
import akka.persistence.ThrowOverflowExceptionStrategy$;
import akka.util.Helpers$;
import akka.util.Helpers$ConfigOps$;
import java.util.LinkedList;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public abstract class Eventsourced$class {
    public static ActorRef journal(Eventsourced $this) {
        return $this.akka$persistence$Eventsourced$$extension().journalFor($this.journalPluginId());
    }

    public static ActorRef snapshotStore(Eventsourced $this) {
        return $this.akka$persistence$Eventsourced$$extension().snapshotStoreFor($this.snapshotPluginId());
    }

    public static String snapshotterId(Eventsourced $this) {
        return $this.persistenceId();
    }

    public static long lastSequenceNr(Eventsourced $this) {
        return $this.akka$persistence$Eventsourced$$_lastSequenceNr();
    }

    public static long snapshotSequenceNr(Eventsourced $this) {
        return $this.lastSequenceNr();
    }

    public static void onReplaySuccess(Eventsourced $this) {
    }

    public static void onRecoveryFailure(Eventsourced $this, Throwable cause, Option event) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = event;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Object evt = some.x();
                    Eventsourced$class.log($this).error(cause, "Exception in receiveRecover when replaying event type [{}] with sequence number [{}] for persistenceId [{}].", (Object)evt.getClass().getName(), (Object)BoxesRunTime.boxToLong($this.lastSequenceNr()), (Object)$this.persistenceId());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                Eventsourced$class.log($this).error(cause, "Persistence failure when replaying events for persistenceId [{}]. Last known sequence number [{}]", (Object)$this.persistenceId(), (Object)BoxesRunTime.boxToLong($this.lastSequenceNr()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    public static void onPersistFailure(Eventsourced $this, Throwable cause, Object event, long seqNr) {
        Eventsourced$class.log($this).error(cause, "Failed to persist event type [{}] with sequence number [{}] for persistenceId [{}].", (Object)event.getClass().getName(), (Object)BoxesRunTime.boxToLong(seqNr), (Object)$this.persistenceId());
    }

    public static void onPersistRejected(Eventsourced $this, Throwable cause, Object event, long seqNr) {
        Eventsourced$class.log($this).warning("Rejected to persist event type [{}] with sequence number [{}] for persistenceId [{}] due to [{}].", event.getClass().getName(), BoxesRunTime.boxToLong(seqNr), $this.persistenceId(), cause.getMessage());
    }

    public static void akka$persistence$Eventsourced$$stashInternally(Eventsourced $this, Object currMsg) {
        StashOverflowStrategy stashOverflowStrategy;
        StashOverflowException stashOverflowException2;
        block4: {
            try {
                $this.akka$persistence$Eventsourced$$internalStash().stash();
            }
            catch (StashOverflowException stashOverflowException2) {
                stashOverflowStrategy = $this.internalStashOverflowStrategy();
                if (DiscardToDeadLetterStrategy$.MODULE$.equals(stashOverflowStrategy)) {
                    ActorRef snd = $this.sender();
                    $this.context().system().deadLetters().tell(new DeadLetter(currMsg, snd, $this.self()), snd);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                if (!(stashOverflowStrategy instanceof ReplyToStrategy)) break block4;
                ReplyToStrategy replyToStrategy = (ReplyToStrategy)stashOverflowStrategy;
                Object response = replyToStrategy.response();
                akka.actor.package$.MODULE$.actorRef2Scala($this.sender()).$bang(response, $this.self());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        if (ThrowOverflowExceptionStrategy$.MODULE$.equals(stashOverflowStrategy)) {
            throw stashOverflowException2;
        }
        throw new MatchError(stashOverflowStrategy);
    }

    public static void akka$persistence$Eventsourced$$unstashInternally(Eventsourced $this, boolean all) {
        if (all) {
            $this.akka$persistence$Eventsourced$$internalStash().unstashAll();
        } else {
            $this.akka$persistence$Eventsourced$$internalStash().unstash();
        }
    }

    public static void akka$persistence$Eventsourced$$startRecovery(Eventsourced $this, Recovery recovery) {
        Eventsourced$class.akka$persistence$Eventsourced$$changeState($this, Eventsourced$class.recoveryStarted($this, recovery.replayMax()));
        $this.loadSnapshot($this.snapshotterId(), recovery.fromSnapshot(), recovery.toSequenceNr());
    }

    public static void aroundReceive(Eventsourced $this, PartialFunction receive2, Object message) {
        $this.akka$persistence$Eventsourced$$currentState().stateReceive(receive2, message);
    }

    public static void aroundPreStart(Eventsourced $this) {
        Predef$.MODULE$.require($this.persistenceId() != null, (Function0<Object>)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Eventsourced $outer;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"persistenceId is [null] for PersistentActor [", "]"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.self().path()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        ActorRef j = $this.journal();
        ActorRef s2 = $this.snapshotStore();
        Eventsourced$class.requestRecoveryPermit($this);
        $this.akka$persistence$Eventsourced$$super$aroundPreStart();
    }

    private static void requestRecoveryPermit(Eventsourced $this) {
        $this.akka$persistence$Eventsourced$$extension().recoveryPermitter().tell(RecoveryPermitter$RequestRecoveryPermit$.MODULE$, $this.self());
        Eventsourced$class.akka$persistence$Eventsourced$$changeState($this, Eventsourced$class.waitingRecoveryPermit($this, $this.recovery()));
    }

    /*
     * Unable to fully structure code
     */
    public static void aroundPreRestart(Eventsourced $this, Throwable reason, Option message) {
        try {
            $this.akka$persistence$Eventsourced$$internalStash().unstashAll();
            $this.unstashAll($this.akka$persistence$Eventsourced$$unstashFilterPredicate());
            return;
        }
        finally {
            var4_3 = false;
            var5_5 = null;
            var6_7 = message;
            if (!(var6_7 instanceof Some)) ** GOTO lbl-1000
            var4_3 = true;
            var5_5 = (Some)var6_7;
            var7_9 = var5_5.x();
            if (var7_9 instanceof JournalProtocol.WriteMessageSuccess) {
                var8_11 = (JournalProtocol.WriteMessageSuccess)var7_9;
                m = var8_11.persistent();
                Eventsourced$class.akka$persistence$Eventsourced$$flushJournalBatch($this);
                $this.akka$persistence$Eventsourced$$super$aroundPreRestart(reason, new Some<PersistentRepr>(m));
                var10_15 = BoxedUnit.UNIT;
            } else if (var4_3 && (var11_23 = var5_5.x()) instanceof JournalProtocol.LoopMessageSuccess) {
                var12_25 = (JournalProtocol.LoopMessageSuccess)var11_23;
                m = var12_25.message();
                Eventsourced$class.akka$persistence$Eventsourced$$flushJournalBatch($this);
                $this.akka$persistence$Eventsourced$$super$aroundPreRestart(reason, new Some<Object>(m));
                var10_16 = BoxedUnit.UNIT;
            } else if (var4_3 && (var14_29 = var5_5.x()) instanceof JournalProtocol.ReplayedMessage) {
                var15_31 = (JournalProtocol.ReplayedMessage)var14_29;
                m = var15_31.persistent();
                Eventsourced$class.akka$persistence$Eventsourced$$flushJournalBatch($this);
                $this.akka$persistence$Eventsourced$$super$aroundPreRestart(reason, new Some<PersistentRepr>(m));
                var10_17 = BoxedUnit.UNIT;
            } else {
                Eventsourced$class.akka$persistence$Eventsourced$$flushJournalBatch($this);
                $this.akka$persistence$Eventsourced$$super$aroundPreRestart(reason, var6_7);
                var10_18 = BoxedUnit.UNIT;
            }
        }
    }

    public static void aroundPostRestart(Eventsourced $this, Throwable reason) {
        Eventsourced$class.requestRecoveryPermit($this);
        $this.akka$persistence$Eventsourced$$super$aroundPostRestart(reason);
    }

    public static void aroundPostStop(Eventsourced $this) {
        try {
            $this.akka$persistence$Eventsourced$$internalStash().unstashAll();
            $this.unstashAll($this.akka$persistence$Eventsourced$$unstashFilterPredicate());
            return;
        }
        finally {
            $this.akka$persistence$Eventsourced$$super$aroundPostStop();
        }
    }

    public static void unhandled(Eventsourced $this, Object message) {
        Object object = message;
        if (RecoveryCompleted$.MODULE$.equals(object)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof SaveSnapshotFailure) {
            SaveSnapshotFailure saveSnapshotFailure = (SaveSnapshotFailure)object;
            SnapshotMetadata m = saveSnapshotFailure.metadata();
            Throwable e = saveSnapshotFailure.cause();
            Eventsourced$class.log($this).warning("Failed to saveSnapshot given metadata [{}] due to: [{}: {}]", m, e.getClass().getCanonicalName(), e.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof DeleteSnapshotFailure) {
            DeleteSnapshotFailure deleteSnapshotFailure = (DeleteSnapshotFailure)object;
            SnapshotMetadata m = deleteSnapshotFailure.metadata();
            Throwable e = deleteSnapshotFailure.cause();
            Eventsourced$class.log($this).warning("Failed to deleteSnapshot given metadata [{}] due to: [{}: {}]", m, e.getClass().getCanonicalName(), e.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof DeleteSnapshotsFailure) {
            DeleteSnapshotsFailure deleteSnapshotsFailure = (DeleteSnapshotsFailure)object;
            SnapshotSelectionCriteria c = deleteSnapshotsFailure.criteria();
            Throwable e = deleteSnapshotsFailure.cause();
            Eventsourced$class.log($this).warning("Failed to deleteSnapshots given criteria [{}] due to: [{}: {}]", c, e.getClass().getCanonicalName(), e.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof DeleteMessagesFailure) {
            DeleteMessagesFailure deleteMessagesFailure = (DeleteMessagesFailure)object;
            Throwable e = deleteMessagesFailure.cause();
            long toSequenceNr = deleteMessagesFailure.toSequenceNr();
            Eventsourced$class.log($this).warning("Failed to deleteMessages toSequenceNr [{}] for persistenceId [{}] due to [{}: {}].", BoxesRunTime.boxToLong(toSequenceNr), $this.persistenceId(), e.getClass().getCanonicalName(), e.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            $this.akka$persistence$Eventsourced$$super$unhandled(object);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static void akka$persistence$Eventsourced$$changeState(Eventsourced $this, Eventsourced.State state) {
        $this.akka$persistence$Eventsourced$$currentState_$eq(state);
    }

    public static void akka$persistence$Eventsourced$$updateLastSequenceNr(Eventsourced $this, PersistentRepr persistent) {
        if (persistent.sequenceNr() > $this.akka$persistence$Eventsourced$$_lastSequenceNr()) {
            $this.akka$persistence$Eventsourced$$_lastSequenceNr_$eq(persistent.sequenceNr());
        }
    }

    public static void akka$persistence$Eventsourced$$setLastSequenceNr(Eventsourced $this, long value2) {
        $this.akka$persistence$Eventsourced$$_lastSequenceNr_$eq(value2);
    }

    public static long akka$persistence$Eventsourced$$nextSequenceNr(Eventsourced $this) {
        $this.akka$persistence$Eventsourced$$sequenceNr_$eq($this.akka$persistence$Eventsourced$$sequenceNr() + 1L);
        return $this.akka$persistence$Eventsourced$$sequenceNr();
    }

    public static void akka$persistence$Eventsourced$$flushJournalBatch(Eventsourced $this) {
        if (!$this.akka$persistence$Eventsourced$$writeInProgress() && $this.akka$persistence$Eventsourced$$journalBatch().nonEmpty()) {
            akka.actor.package$.MODULE$.actorRef2Scala($this.journal()).$bang(new JournalProtocol.WriteMessages($this.akka$persistence$Eventsourced$$journalBatch(), $this.self(), $this.akka$persistence$Eventsourced$$instanceId()), $this.self());
            $this.akka$persistence$Eventsourced$$journalBatch_$eq((Vector<PersistentEnvelope>)package$.MODULE$.Vector().empty());
            $this.akka$persistence$Eventsourced$$writeInProgress_$eq(true);
        }
    }

    private static LoggingAdapter log(Eventsourced $this) {
        return Logging$.MODULE$.apply($this.context().system(), $this, LogSource$.MODULE$.fromActor());
    }

    public static void persist(Eventsourced $this, Object event, Function1 handler) {
        if ($this.recoveryRunning()) {
            throw new IllegalStateException("Cannot persist during replay. Events can be persisted when receiving RecoveryCompleted or later.");
        }
        $this.akka$persistence$Eventsourced$$pendingStashingPersistInvocations_$eq($this.akka$persistence$Eventsourced$$pendingStashingPersistInvocations() + 1L);
        $this.akka$persistence$Eventsourced$$pendingInvocations().addLast(new Eventsourced.StashingHandlerInvocation(event, handler));
        Object x$4 = event;
        String x$5 = $this.persistenceId();
        long x$6 = Eventsourced$class.akka$persistence$Eventsourced$$nextSequenceNr($this);
        String x$7 = $this.akka$persistence$Eventsourced$$writerUuid();
        ActorRef x$8 = $this.sender();
        String x$9 = PersistentRepr$.MODULE$.apply$default$4();
        boolean x$10 = PersistentRepr$.MODULE$.apply$default$5();
        $this.akka$persistence$Eventsourced$$eventBatch_$eq($this.akka$persistence$Eventsourced$$eventBatch().$colon$colon(AtomicWrite$.MODULE$.apply(PersistentRepr$.MODULE$.apply(x$4, x$6, x$5, x$9, x$10, x$8, x$7))));
    }

    public static void persistAll(Eventsourced $this, Seq events2, Function1 handler) {
        if ($this.recoveryRunning()) {
            throw new IllegalStateException("Cannot persist during replay. Events can be persisted when receiving RecoveryCompleted or later.");
        }
        if (events2.nonEmpty()) {
            events2.foreach(new Serializable($this, handler){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Eventsourced $outer;
                private final Function1 handler$1;

                public final void apply(A event) {
                    this.$outer.akka$persistence$Eventsourced$$pendingStashingPersistInvocations_$eq(this.$outer.akka$persistence$Eventsourced$$pendingStashingPersistInvocations() + 1L);
                    this.$outer.akka$persistence$Eventsourced$$pendingInvocations().addLast(new Eventsourced.StashingHandlerInvocation(event, this.handler$1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.handler$1 = handler$1;
                }
            });
            $this.akka$persistence$Eventsourced$$eventBatch_$eq($this.akka$persistence$Eventsourced$$eventBatch().$colon$colon(new AtomicWrite(events2.map(new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Eventsourced $outer;

                public final PersistentRepr apply(A x$1) {
                    A x$11 = x$1;
                    String x$12 = this.$outer.persistenceId();
                    long x$13 = Eventsourced$class.akka$persistence$Eventsourced$$nextSequenceNr(this.$outer);
                    String x$14 = this.$outer.akka$persistence$Eventsourced$$writerUuid();
                    ActorRef x$15 = this.$outer.sender();
                    String x$16 = PersistentRepr$.MODULE$.apply$default$4();
                    boolean x$17 = PersistentRepr$.MODULE$.apply$default$5();
                    return PersistentRepr$.MODULE$.apply(x$11, x$13, x$12, x$16, x$17, x$15, x$14);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom()))));
        }
    }

    public static void persist(Eventsourced $this, Seq events2, Function1 handler) {
        $this.persistAll(events2, handler);
    }

    public static void persistAsync(Eventsourced $this, Object event, Function1 handler) {
        if ($this.recoveryRunning()) {
            throw new IllegalStateException("Cannot persist during replay. Events can be persisted when receiving RecoveryCompleted or later.");
        }
        $this.akka$persistence$Eventsourced$$pendingInvocations().addLast(new Eventsourced.AsyncHandlerInvocation(event, handler));
        Object x$18 = event;
        String x$19 = $this.persistenceId();
        long x$20 = Eventsourced$class.akka$persistence$Eventsourced$$nextSequenceNr($this);
        String x$21 = $this.akka$persistence$Eventsourced$$writerUuid();
        ActorRef x$22 = $this.sender();
        String x$23 = PersistentRepr$.MODULE$.apply$default$4();
        boolean x$24 = PersistentRepr$.MODULE$.apply$default$5();
        $this.akka$persistence$Eventsourced$$eventBatch_$eq($this.akka$persistence$Eventsourced$$eventBatch().$colon$colon(AtomicWrite$.MODULE$.apply(PersistentRepr$.MODULE$.apply(x$18, x$20, x$19, x$23, x$24, x$22, x$21))));
    }

    public static void persistAllAsync(Eventsourced $this, Seq events2, Function1 handler) {
        if ($this.recoveryRunning()) {
            throw new IllegalStateException("Cannot persist during replay. Events can be persisted when receiving RecoveryCompleted or later.");
        }
        if (events2.nonEmpty()) {
            events2.foreach(new Serializable($this, handler){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Eventsourced $outer;
                private final Function1 handler$2;

                public final void apply(A event) {
                    this.$outer.akka$persistence$Eventsourced$$pendingInvocations().addLast(new Eventsourced.AsyncHandlerInvocation(event, this.handler$2));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.handler$2 = handler$2;
                }
            });
            $this.akka$persistence$Eventsourced$$eventBatch_$eq($this.akka$persistence$Eventsourced$$eventBatch().$colon$colon(new AtomicWrite(events2.map(new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Eventsourced $outer;

                public final PersistentRepr apply(A x$2) {
                    A x$25 = x$2;
                    String x$26 = this.$outer.persistenceId();
                    long x$27 = Eventsourced$class.akka$persistence$Eventsourced$$nextSequenceNr(this.$outer);
                    String x$28 = this.$outer.akka$persistence$Eventsourced$$writerUuid();
                    ActorRef x$29 = this.$outer.sender();
                    String x$30 = PersistentRepr$.MODULE$.apply$default$4();
                    boolean x$31 = PersistentRepr$.MODULE$.apply$default$5();
                    return PersistentRepr$.MODULE$.apply(x$25, x$27, x$26, x$30, x$31, x$29, x$28);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom()))));
        }
    }

    public static void persistAsync(Eventsourced $this, Seq events2, Function1 handler) {
        $this.persistAllAsync(events2, handler);
    }

    public static void deferAsync(Eventsourced $this, Object event, Function1 handler) {
        if ($this.recoveryRunning()) {
            throw new IllegalStateException("Cannot persist during replay. Events can be persisted when receiving RecoveryCompleted or later.");
        }
        if ($this.akka$persistence$Eventsourced$$pendingInvocations().isEmpty()) {
            handler.apply(event);
        } else {
            $this.akka$persistence$Eventsourced$$pendingInvocations().addLast(new Eventsourced.AsyncHandlerInvocation(event, handler));
            NonPersistentRepr nonPersistentRepr = new NonPersistentRepr(event, $this.sender());
            $this.akka$persistence$Eventsourced$$eventBatch_$eq($this.akka$persistence$Eventsourced$$eventBatch().$colon$colon(nonPersistentRepr));
        }
    }

    public static void deleteMessages(Eventsourced $this, long toSequenceNr) {
        akka.actor.package$.MODULE$.actorRef2Scala($this.journal()).$bang(new JournalProtocol.DeleteMessagesTo($this.persistenceId(), toSequenceNr, $this.self()), $this.self());
    }

    public static boolean recoveryRunning(Eventsourced $this) {
        return $this.akka$persistence$Eventsourced$$currentState() == null ? true : $this.akka$persistence$Eventsourced$$currentState().recoveryRunning();
    }

    public static boolean recoveryFinished(Eventsourced $this) {
        return !$this.recoveryRunning();
    }

    public static void unstashAll(Eventsourced $this) {
        $this.akka$persistence$Eventsourced$$internalStash().prepend($this.clearStash());
    }

    private static Eventsourced.State waitingRecoveryPermit(Eventsourced $this, Recovery recovery) {
        return new Eventsourced.State($this, recovery){
            private final /* synthetic */ Eventsourced $outer;
            private final Recovery recovery$1;

            public String toString() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"waiting for recovery permit"})).s(Nil$.MODULE$);
            }

            public boolean recoveryRunning() {
                return true;
            }

            public void stateReceive(PartialFunction<Object, BoxedUnit> receive2, Object message) {
                Object object = message;
                if (RecoveryPermitter$RecoveryPermitGranted$.MODULE$.equals(object)) {
                    Eventsourced$class.akka$persistence$Eventsourced$$startRecovery(this.$outer, this.recovery$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Eventsourced$class.akka$persistence$Eventsourced$$stashInternally(this.$outer, object);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.recovery$1 = recovery$1;
            }
        };
    }

    private static Eventsourced.State recoveryStarted(Eventsourced $this, long replayMax) {
        return new Eventsourced.State($this, replayMax){
            private final FiniteDuration timeout;
            private final Cancellable timeoutCancellable;
            private final PartialFunction<Object, BoxedUnit> akka$persistence$Eventsourced$$anon$$recoveryBehavior;
            private final /* synthetic */ Eventsourced $outer;
            private final long replayMax$1;

            public FiniteDuration timeout() {
                return this.timeout;
            }

            public Cancellable timeoutCancellable() {
                return this.timeoutCancellable;
            }

            public PartialFunction<Object, BoxedUnit> akka$persistence$Eventsourced$$anon$$recoveryBehavior() {
                return this.akka$persistence$Eventsourced$$anon$$recoveryBehavior;
            }

            public String toString() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"recovery started (replayMax = [", "])"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.replayMax$1)}));
            }

            public boolean recoveryRunning() {
                return true;
            }

            public void stateReceive(PartialFunction<Object, BoxedUnit> receive2, Object message) {
                try {
                    Object object = message;
                    if (object instanceof SnapshotProtocol.LoadSnapshotResult) {
                        SnapshotProtocol.LoadSnapshotResult loadSnapshotResult = (SnapshotProtocol.LoadSnapshotResult)object;
                        Option<SelectedSnapshot> sso = loadSnapshotResult.snapshot();
                        long toSnr = loadSnapshotResult.toSequenceNr();
                        this.timeoutCancellable().cancel();
                        sso.foreach(new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ Eventsourced$.anon.3 $outer;

                            public final void apply(SelectedSnapshot x0$2) {
                                SelectedSnapshot selectedSnapshot = x0$2;
                                if (selectedSnapshot != null) {
                                    SnapshotMetadata metadata = selectedSnapshot.metadata();
                                    Object snapshot = selectedSnapshot.snapshot();
                                    Eventsourced$class.akka$persistence$Eventsourced$$setLastSequenceNr(this.$outer.akka$persistence$Eventsourced$$anon$$$outer(), metadata.sequenceNr());
                                    this.$outer.akka$persistence$Eventsourced$$anon$$$outer().akka$persistence$Eventsourced$$super$aroundReceive(this.$outer.akka$persistence$Eventsourced$$anon$$recoveryBehavior(), new SnapshotOffer(metadata, snapshot));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(selectedSnapshot);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        Eventsourced$class.akka$persistence$Eventsourced$$changeState(this.$outer, Eventsourced$class.akka$persistence$Eventsourced$$recovering(this.$outer, this.akka$persistence$Eventsourced$$anon$$recoveryBehavior(), this.timeout()));
                        akka.actor.package$.MODULE$.actorRef2Scala(this.$outer.journal()).$bang(new JournalProtocol.ReplayMessages(this.$outer.lastSequenceNr() + 1L, toSnr, this.replayMax$1, this.$outer.persistenceId(), this.$outer.self()), this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Eventsourced.RecoveryTick recoveryTick;
                        boolean bl;
                        if (object instanceof SnapshotProtocol.LoadSnapshotFailed) {
                            SnapshotProtocol.LoadSnapshotFailed loadSnapshotFailed = (SnapshotProtocol.LoadSnapshotFailed)object;
                            Throwable cause = loadSnapshotFailed.cause();
                            this.timeoutCancellable().cancel();
                            this.$outer.onRecoveryFailure(cause, None$.MODULE$);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        if (object instanceof Eventsourced.RecoveryTick && (bl = (recoveryTick = (Eventsourced.RecoveryTick)object).snapshot())) {
                            this.$outer.onRecoveryFailure(new RecoveryTimedOut(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recovery timed out, didn't get snapshot within ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.timeout()}))), None$.MODULE$);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        Eventsourced$class.akka$persistence$Eventsourced$$stashInternally(this.$outer, object);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                    finally {
                        this.$outer.context().stop(this.$outer.self());
                    }
                    finally {
                        this.$outer.context().stop(this.$outer.self());
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = option.get();
                    this.returnRecoveryPermit();
                    throw e;
                }
            }

            private void returnRecoveryPermit() {
                this.$outer.akka$persistence$Eventsourced$$extension().recoveryPermitter().tell(RecoveryPermitter$ReturnRecoveryPermit$.MODULE$, this.$outer.self());
            }

            public /* synthetic */ Eventsourced akka$persistence$Eventsourced$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replayMax$1 = replayMax$1;
                this.timeout = Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps($outer.akka$persistence$Eventsourced$$extension().journalConfigFor($outer.journalPluginId())), "recovery-event-timeout");
                this.timeoutCancellable = $outer.context().system().scheduler().scheduleOnce(this.timeout(), $outer.self(), new Eventsourced.RecoveryTick(true), $outer.context().dispatcher(), $outer.self());
                PartialFunction<Object, BoxedUnit> _receiveRecover = $outer.receiveRecover();
                this.akka$persistence$Eventsourced$$anon$$recoveryBehavior = new Serializable(this, _receiveRecover){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Eventsourced$.anon.3 $outer;
                    private final PartialFunction _receiveRecover$1;

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     */
                    public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        SnapshotOffer snapshotOffer;
                        void var7_11;
                        PersistentRepr persistentRepr;
                        Option<Tuple2<Object, Object>> option;
                        A1 A17 = x1;
                        if (A17 instanceof PersistentRepr && !(option = PersistentRepr$.MODULE$.unapply(persistentRepr = (PersistentRepr)A17)).isEmpty()) {
                            Object payload = option.get()._1();
                            if (this.$outer.recoveryRunning() && this._receiveRecover$1.isDefinedAt(payload)) {
                                R r = this._receiveRecover$1.apply(payload);
                                return var7_11;
                            }
                        }
                        if (A17 instanceof SnapshotOffer && this._receiveRecover$1.isDefinedAt(snapshotOffer = (SnapshotOffer)A17)) {
                            R r = this._receiveRecover$1.apply(snapshotOffer);
                            return var7_11;
                        }
                        if (RecoveryCompleted$.MODULE$.equals(A17) && this._receiveRecover$1.isDefinedAt(RecoveryCompleted$.MODULE$)) {
                            R r = this._receiveRecover$1.apply(RecoveryCompleted$.MODULE$);
                            return var7_11;
                        }
                        B1 B1 = function1.apply(x1);
                        return var7_11;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Object x1) {
                        SnapshotOffer snapshotOffer;
                        PersistentRepr persistentRepr;
                        Option<Tuple2<Object, Object>> option;
                        Object object = x1;
                        if (object instanceof PersistentRepr && !(option = PersistentRepr$.MODULE$.unapply(persistentRepr = (PersistentRepr)object)).isEmpty()) {
                            Object payload = option.get()._1();
                            if (this.$outer.recoveryRunning() && this._receiveRecover$1.isDefinedAt(payload)) {
                                return true;
                            }
                        }
                        if (object instanceof SnapshotOffer && this._receiveRecover$1.isDefinedAt(snapshotOffer = (SnapshotOffer)object)) {
                            return true;
                        }
                        if (!RecoveryCompleted$.MODULE$.equals(object)) return false;
                        if (!this._receiveRecover$1.isDefinedAt(RecoveryCompleted$.MODULE$)) return false;
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this._receiveRecover$1 = _receiveRecover$1;
                    }
                };
            }
        };
    }

    public static Eventsourced.State akka$persistence$Eventsourced$$recovering(Eventsourced $this, PartialFunction recoveryBehavior, FiniteDuration timeout) {
        return new Eventsourced.State($this, recoveryBehavior, timeout){
            private final Cancellable timeoutCancellable;
            private boolean eventSeenInInterval;
            private boolean _recoveryRunning;
            private final /* synthetic */ Eventsourced $outer;
            private final PartialFunction recoveryBehavior$1;
            private final FiniteDuration timeout$1;

            public Cancellable timeoutCancellable() {
                return this.timeoutCancellable;
            }

            public boolean eventSeenInInterval() {
                return this.eventSeenInInterval;
            }

            public void eventSeenInInterval_$eq(boolean x$1) {
                this.eventSeenInInterval = x$1;
            }

            public boolean _recoveryRunning() {
                return this._recoveryRunning;
            }

            public void _recoveryRunning_$eq(boolean x$1) {
                this._recoveryRunning = x$1;
            }

            public String toString() {
                return "replay started";
            }

            public boolean recoveryRunning() {
                return this._recoveryRunning();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void stateReceive(PartialFunction<Object, BoxedUnit> receive2, Object message) {
                try {
                    BoxedUnit boxedUnit;
                    boolean bl3 = false;
                    Eventsourced.RecoveryTick recoveryTick = null;
                    Object object = message;
                    if (object instanceof JournalProtocol.ReplayedMessage) {
                        JournalProtocol.ReplayedMessage replayedMessage = (JournalProtocol.ReplayedMessage)object;
                        PersistentRepr p = replayedMessage.persistent();
                        try {
                            this.eventSeenInInterval_$eq(true);
                            Eventsourced$class.akka$persistence$Eventsourced$$updateLastSequenceNr(this.$outer, p);
                            this.$outer.akka$persistence$Eventsourced$$super$aroundReceive(this.recoveryBehavior$1, p);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                            if (option.isEmpty()) {
                                throw throwable;
                            }
                            Throwable t = option.get();
                            this.timeoutCancellable().cancel();
                            try {
                                this.$outer.onRecoveryFailure(t, new Some<Object>(p.payload()));
                                this.returnRecoveryPermit();
                                BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            finally {
                                this.$outer.context().stop(this.$outer.self());
                            }
                        }
                    } else {
                        boolean bl;
                        boolean bl2;
                        if (object instanceof JournalProtocol.RecoverySuccess) {
                            JournalProtocol.RecoverySuccess recoverySuccess = (JournalProtocol.RecoverySuccess)object;
                            long highestSeqNr = recoverySuccess.highestSequenceNr();
                            this.timeoutCancellable().cancel();
                            this.$outer.onReplaySuccess();
                            this.$outer.akka$persistence$Eventsourced$$sequenceNr_$eq(highestSeqNr);
                            Eventsourced$class.akka$persistence$Eventsourced$$setLastSequenceNr(this.$outer, highestSeqNr);
                            this._recoveryRunning_$eq(false);
                            this.$outer.akka$persistence$Eventsourced$$super$aroundReceive(this.recoveryBehavior$1, RecoveryCompleted$.MODULE$);
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            return;
                        }
                        if (object instanceof JournalProtocol.ReplayMessagesFailure) {
                            JournalProtocol.ReplayMessagesFailure replayMessagesFailure = (JournalProtocol.ReplayMessagesFailure)object;
                            Throwable cause = replayMessagesFailure.cause();
                            this.timeoutCancellable().cancel();
                            this.$outer.onRecoveryFailure(cause, None$.MODULE$);
                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                            return;
                        }
                        if (object instanceof Eventsourced.RecoveryTick) {
                            bl3 = true;
                            recoveryTick = (Eventsourced.RecoveryTick)object;
                            boolean bl4 = recoveryTick.snapshot();
                            if (!bl4 && !this.eventSeenInInterval()) {
                                this.timeoutCancellable().cancel();
                                this.$outer.onRecoveryFailure(new RecoveryTimedOut(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recovery timed out, didn't get event within ", ", highest sequence number seen ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.timeout$1, BoxesRunTime.boxToLong(this.$outer.lastSequenceNr())}))), None$.MODULE$);
                                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                                return;
                            }
                        }
                        if (bl3 && !(bl2 = recoveryTick.snapshot())) {
                            this.eventSeenInInterval_$eq(false);
                            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                            return;
                        }
                        if (bl3 && (bl = recoveryTick.snapshot())) {
                            BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                            return;
                        }
                        Eventsourced$class.akka$persistence$Eventsourced$$stashInternally(this.$outer, object);
                        BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                        return;
                    }
                    BoxedUnit boxedUnit9 = boxedUnit;
                    return;
                    finally {
                        this.transitToProcessingState();
                    }
                    finally {
                        this.$outer.context().stop(this.$outer.self());
                    }
                    finally {
                        this.$outer.context().stop(this.$outer.self());
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable3);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = option.get();
                    this.returnRecoveryPermit();
                    throw e;
                }
            }

            private void returnRecoveryPermit() {
                this.$outer.akka$persistence$Eventsourced$$extension().recoveryPermitter().tell(RecoveryPermitter$ReturnRecoveryPermit$.MODULE$, this.$outer.self());
            }

            private void transitToProcessingState() {
                this.returnRecoveryPermit();
                if (this.$outer.akka$persistence$Eventsourced$$eventBatch().nonEmpty()) {
                    Eventsourced$class.akka$persistence$Eventsourced$$flushBatch(this.$outer);
                }
                if (this.$outer.akka$persistence$Eventsourced$$pendingStashingPersistInvocations() > 0L) {
                    Eventsourced$class.akka$persistence$Eventsourced$$changeState(this.$outer, this.$outer.akka$persistence$Eventsourced$$persistingEvents());
                } else {
                    Eventsourced$class.akka$persistence$Eventsourced$$changeState(this.$outer, this.$outer.akka$persistence$Eventsourced$$processingCommands());
                    this.$outer.akka$persistence$Eventsourced$$internalStash().unstashAll();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.recoveryBehavior$1 = recoveryBehavior$1;
                this.timeout$1 = timeout$1;
                this.timeoutCancellable = $outer.context().system().scheduler().schedule(timeout$1, timeout$1, $outer.self(), new Eventsourced.RecoveryTick(false), $outer.context().dispatcher(), $outer.self());
                this.eventSeenInInterval = false;
                this._recoveryRunning = true;
            }
        };
    }

    public static void akka$persistence$Eventsourced$$flushBatch(Eventsourced $this) {
        if ($this.akka$persistence$Eventsourced$$eventBatch().nonEmpty()) {
            $this.akka$persistence$Eventsourced$$journalBatch_$eq($this.akka$persistence$Eventsourced$$journalBatch().$plus$plus($this.akka$persistence$Eventsourced$$eventBatch().reverse(), Vector$.MODULE$.canBuildFrom()));
            $this.akka$persistence$Eventsourced$$eventBatch_$eq(Nil$.MODULE$);
        }
        Eventsourced$class.akka$persistence$Eventsourced$$flushJournalBatch($this);
    }

    public static void akka$persistence$Eventsourced$$peekApplyHandler(Eventsourced $this, Object payload) {
        try {
            $this.akka$persistence$Eventsourced$$pendingInvocations().peek().handler().apply(payload);
            return;
        }
        finally {
            Eventsourced$class.akka$persistence$Eventsourced$$flushBatch($this);
        }
    }

    public static void $init$(Eventsourced $this) {
        $this.akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$extension_$eq((Persistence)Persistence$.MODULE$.apply($this.context().system()));
        $this.akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$instanceId_$eq(Eventsourced$.MODULE$.akka$persistence$Eventsourced$$instanceIdCounter().getAndIncrement());
        $this.akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$writerUuid_$eq(UUID.randomUUID().toString());
        $this.akka$persistence$Eventsourced$$journalBatch_$eq((Vector<PersistentEnvelope>)package$.MODULE$.Vector().empty());
        $this.akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$maxMessageBatchSize_$eq($this.akka$persistence$Eventsourced$$extension().journalConfigFor($this.journalPluginId()).getInt("max-message-batch-size"));
        $this.akka$persistence$Eventsourced$$writeInProgress_$eq(false);
        $this.akka$persistence$Eventsourced$$sequenceNr_$eq(0L);
        $this.akka$persistence$Eventsourced$$_lastSequenceNr_$eq(0L);
        $this.akka$persistence$Eventsourced$$currentState_$eq(null);
        $this.akka$persistence$Eventsourced$$pendingStashingPersistInvocations_$eq(0L);
        $this.akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$pendingInvocations_$eq(new LinkedList());
        $this.akka$persistence$Eventsourced$$eventBatch_$eq(Nil$.MODULE$);
        $this.akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$internalStash_$eq($this.createStash($this.context(), $this.self()));
        $this.akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$unstashFilterPredicate_$eq((Function1)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object x0$1) {
                Object object = x0$1;
                boolean bl = object instanceof JournalProtocol.WriteMessageSuccess ? false : !(object instanceof JournalProtocol.ReplayedMessage);
                return bl;
            }
        }));
        $this.akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$processingCommands_$eq(new Eventsourced.ProcessingState($this){
            private final /* synthetic */ Eventsourced $outer;

            public String toString() {
                return "processing commands";
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void stateReceive(PartialFunction<Object, BoxedUnit> receive2, Object message) {
                if (this.common().isDefinedAt(message)) {
                    this.common().apply(message);
                    return;
                }
                try {
                    this.$outer.akka$persistence$Eventsourced$$super$aroundReceive(receive2, message);
                    this.aroundReceiveComplete(false);
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = option.get();
                    this.aroundReceiveComplete(true);
                    throw e;
                }
            }

            private void aroundReceiveComplete(boolean err2) {
                if (this.$outer.akka$persistence$Eventsourced$$eventBatch().nonEmpty()) {
                    Eventsourced$class.akka$persistence$Eventsourced$$flushBatch(this.$outer);
                }
                if (this.$outer.akka$persistence$Eventsourced$$pendingStashingPersistInvocations() > 0L) {
                    Eventsourced$class.akka$persistence$Eventsourced$$changeState(this.$outer, this.$outer.akka$persistence$Eventsourced$$persistingEvents());
                } else {
                    Eventsourced$class.akka$persistence$Eventsourced$$unstashInternally(this.$outer, err2);
                }
            }

            public void onWriteMessageComplete(boolean err2) {
                this.$outer.akka$persistence$Eventsourced$$pendingInvocations().pop();
                Eventsourced$class.akka$persistence$Eventsourced$$unstashInternally(this.$outer, err2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer);
            }
        });
        $this.akka$persistence$Eventsourced$_setter_$akka$persistence$Eventsourced$$persistingEvents_$eq(new Eventsourced.ProcessingState($this){
            private final /* synthetic */ Eventsourced $outer;

            public String toString() {
                return "persisting events";
            }

            public void stateReceive(PartialFunction<Object, BoxedUnit> receive2, Object message) {
                if (this.common().isDefinedAt(message)) {
                    this.common().apply(message);
                } else {
                    Eventsourced$class.akka$persistence$Eventsourced$$stashInternally(this.$outer, message);
                }
            }

            public void onWriteMessageComplete(boolean err2) {
                Eventsourced.PendingHandlerInvocation pendingHandlerInvocation = this.$outer.akka$persistence$Eventsourced$$pendingInvocations().pop();
                if (pendingHandlerInvocation instanceof Eventsourced.StashingHandlerInvocation) {
                    this.$outer.akka$persistence$Eventsourced$$pendingStashingPersistInvocations_$eq(this.$outer.akka$persistence$Eventsourced$$pendingStashingPersistInvocations() - 1L);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                if (this.$outer.akka$persistence$Eventsourced$$pendingStashingPersistInvocations() == 0L) {
                    Eventsourced$class.akka$persistence$Eventsourced$$changeState(this.$outer, this.$outer.akka$persistence$Eventsourced$$processingCommands());
                    Eventsourced$class.akka$persistence$Eventsourced$$unstashInternally(this.$outer, err2);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer);
            }
        });
    }
}

