/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence;

import akka.actor.ActorPath;
import akka.actor.ActorPath$;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSelection$;
import akka.actor.Cancellable;
import akka.actor.Scheduler;
import akka.persistence.AtLeastOnceDelivery;
import akka.persistence.AtLeastOnceDelivery$Internal$RedeliveryTick$;
import akka.persistence.AtLeastOnceDeliveryLike;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.math.Ordering$Long$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public abstract class AtLeastOnceDeliveryLike$class {
    public static FiniteDuration redeliverInterval(AtLeastOnceDeliveryLike $this) {
        return $this.akka$persistence$AtLeastOnceDeliveryLike$$defaultRedeliverInterval();
    }

    public static int redeliveryBurstLimit(AtLeastOnceDeliveryLike $this) {
        return $this.akka$persistence$AtLeastOnceDeliveryLike$$defaultRedeliveryBurstLimit();
    }

    public static int warnAfterNumberOfUnconfirmedAttempts(AtLeastOnceDeliveryLike $this) {
        return $this.akka$persistence$AtLeastOnceDeliveryLike$$defaultWarnAfterNumberOfUnconfirmedAttempts();
    }

    public static int maxUnconfirmedMessages(AtLeastOnceDeliveryLike $this) {
        return $this.akka$persistence$AtLeastOnceDeliveryLike$$defaultMaxUnconfirmedMessages();
    }

    private static void startRedeliverTask(AtLeastOnceDeliveryLike $this) {
        FiniteDuration interval = $this.redeliverInterval().$div(2L);
        Scheduler qual$1 = $this.context().system().scheduler();
        FiniteDuration x$3 = interval;
        FiniteDuration x$4 = interval;
        ActorRef x$5 = $this.self();
        AtLeastOnceDelivery$Internal$RedeliveryTick$ x$6 = AtLeastOnceDelivery$Internal$RedeliveryTick$.MODULE$;
        ExecutionContextExecutor x$7 = $this.context().dispatcher();
        ActorRef x$8 = qual$1.schedule$default$6(x$3, x$4, x$5, x$6);
        $this.akka$persistence$AtLeastOnceDeliveryLike$$redeliverTask_$eq(new Some<Cancellable>(qual$1.schedule(x$3, x$4, x$5, x$6, x$7, x$8)));
    }

    private static long nextDeliverySequenceNr(AtLeastOnceDeliveryLike $this) {
        $this.akka$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr_$eq($this.akka$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr() + 1L);
        return $this.akka$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr();
    }

    public static void deliver(AtLeastOnceDeliveryLike $this, ActorPath destination, Function1 deliveryIdToMessage) {
        if ($this.akka$persistence$AtLeastOnceDeliveryLike$$unconfirmed().size() >= $this.maxUnconfirmedMessages()) {
            throw new AtLeastOnceDelivery.MaxUnconfirmedMessagesExceededException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Too many unconfirmed messages, maximum allowed is [", "]"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger($this.maxUnconfirmedMessages())})));
        }
        long deliveryId = AtLeastOnceDeliveryLike$class.nextDeliverySequenceNr($this);
        long now = $this.recoveryRunning() ? System.nanoTime() - $this.redeliverInterval().toNanos() : System.nanoTime();
        AtLeastOnceDelivery.Internal.Delivery d = new AtLeastOnceDelivery.Internal.Delivery(destination, deliveryIdToMessage.apply(BoxesRunTime.boxToLong(deliveryId)), now, 0);
        if ($this.recoveryRunning()) {
            $this.akka$persistence$AtLeastOnceDeliveryLike$$unconfirmed_$eq($this.akka$persistence$AtLeastOnceDeliveryLike$$unconfirmed().updated(BoxesRunTime.boxToLong(deliveryId), d));
        } else {
            AtLeastOnceDeliveryLike$class.akka$persistence$AtLeastOnceDeliveryLike$$send($this, deliveryId, d, now);
        }
    }

    public static void deliver(AtLeastOnceDeliveryLike $this, ActorSelection destination, Function1 deliveryIdToMessage) {
        boolean isWildcardSelection = destination.pathString().contains("*");
        Predef$.MODULE$.require(!isWildcardSelection, (Function0<Object>)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Delivering to wildcard actor selections is not supported by AtLeastOnceDelivery. Introduce an mediator Actor which this AtLeastOnceDelivery Actor will deliver the messages to,and will handle the logic of fan-out and collecting individual confirmations, until it can signal confirmation back to this Actor.";
            }
        }));
        $this.deliver(ActorPath$.MODULE$.fromString(destination.toSerializationFormat()), (Function1<Object, Object>)deliveryIdToMessage);
    }

    public static boolean confirmDelivery(AtLeastOnceDeliveryLike $this, long deliveryId) {
        boolean bl;
        if ($this.akka$persistence$AtLeastOnceDeliveryLike$$unconfirmed().contains(BoxesRunTime.boxToLong(deliveryId))) {
            $this.akka$persistence$AtLeastOnceDeliveryLike$$unconfirmed_$eq((SortedMap)$this.akka$persistence$AtLeastOnceDeliveryLike$$unconfirmed().$minus(BoxesRunTime.boxToLong(deliveryId)));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static int numberOfUnconfirmed(AtLeastOnceDeliveryLike $this) {
        return $this.akka$persistence$AtLeastOnceDeliveryLike$$unconfirmed().size();
    }

    private static void redeliverOverdue(AtLeastOnceDeliveryLike $this) {
        long now = System.nanoTime();
        long deadline = now - $this.redeliverInterval().toNanos();
        ObjectRef<GenTraversable> warnings = ObjectRef.create(package$.MODULE$.Vector().empty());
        $this.akka$persistence$AtLeastOnceDeliveryLike$$unconfirmed().iterator().filter((Function1<Tuple2<Object, AtLeastOnceDelivery.Internal.Delivery>, Object>)((Object)new Serializable($this, deadline){
            public static final long serialVersionUID = 0L;
            private final long deadline$1;

            public final boolean apply(Tuple2<Object, AtLeastOnceDelivery.Internal.Delivery> x0$1) {
                Tuple2<Object, AtLeastOnceDelivery.Internal.Delivery> tuple2 = x0$1;
                if (tuple2 != null) {
                    AtLeastOnceDelivery.Internal.Delivery delivery = tuple2._2();
                    boolean bl = delivery.timestamp() <= this.deadline$1;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.deadline$1 = deadline$1;
            }
        })).take($this.redeliveryBurstLimit()).foreach(new Serializable($this, now, warnings){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AtLeastOnceDeliveryLike $outer;
            private final long now$1;
            private final ObjectRef warnings$1;

            public final void apply(Tuple2<Object, AtLeastOnceDelivery.Internal.Delivery> x0$2) {
                Tuple2<Object, AtLeastOnceDelivery.Internal.Delivery> tuple2 = x0$2;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    long deliveryId = tuple2._1$mcJ$sp();
                    AtLeastOnceDelivery.Internal.Delivery delivery = tuple2._2();
                    AtLeastOnceDeliveryLike$class.akka$persistence$AtLeastOnceDeliveryLike$$send(this.$outer, deliveryId, delivery, this.now$1);
                    if (delivery.attempt() == this.$outer.warnAfterNumberOfUnconfirmedAttempts()) {
                        this.warnings$1.elem = ((Vector)this.warnings$1.elem).$colon$plus(new AtLeastOnceDelivery.UnconfirmedDelivery(deliveryId, delivery.destination(), delivery.message()), Vector$.MODULE$.canBuildFrom());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$1 = now$1;
                this.warnings$1 = warnings$1;
            }
        });
        if (((Vector)warnings.elem).nonEmpty()) {
            akka.actor.package$.MODULE$.actorRef2Scala($this.self()).$bang(new AtLeastOnceDelivery.UnconfirmedWarning((Vector)warnings.elem), $this.self());
        }
    }

    public static void akka$persistence$AtLeastOnceDeliveryLike$$send(AtLeastOnceDeliveryLike $this, long deliveryId, AtLeastOnceDelivery.Internal.Delivery d, long timestamp) {
        ActorSelection$.MODULE$.toScala($this.context().actorSelection(d.destination())).$bang(d.message(), $this.self());
        long x$9 = timestamp;
        int x$10 = d.attempt() + 1;
        ActorPath x$11 = d.copy$default$1();
        Object x$12 = d.copy$default$2();
        $this.akka$persistence$AtLeastOnceDeliveryLike$$unconfirmed_$eq($this.akka$persistence$AtLeastOnceDeliveryLike$$unconfirmed().updated(BoxesRunTime.boxToLong(deliveryId), d.copy(x$11, x$12, x$9, x$10)));
    }

    public static AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot getDeliverySnapshot(AtLeastOnceDeliveryLike $this) {
        return new AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot($this.akka$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr(), $this.akka$persistence$AtLeastOnceDeliveryLike$$unconfirmed().map((Function1<Object, AtLeastOnceDelivery.Internal.Delivery>)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final AtLeastOnceDelivery.UnconfirmedDelivery apply(Tuple2<Object, AtLeastOnceDelivery.Internal.Delivery> x0$3) {
                Tuple2<Object, AtLeastOnceDelivery.Internal.Delivery> tuple2 = x0$3;
                if (tuple2 != null) {
                    long deliveryId = tuple2._1$mcJ$sp();
                    AtLeastOnceDelivery.Internal.Delivery d = tuple2._2();
                    AtLeastOnceDelivery.UnconfirmedDelivery unconfirmedDelivery = new AtLeastOnceDelivery.UnconfirmedDelivery(deliveryId, d.destination(), d.message());
                    return unconfirmedDelivery;
                }
                throw new MatchError(tuple2);
            }
        }), scala.collection.package$.MODULE$.breakOut(Predef$.MODULE$.fallbackStringCanBuildFrom())));
    }

    public static void setDeliverySnapshot(AtLeastOnceDeliveryLike $this, AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot snapshot) {
        $this.akka$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr_$eq(snapshot.currentDeliveryId());
        long now = System.nanoTime();
        $this.akka$persistence$AtLeastOnceDeliveryLike$$unconfirmed_$eq(snapshot.unconfirmedDeliveries().map(new Serializable($this, now){
            public static final long serialVersionUID = 0L;
            private final long now$2;

            public final Tuple2<Object, AtLeastOnceDelivery.Internal.Delivery> apply(AtLeastOnceDelivery.UnconfirmedDelivery d) {
                return Predef$ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToLong(d.deliveryId())), new AtLeastOnceDelivery.Internal.Delivery(d.destination(), d.message(), this.now$2, 0));
            }
            {
                this.now$2 = now$2;
            }
        }, scala.collection.package$.MODULE$.breakOut(SortedMap$.MODULE$.canBuildFrom(Ordering$Long$.MODULE$))));
    }

    public static void aroundPreRestart(AtLeastOnceDeliveryLike $this, Throwable reason, Option message) {
        $this.akka$persistence$AtLeastOnceDeliveryLike$$redeliverTask().foreach(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Cancellable x$1) {
                return x$1.cancel();
            }
        });
        $this.akka$persistence$AtLeastOnceDeliveryLike$$super$aroundPreRestart(reason, message);
    }

    public static void aroundPostStop(AtLeastOnceDeliveryLike $this) {
        $this.akka$persistence$AtLeastOnceDeliveryLike$$redeliverTask().foreach(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Cancellable x$2) {
                return x$2.cancel();
            }
        });
        $this.akka$persistence$AtLeastOnceDeliveryLike$$super$aroundPostStop();
    }

    public static void onReplaySuccess(AtLeastOnceDeliveryLike $this) {
        AtLeastOnceDeliveryLike$class.redeliverOverdue($this);
        AtLeastOnceDeliveryLike$class.startRedeliverTask($this);
        $this.akka$persistence$AtLeastOnceDeliveryLike$$super$onReplaySuccess();
    }

    public static void aroundReceive(AtLeastOnceDeliveryLike $this, PartialFunction receive2, Object message) {
        Object object = message;
        if (AtLeastOnceDelivery$Internal$RedeliveryTick$.MODULE$.equals(object)) {
            AtLeastOnceDeliveryLike$class.redeliverOverdue($this);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            $this.akka$persistence$AtLeastOnceDeliveryLike$$super$aroundReceive(receive2, message);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static void $init$(AtLeastOnceDeliveryLike $this) {
        $this.akka$persistence$AtLeastOnceDeliveryLike$_setter_$akka$persistence$AtLeastOnceDeliveryLike$$defaultRedeliverInterval_$eq(((Persistence)Persistence$.MODULE$.apply($this.context().system())).settings().atLeastOnceDelivery().redeliverInterval());
        $this.akka$persistence$AtLeastOnceDeliveryLike$_setter_$akka$persistence$AtLeastOnceDeliveryLike$$defaultRedeliveryBurstLimit_$eq(((Persistence)Persistence$.MODULE$.apply($this.context().system())).settings().atLeastOnceDelivery().redeliveryBurstLimit());
        $this.akka$persistence$AtLeastOnceDeliveryLike$_setter_$akka$persistence$AtLeastOnceDeliveryLike$$defaultWarnAfterNumberOfUnconfirmedAttempts_$eq(((Persistence)Persistence$.MODULE$.apply($this.context().system())).settings().atLeastOnceDelivery().warnAfterNumberOfUnconfirmedAttempts());
        $this.akka$persistence$AtLeastOnceDeliveryLike$_setter_$akka$persistence$AtLeastOnceDeliveryLike$$defaultMaxUnconfirmedMessages_$eq(((Persistence)Persistence$.MODULE$.apply($this.context().system())).settings().atLeastOnceDelivery().maxUnconfirmedMessages());
        $this.akka$persistence$AtLeastOnceDeliveryLike$$redeliverTask_$eq(None$.MODULE$);
        $this.akka$persistence$AtLeastOnceDeliveryLike$$deliverySequenceNr_$eq(0L);
        $this.akka$persistence$AtLeastOnceDeliveryLike$$unconfirmed_$eq((SortedMap<Object, AtLeastOnceDelivery.Internal.Delivery>)SortedMap$.MODULE$.empty((Ordering)Ordering$Long$.MODULE$));
    }
}

