/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.dungeon;

import akka.actor.Actor;
import akka.actor.ActorCell;
import akka.actor.ActorInitializationException;
import akka.actor.ActorInitializationException$;
import akka.actor.DeadLetter;
import akka.actor.NoSerializationVerificationNeeded;
import akka.actor.dungeon.AbstractActorCell;
import akka.dispatch.Envelope;
import akka.dispatch.Mailbox;
import akka.dispatch.MailboxType;
import akka.dispatch.ProducesMessageQueue;
import akka.dispatch.UnboundedMailbox;
import akka.dispatch.sysmsg.Create;
import akka.dispatch.sysmsg.Recreate;
import akka.dispatch.sysmsg.Resume;
import akka.dispatch.sysmsg.Supervise;
import akka.dispatch.sysmsg.Suspend;
import akka.dispatch.sysmsg.SystemMessage;
import akka.dispatch.sysmsg.Terminate;
import akka.event.Logging;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import akka.util.Unsafe;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public abstract class Dispatch$class {
    public static final Mailbox mailbox(ActorCell $this) {
        return (Mailbox)Unsafe.instance.getObjectVolatile($this, AbstractActorCell.mailboxOffset);
    }

    public static final Mailbox swapMailbox(ActorCell $this, Mailbox newMailbox) {
        while (true) {
            Mailbox oldMailbox;
            if (!Unsafe.instance.compareAndSwapObject($this, AbstractActorCell.mailboxOffset, oldMailbox = $this.mailbox(), newMailbox)) continue;
            return oldMailbox;
        }
    }

    public static final boolean hasMessages(ActorCell $this) {
        return $this.mailbox().hasMessages();
    }

    public static final int numberOfMessages(ActorCell $this) {
        return $this.mailbox().numberOfMessages();
    }

    public static final boolean isTerminated(ActorCell $this) {
        return $this.mailbox().isClosed();
    }

    public static final ActorCell init(ActorCell $this, boolean sendSupervise, MailboxType mailboxType) {
        Create create2;
        Mailbox mbox = $this.dispatcher().createMailbox($this, mailboxType);
        Class<? extends Actor> actorClass = $this.props().actorClass();
        MailboxType mailboxType2 = mailboxType;
        if (mailboxType2 instanceof ProducesMessageQueue && $this.system().mailboxes().hasRequiredType(actorClass)) {
            Create create22;
            Class<?> req = $this.system().mailboxes().getRequiredType(actorClass);
            if (req.isInstance(mbox.messageQueue())) {
                create22 = new Create(None$.MODULE$);
            } else {
                String gotType = mbox.messageQueue() == null ? "null" : mbox.messageQueue().getClass().getName();
                create22 = new Create(new Some<ActorInitializationException>(ActorInitializationException$.MODULE$.apply($this.self(), new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Actor [", "] requires mailbox type [", "] got [", "]"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{$this.self(), req, gotType})), ActorInitializationException$.MODULE$.apply$default$3())));
            }
            create2 = create22;
        } else {
            create2 = new Create(None$.MODULE$);
        }
        Create createMessage = create2;
        $this.swapMailbox(mbox);
        $this.mailbox().setActor($this);
        $this.mailbox().systemEnqueue($this.self(), createMessage);
        if (sendSupervise) {
            $this.parent().sendSystemMessage(new Supervise($this.self(), false));
        }
        return $this;
    }

    public static final ActorCell initWithFailure(ActorCell $this, Throwable failure2) {
        Mailbox mbox = $this.dispatcher().createMailbox($this, new UnboundedMailbox());
        $this.swapMailbox(mbox);
        $this.mailbox().setActor($this);
        Create createMessage = new Create(new Some<ActorInitializationException>(ActorInitializationException$.MODULE$.apply($this.self(), "failure while creating ActorCell", failure2)));
        $this.mailbox().systemEnqueue($this.self(), createMessage);
        return $this;
    }

    public static ActorCell start(ActorCell $this) {
        $this.dispatcher().attach($this);
        return $this;
    }

    private static PartialFunction handleException(ActorCell $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ActorCell $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A17 = x1;
                if (A17 instanceof InterruptedException) {
                    InterruptedException interruptedException = (InterruptedException)A17;
                    this.$outer.system().eventStream().publish(new Logging.Error(interruptedException, this.$outer.self().path().toString(), this.$outer.clazz(this.$outer.actor()), "interrupted during message send"));
                    Thread.currentThread().interrupt();
                    object = BoxedUnit.UNIT;
                } else {
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(A17);
                    if (option.isEmpty()) {
                        object = function1.apply(x1);
                    } else {
                        Throwable e = option.get();
                        this.$outer.system().eventStream().publish(new Logging.Error(e, this.$outer.self().path().toString(), this.$outer.clazz(this.$outer.actor()), "swallowing exception during message send"));
                        object = BoxedUnit.UNIT;
                    }
                }
                return object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Option<Throwable> option;
                Throwable throwable = x1;
                boolean bl = throwable instanceof InterruptedException ? true : !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public static final void suspend(ActorCell $this) {
        Throwable throwable2;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Suspend());
            }
            catch (Throwable throwable2) {
                PartialFunction catchExpr$1 = Dispatch$class.handleException($this);
                if (!catchExpr$1.isDefinedAt(throwable2)) break block2;
                catchExpr$1.apply(throwable2);
            }
            return;
        }
        throw throwable2;
    }

    public static final void resume(ActorCell $this, Throwable causedByFailure) {
        Throwable throwable2;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Resume(causedByFailure));
            }
            catch (Throwable throwable2) {
                PartialFunction catchExpr$2 = Dispatch$class.handleException($this);
                if (!catchExpr$2.isDefinedAt(throwable2)) break block2;
                catchExpr$2.apply(throwable2);
            }
            return;
        }
        throw throwable2;
    }

    public static final void restart(ActorCell $this, Throwable cause) {
        Throwable throwable2;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Recreate(cause));
            }
            catch (Throwable throwable2) {
                PartialFunction catchExpr$3 = Dispatch$class.handleException($this);
                if (!catchExpr$3.isDefinedAt(throwable2)) break block2;
                catchExpr$3.apply(throwable2);
            }
            return;
        }
        throw throwable2;
    }

    public static final void stop(ActorCell $this) {
        Throwable throwable2;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, new Terminate());
            }
            catch (Throwable throwable2) {
                PartialFunction catchExpr$4 = Dispatch$class.handleException($this);
                if (!catchExpr$4.isDefinedAt(throwable2)) break block2;
                catchExpr$4.apply(throwable2);
            }
            return;
        }
        throw throwable2;
    }

    public static void sendMessage(ActorCell $this, Envelope msg) {
        Throwable throwable2;
        block10: {
            try {
                BoxedUnit boxedUnit;
                if ($this.system().settings().SerializeAllMessages()) {
                    Object object;
                    Object object2 = msg.message();
                    if (object2 instanceof DeadLetter) {
                        Object wrapped;
                        DeadLetter deadLetter = (DeadLetter)object2;
                        object = wrapped = deadLetter.message();
                    } else {
                        object = object2;
                    }
                    Object unwrapped = object;
                    if (unwrapped instanceof NoSerializationVerificationNeeded) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Object object3;
                        Serialization s2 = (Serialization)SerializationExtension$.MODULE$.apply($this.system());
                        Serializer serializer = s2.findSerializerFor(unwrapped);
                        byte[] bytes = serializer.toBinary(unwrapped);
                        Serializer serializer2 = serializer;
                        if (serializer2 instanceof SerializerWithStringManifest) {
                            SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer2;
                            String manifest = serializerWithStringManifest.manifest(unwrapped);
                            object3 = BoxesRunTime.boxToBoolean(s2.deserialize(bytes, serializer.identifier(), manifest).get() != null);
                        } else {
                            object3 = s2.deserialize(bytes, unwrapped.getClass()).get();
                        }
                        boxedUnit = object3;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                $this.dispatcher().dispatch($this, msg);
            }
            catch (Throwable throwable2) {
                PartialFunction catchExpr$5 = Dispatch$class.handleException($this);
                if (!catchExpr$5.isDefinedAt(throwable2)) break block10;
                catchExpr$5.apply(throwable2);
            }
            return;
        }
        throw throwable2;
    }

    public static void sendSystemMessage(ActorCell $this, SystemMessage message) {
        Throwable throwable2;
        block2: {
            try {
                $this.dispatcher().systemDispatch($this, message);
            }
            catch (Throwable throwable2) {
                PartialFunction catchExpr$6 = Dispatch$class.handleException($this);
                if (!catchExpr$6.isDefinedAt(throwable2)) break block2;
                catchExpr$6.apply(throwable2);
            }
            return;
        }
        throw throwable2;
    }

    public static void $init$(ActorCell $this) {
    }
}

