/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.util;

import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import java.util.concurrent.CountDownLatch;
import org.springframework.context.ApplicationContext;

public class SpringContext {
    public static volatile ApplicationContext context;
    private static volatile CountDownLatch LATCH;

    public static <T> T getBean(Class<T> clazz) throws Exception {
        return SpringContext.getBean(null, clazz);
    }

    public static <T> T getBean(String className) throws Exception {
        LATCH.await();
        String clazzName = className;
        String beanId = null;
        int beanIdIndex = className.indexOf(":");
        if (beanIdIndex > 0) {
            clazzName = className.substring(0, beanIdIndex);
            beanId = className.substring(beanIdIndex + 1);
        }
        Class<?> clazz = Class.forName(clazzName);
        return SpringContext.getBean(beanId, clazz);
    }

    public static <T> T getBean(String className, ClassLoader classLoader) throws Exception {
        LATCH.await();
        String clazzName = className;
        String beanId = null;
        int beanIdIndex = className.indexOf(":");
        if (beanIdIndex > 0) {
            clazzName = className.substring(0, beanIdIndex);
            beanId = className.substring(beanIdIndex + 1);
        }
        Class<?> clazz = null;
        clazz = classLoader == null ? Class.forName(clazzName) : classLoader.loadClass(clazzName);
        return SpringContext.getBean(beanId, clazz);
    }

    private static <T> T getBean(String beanId, Class<?> clazz) throws Exception {
        LATCH.await();
        if (StringUtils.isBlank(beanId)) {
            return (T)context.getBean(clazz);
        }
        return (T)context.getBean(beanId, clazz);
    }

    public static void unlock() {
        LATCH.countDown();
    }

    public static void lock() {
        LATCH = new CountDownLatch(1);
    }

    static {
        LATCH = new CountDownLatch(1);
    }
}

