/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.security;

import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpResponse;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.JsonNode;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.Unirest;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.exceptions.UnirestException;
import com.alibaba.schedulerx.shade.org.apache.commons.configuration.Configuration;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.exception.AuthenticateException;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.security.Authenticator;
import java.util.HashMap;
import java.util.Set;

public class DefaultAuthenticator
implements Authenticator {
    private static final String AUTHENTICATE_URL = "/worker/v1/appgroup/authenticate";
    private static final Logger LOGGER = LogFactory.getLogger(DefaultAuthenticator.class);

    @Override
    public void authenticate(Configuration conf, Set<String> groupIds) throws AuthenticateException {
        JSONResult result = JSONResult.geneFailResult();
        String appKey = conf.getString("appKey");
        if (StringUtils.isEmpty(appKey)) {
            throw new AuthenticateException("please set appKey for groupId=" + groupIds);
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("groups", StringUtils.join(groupIds, ","));
        parameterMap.put("accessKey", conf.getString("appKey"));
        parameterMap.put("type", "authenticate_default");
        String domain = ConfigUtil.getWorkerConfig().getString("domainName");
        if (StringUtils.isNotBlank(domain)) {
            String url = "http://" + domain + AUTHENTICATE_URL;
            try {
                HttpResponse<JsonNode> jsonResponse = Unirest.post(url).fields(parameterMap).asJson();
                if (jsonResponse != null) {
                    result = JsonUtil.fromJson(jsonResponse.getBody().toString(), JSONResult.class);
                }
            }
            catch (UnirestException e) {
                LOGGER.error("groupIds: {} authenticate error, url={}", groupIds, url, e);
            }
            catch (Exception e) {
                LOGGER.error("groupIds: {} authenticate error, url={}", groupIds, url, e);
            }
        }
        if (result != null) {
            if (!result.isSuccess() || !((Boolean)result.getData()).booleanValue()) {
                throw new AuthenticateException(result.getMessage());
            }
        } else {
            throw new AuthenticateException("authenticate result is null");
        }
    }
}

