/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.pull;

import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.container.ContainerPool;
import com.alibaba.schedulerx.worker.container.ThreadContainer;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.pull.BlockingContainerQueue;
import com.alibaba.schedulerx.worker.util.ContanerUtil;
import java.io.IOException;

public class ConsumerThread
extends ThreadContainer {
    private volatile boolean running = true;
    private BlockingContainerQueue queue;
    private static Logger LOGGER = LogFactory.getLogger(ConsumerThread.class);

    public ConsumerThread(JobContext context, ContainerPool containerPool) throws Exception {
        super(context, containerPool);
    }

    public ConsumerThread(BlockingContainerQueue queue, ContainerPool containerPool, String taskMasterAkkaPath) throws Exception {
        this.queue = queue;
        this.containerPool = containerPool;
        this.masterActorSelection = SchedulerxWorker.actorSystem.actorSelection(taskMasterAkkaPath);
        if (this.masterActorSelection == null) {
            String errMsg = "get taskMaster akka path error, path=" + taskMasterAkkaPath;
            LOGGER.error(errMsg);
            throw new IOException(errMsg);
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Worker.MasterStartContainerRequest request = this.queue.get();
                if (request == null) continue;
                JobContext context = ContanerUtil.convert2JobContext(request);
                this.setContext(context);
                this.containerPool.put(context.getUniqueId(), this);
                super.start();
            }
            catch (Exception e) {
                LOGGER.error("", e);
            }
        }
    }

    public void stopRunning() {
        this.running = false;
    }
}

