/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.processor.demo;

import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.processor.JavaProcessor;
import com.alibaba.schedulerx.worker.processor.ProcessResult;
import org.springframework.stereotype.Component;

@Component
public class TestSimpleJobProcessor
extends JavaProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(TestSimpleJobProcessor.class);

    @Override
    public ProcessResult process(JobContext context) {
        LOGGER.info("Hello SchedulerX2.0! This is [TestSimpleJobProcessor], jobInstanceId={}_{}_{}.", context.getJobId(), context.getJobInstanceId(), context.getTaskId());
        this.sleep(context);
        return new ProcessResult(true);
    }

    private void sleep(JobContext context) {
        try {
            String parameter = context.getJobParameters();
            if (parameter != null && !parameter.isEmpty()) {
                long temp = Long.parseLong(parameter);
                Thread.sleep(temp);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("parse sleep parameters failed. jobId={}_{}_{}.", context.getJobId(), context.getJobInstanceId(), context.getTaskId(), ex);
        }
    }
}

