/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.processor.demo;

import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.org.apache.commons.collections.CollectionUtils;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.domain.JobContext;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.processor.MapJobProcessor;
import com.alibaba.schedulerx.worker.processor.ProcessResult;
import com.alibaba.schedulerx.worker.processor.demo.TestTaskObject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class TestGridJobProcessor
extends MapJobProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(TestGridJobProcessor.class);
    private static final String FIRST_LEVEL_DISPATCH = "FIRST_LEVEL_DISPATCH";
    private static final String SECOND_LEVEL_DISPATCH = "SECOND_LEVEL_DISPATCH";

    @Override
    public ProcessResult process(JobContext context) {
        String taskName = context.getTaskName();
        if ("MAP_TASK_ROOT".equals(taskName)) {
            LOGGER.info("[TestGridJobProcessor] Start root task.");
            LOGGER.info("jobId={}, jobInstanceId={}, jobParameters={}, instanceParameters={}", context.getJobId(), context.getJobInstanceId(), context.getJobParameters(), context.getInstanceParameters());
            List<TestTaskObject> tasks = this.buildFirstLevelDispatchTasks(context);
            if (CollectionUtils.isEmpty(tasks)) {
                return new ProcessResult(true);
            }
            return this.map(tasks, FIRST_LEVEL_DISPATCH);
        }
        if (FIRST_LEVEL_DISPATCH.equals(taskName)) {
            LOGGER.info("[TestGridJobProcessor] Start FIRST_LEVEL_DISPATCH task.");
            List<TestTaskObject> secondTasks = this.buildSecondLevelDispatchTasks(context);
            if (CollectionUtils.isEmpty(secondTasks)) {
                return new ProcessResult(true);
            }
            return this.map(secondTasks, SECOND_LEVEL_DISPATCH);
        }
        if (SECOND_LEVEL_DISPATCH.equals(taskName)) {
            LOGGER.info("[TestGridJobProcessor] Start SECOND_LEVEL_DISPATCH task.");
            this.doLastLevelTask(context);
            return new ProcessResult(true);
        }
        return new ProcessResult(false);
    }

    private void doLastLevelTask(JobContext context) {
        TestTaskObject taskObject = (TestTaskObject)context.getTask();
        LOGGER.info("TestTaskObject={}", taskObject);
    }

    private List<TestTaskObject> buildFirstLevelDispatchTasks(JobContext context) {
        ArrayList<TestTaskObject> tasks = Lists.newArrayList();
        int taskNum = 10;
        if (!StringUtils.isBlank(context.getJobParameters())) {
            taskNum = Integer.valueOf(context.getJobParameters());
        }
        for (int i = 0; i <= taskNum; ++i) {
            tasks.add(new TestTaskObject(i, "Hello SchedulerX2.0! This is [TestGridJobProcessor] first level msg_" + i));
        }
        return tasks;
    }

    private List<TestTaskObject> buildSecondLevelDispatchTasks(JobContext context) {
        TestTaskObject firstTaskObject = (TestTaskObject)context.getTask();
        ArrayList<TestTaskObject> tasks = Lists.newArrayList();
        if (firstTaskObject.getId() % 3 == 0) {
            for (int i = 0; i < firstTaskObject.getId(); ++i) {
                tasks.add(new TestTaskObject(i, "Hello SchedulerX2.0! This is [TestGridJobProcessor] second level msg_" + i + " , fisTaskId=" + firstTaskObject.getId()));
            }
        }
        return tasks;
    }
}

