/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master;

import akka.actor.ActorContext;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.TaskMaster;
import java.lang.reflect.Constructor;

public class TaskMasterFactory {
    private static final Logger LOGGER = LogFactory.getLogger(TaskMasterFactory.class);

    public static TaskMaster create(JobInstanceInfo jobInstanceInfo, ActorContext actorContext) throws Exception {
        TaskMaster taskMaster = null;
        String className = ConfigUtil.getWorkerConfig().getString("worker.master." + jobInstanceInfo.getExecuteMode());
        if (className == null) {
            String errMsg = "class not found of worker.master." + jobInstanceInfo.getExecuteMode();
            LOGGER.error(errMsg);
            throw new ClassNotFoundException(errMsg);
        }
        Constructor<?> constructor = Class.forName(className).getConstructor(JobInstanceInfo.class, ActorContext.class);
        taskMaster = (TaskMaster)constructor.newInstance(jobInstanceInfo, actorContext);
        return taskMaster;
    }
}

