/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.logcollector;

import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.logcollector.LogCleaner;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class LocalLogCleaner
extends LogCleaner {
    private static final Logger LOGGER = LogFactory.getLogger(LocalLogCleaner.class);
    private static final int CLEAN_DAYS_BEFORE = 7;
    private ScheduledExecutorService logCleanES = Executors.newScheduledThreadPool(1, new ThreadFactory(){
        int index = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            ++this.index;
            return new Thread(runnable, "Schedulerx-log-clean-thread-" + this.index);
        }
    });

    @Override
    public void init() {
        this.logCleanES.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DateTime now = DateTime.now();
                try {
                    File file = new File("/tmp/logs/schedulerx/userlog");
                    if (file.exists()) {
                        File[] children;
                        for (File child : children = file.listFiles()) {
                            DateTime dt = new DateTime((Object)child.getName());
                            if (!dt.isBefore((ReadableInstant)now.withTimeAtStartOfDay().minusDays(7))) continue;
                            LocalLogCleaner.deleteAllFilesOfDir(child);
                        }
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("[LocalLogCleaner] log clean error: ", e);
                }
            }
        }, 300L, 86400L, TimeUnit.SECONDS);
        LOGGER.info("[LocalLogCleaner] stared.");
    }

    public static void deleteAllFilesOfDir(File path) {
        if (path == null) {
            LOGGER.warn("path is null");
            return;
        }
        if (!path.exists()) {
            return;
        }
        if (path.isFile()) {
            path.delete();
            return;
        }
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                LocalLogCleaner.deleteAllFilesOfDir(file);
            }
        } else {
            LOGGER.warn("list files is null, path=" + path.getPath());
        }
        path.delete();
    }
}

