/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.ha;

import akka.actor.ActorSelection;
import akka.japi.Function;
import akka.persistence.AtLeastOnceDelivery;
import akka.persistence.SnapshotOffer;
import akka.persistence.UntypedPersistentActorWithAtLeastOnceDelivery;
import com.alibaba.schedulerx.common.util.ReflectionUtil;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.worker.discovery.ServerDiscoveryFactory;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.util.ActorPathUtil;
import java.util.List;

public class AtLeastOnceDeliveryActor
extends UntypedPersistentActorWithAtLeastOnceDelivery {
    private int id = 0;
    private static final Logger LOGGER = LogFactory.getLogger(AtLeastOnceDeliveryActor.class);

    public AtLeastOnceDeliveryActor(int id) {
        this.id = id;
    }

    public String persistenceId() {
        return "persistence-id-" + this.id;
    }

    public void onReceiveCommand(Object obj) throws Throwable {
        if (obj instanceof Worker.WorkerReportJobInstanceStatusRequest) {
            this.handleReportInstanceStatusEvent((Worker.WorkerReportJobInstanceStatusRequest)obj);
        } else if (obj instanceof Worker.WorkerBatchReportTaskStatuesRequest) {
            this.handleBatchReportTaskStatues((Worker.WorkerBatchReportTaskStatuesRequest)obj);
        } else if (obj instanceof Worker.ContainerBatchReportTaskStatuesRequest) {
            this.handleContainerBatchStatus((Worker.ContainerBatchReportTaskStatuesRequest)obj);
        } else if (obj instanceof Worker.MasterDestroyContainerPoolRequest) {
            this.handleDestroyContainerPool((Worker.MasterDestroyContainerPoolRequest)obj);
        } else if (obj instanceof Worker.WorkerReportJobInstanceStatusResponse) {
            Worker.WorkerReportJobInstanceStatusResponse response = (Worker.WorkerReportJobInstanceStatusResponse)obj;
            if (response.getSuccess()) {
                this.confirmDelivery(response.getDeliveryId());
            } else {
                LOGGER.error("WorkerReportJobInstanceStatus not success, reason:{}", response.getMessage());
            }
        } else if (obj instanceof Worker.WorkerBatchReportTaskStatuesResponse) {
            Worker.WorkerBatchReportTaskStatuesResponse response = (Worker.WorkerBatchReportTaskStatuesResponse)obj;
            if (response.getSuccess()) {
                this.confirmDelivery(response.getDeliveryId());
            } else {
                LOGGER.error("WorkerBatchReportTaskStatues not success, reason:{}", response.getMessage());
            }
        } else if (obj instanceof Worker.ContainerBatchReportTaskStatuesResponse) {
            Worker.ContainerBatchReportTaskStatuesResponse response = (Worker.ContainerBatchReportTaskStatuesResponse)obj;
            if (response.getSuccess()) {
                this.confirmDelivery(response.getDeliveryId());
            } else {
                LOGGER.error("ContainerBatchReportTaskStatues not success, reason:{}", response.getMessage());
            }
        } else if (obj instanceof Worker.MasterDestroyContainerPoolResponse) {
            Worker.MasterDestroyContainerPoolResponse response = (Worker.MasterDestroyContainerPoolResponse)obj;
            if (response.getSuccess()) {
                this.confirmDelivery(response.getDeliveryId());
            } else {
                LOGGER.error("MasterDestroyContainerPool not success, reason:{}", response.getMessage());
            }
        } else if (obj instanceof AtLeastOnceDelivery.UnconfirmedWarning) {
            try {
                List list = ((AtLeastOnceDelivery.UnconfirmedWarning)obj).getUnconfirmedDeliveries();
                for (AtLeastOnceDelivery.UnconfirmedDelivery unconfirmedDelivery : list) {
                    Object unConfirmedMsg = unconfirmedDelivery.getMessage();
                    long deliveryId = (Long)ReflectionUtil.invokeMethod(unConfirmedMsg, "getDeliveryId");
                    this.confirmDelivery(deliveryId);
                    this.unConfirmRetry(unConfirmedMsg);
                }
            }
            catch (Exception e) {
                LOGGER.error("", e);
            }
        } else if (obj instanceof SnapshotOffer) {
            AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot snapshot = (AtLeastOnceDelivery.AtLeastOnceDeliverySnapshot)((SnapshotOffer)obj).snapshot();
            this.setDeliverySnapshot(snapshot);
        }
    }

    public void onReceiveRecover(Object obj) throws Throwable {
    }

    private void handleReportInstanceStatusEvent(final Worker.WorkerReportJobInstanceStatusRequest request) {
        ActorSelection serverSelection = ServerDiscoveryFactory.getDiscovery(request.getGroupId()).getInstanceStatusRouter();
        this.deliver(serverSelection, (Function)new Function<Long, Object>(){

            public Object apply(Long deliveryId) {
                return request.toBuilder().setDeliveryId(deliveryId.longValue()).build();
            }
        });
        LOGGER.info("report jobInstance={}, status={} to server={}", request.getJobInstanceId(), request.getStatus(), serverSelection);
    }

    private void handleBatchReportTaskStatues(final Worker.WorkerBatchReportTaskStatuesRequest request) {
        ActorSelection serverSelection = ServerDiscoveryFactory.getDiscovery(request.getGroupId()).getTaskStatusRouter();
        this.deliver(serverSelection, (Function)new Function<Long, Object>(){

            public Object apply(Long deliveryId) {
                return request.toBuilder().setDeliveryId(deliveryId.longValue()).build();
            }
        });
        LOGGER.debug("batch report task statues jobInstanceId={} to server={}", request.getJobInstanceId(), serverSelection);
    }

    private void handleContainerBatchStatus(final Worker.ContainerBatchReportTaskStatuesRequest request) {
        ActorSelection taskMasterSelection = this.getContext().actorSelection(request.getTaskMasterAkkaPath());
        this.deliver(taskMasterSelection, (Function)new Function<Long, Object>(){

            public Object apply(Long deliveryId) {
                return request.toBuilder().setDeliveryId(deliveryId.longValue()).build();
            }
        });
    }

    private void handleDestroyContainerPool(final Worker.MasterDestroyContainerPoolRequest request) {
        ActorSelection selection = this.getContext().actorSelection(ActorPathUtil.getContainerRouterPath(request.getWorkerIdAddr()));
        this.deliver(selection, (Function)new Function<Long, Object>(){

            public Object apply(Long deliveryId) {
                return request.toBuilder().setDeliveryId(deliveryId.longValue()).build();
            }
        });
    }

    private void unConfirmRetry(Object msg) {
        Worker.WorkerReportJobInstanceStatusRequest request;
        if (msg instanceof Worker.ContainerBatchReportTaskStatuesRequest) {
            Worker.ContainerBatchReportTaskStatuesRequest request2 = (Worker.ContainerBatchReportTaskStatuesRequest)msg;
            if (!request2.hasAlreadyUnConfirmRetry() || !request2.getAlreadyUnConfirmRetry()) {
                request2 = request2.toBuilder().setAlreadyUnConfirmRetry(true).build();
                this.getSelf().tell((Object)request2, null);
                LOGGER.info("jobInstanceId={}, ContainerBatchReportTaskStatuesRequest unconfirm retry", request2.getJobInstanceId());
            }
        } else if (msg instanceof Worker.MasterDestroyContainerPoolRequest) {
            Worker.MasterDestroyContainerPoolRequest request3 = (Worker.MasterDestroyContainerPoolRequest)msg;
            if (!request3.hasAlreadyUnConfirmRetry() || !request3.getAlreadyUnConfirmRetry()) {
                request3 = request3.toBuilder().setAlreadyUnConfirmRetry(true).build();
                this.getSelf().tell((Object)request3, null);
                LOGGER.info("MasterDestroyContainerPoolRequest unconfirm retry, jobInstanceId={}, workerIdAddr={}", request3.getJobInstanceId(), request3.getWorkerIdAddr());
            }
        } else if (msg instanceof Worker.WorkerBatchReportTaskStatuesRequest) {
            Worker.WorkerBatchReportTaskStatuesRequest request4 = (Worker.WorkerBatchReportTaskStatuesRequest)msg;
            if (!request4.hasAlreadyUnConfirmRetry() || !request4.getAlreadyUnConfirmRetry()) {
                request4 = request4.toBuilder().setAlreadyUnConfirmRetry(true).build();
                this.getSelf().tell((Object)request4, null);
                LOGGER.info("jobInstanceId={}, WorkerBatchReportTaskStatuesRequest unconfirm retry", request4.getJobInstanceId());
            }
        } else if (!(!(msg instanceof Worker.WorkerReportJobInstanceStatusRequest) || (request = (Worker.WorkerReportJobInstanceStatusRequest)msg).hasAlreadyUnConfirmRetry() && request.getAlreadyUnConfirmRetry())) {
            request = request.toBuilder().setAlreadyUnConfirmRetry(true).build();
            this.getSelf().tell((Object)request, null);
            LOGGER.info("jobInstanceId={}, WorkerReportJobInstanceStatusRequest unconfirm retry", request.getJobInstanceId());
        }
    }
}

