/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.fulltext;

import com.alibaba.schedulerx.shade.org.h2.api.Trigger;
import com.alibaba.schedulerx.shade.org.h2.command.Parser;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Comparison;
import com.alibaba.schedulerx.shade.org.h2.expression.ConditionAndOr;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.schedulerx.shade.org.h2.expression.ValueExpression;
import com.alibaba.schedulerx.shade.org.h2.fulltext.FullTextSettings;
import com.alibaba.schedulerx.shade.org.h2.fulltext.IndexInfo;
import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcConnection;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.tools.SimpleResultSet;
import com.alibaba.schedulerx.shade.org.h2.util.IOUtils;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;

public class FullText {
    private static final String FIELD_SCHEMA = "SCHEMA";
    private static final String FIELD_TABLE = "TABLE";
    private static final String FIELD_COLUMNS = "COLUMNS";
    private static final String FIELD_KEYS = "KEYS";
    private static final String FIELD_SCORE = "SCORE";
    private static final String TRIGGER_PREFIX = "FT_";
    private static final String SCHEMA = "FT";
    private static final String SELECT_MAP_BY_WORD_ID = "SELECT ROWID FROM FT.MAP WHERE WORDID=?";
    private static final String SELECT_ROW_BY_ID = "SELECT KEY, INDEXID FROM FT.ROWS WHERE ID=?";
    private static final String FIELD_QUERY = "QUERY";

    public static void init(Connection connection) throws SQLException {
        String string;
        Statement statement = connection.createStatement();
        statement.execute("CREATE SCHEMA IF NOT EXISTS FT");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.INDEXES(ID INT AUTO_INCREMENT PRIMARY KEY, SCHEMA VARCHAR, TABLE VARCHAR, COLUMNS VARCHAR, UNIQUE(SCHEMA, TABLE))");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.WORDS(ID INT AUTO_INCREMENT PRIMARY KEY, NAME VARCHAR, UNIQUE(NAME))");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.ROWS(ID IDENTITY, HASH INT, INDEXID INT, KEY VARCHAR, UNIQUE(HASH, INDEXID, KEY))");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.MAP(ROWID INT, WORDID INT, PRIMARY KEY(WORDID, ROWID))");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.IGNORELIST(LIST VARCHAR)");
        statement.execute("CREATE TABLE IF NOT EXISTS FT.SETTINGS(KEY VARCHAR PRIMARY KEY, VALUE VARCHAR)");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_CREATE_INDEX FOR \"" + FullText.class.getName() + ".createIndex\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_DROP_INDEX FOR \"" + FullText.class.getName() + ".dropIndex\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_SEARCH FOR \"" + FullText.class.getName() + ".search\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_SEARCH_DATA FOR \"" + FullText.class.getName() + ".searchData\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_REINDEX FOR \"" + FullText.class.getName() + ".reindex\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FT_DROP_ALL FOR \"" + FullText.class.getName() + ".dropAll\"");
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        ResultSet resultSet = statement.executeQuery("SELECT * FROM FT.IGNORELIST");
        while (resultSet.next()) {
            string = resultSet.getString(1);
            FullText.setIgnoreList(fullTextSettings, string);
        }
        resultSet = statement.executeQuery("SELECT * FROM FT.SETTINGS");
        while (resultSet.next()) {
            string = resultSet.getString(1);
            if (!"whitespaceChars".equals(string)) continue;
            String string2 = resultSet.getString(2);
            fullTextSettings.setWhitespaceChars(string2);
        }
        resultSet = statement.executeQuery("SELECT * FROM FT.WORDS");
        while (resultSet.next()) {
            string = resultSet.getString("NAME");
            int n = resultSet.getInt("ID");
            if ((string = fullTextSettings.convertWord(string)) == null) continue;
            fullTextSettings.addWord(string, n);
        }
        fullTextSettings.setInitialized(true);
    }

    public static void createIndex(Connection connection, String string, String string2, String string3) throws SQLException {
        FullText.init(connection);
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO FT.INDEXES(SCHEMA, TABLE, COLUMNS) VALUES(?, ?, ?)");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.execute();
        FullText.createTrigger(connection, string, string2);
        FullText.indexExistingRows(connection, string, string2);
    }

    public static void reindex(Connection connection) throws SQLException {
        FullText.init(connection);
        FullText.removeAllTriggers(connection, TRIGGER_PREFIX);
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        fullTextSettings.clearWordList();
        Statement statement = connection.createStatement();
        statement.execute("TRUNCATE TABLE FT.WORDS");
        statement.execute("TRUNCATE TABLE FT.ROWS");
        statement.execute("TRUNCATE TABLE FT.MAP");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM FT.INDEXES");
        while (resultSet.next()) {
            String string = resultSet.getString(FIELD_SCHEMA);
            String string2 = resultSet.getString(FIELD_TABLE);
            FullText.createTrigger(connection, string, string2);
            FullText.indexExistingRows(connection, string, string2);
        }
    }

    public static void dropIndex(Connection connection, String string, String string2) throws SQLException {
        int n;
        FullText.init(connection);
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT ID FROM FT.INDEXES WHERE SCHEMA=? AND TABLE=?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            return;
        }
        int n2 = resultSet.getInt(1);
        preparedStatement = connection.prepareStatement("DELETE FROM FT.INDEXES WHERE ID=?");
        preparedStatement.setInt(1, n2);
        preparedStatement.execute();
        FullText.createOrDropTrigger(connection, string, string2, false);
        preparedStatement = connection.prepareStatement("DELETE FROM FT.ROWS WHERE INDEXID=? AND ROWNUM<10000");
        do {
            preparedStatement.setInt(1, n2);
        } while ((n = preparedStatement.executeUpdate()) != 0);
        preparedStatement = connection.prepareStatement("DELETE FROM FT.MAP WHERE NOT EXISTS (SELECT * FROM FT.ROWS R WHERE R.ID=ROWID) AND ROWID<10000");
        while ((n = preparedStatement.executeUpdate()) != 0) {
        }
    }

    public static void dropAll(Connection connection) throws SQLException {
        FullText.init(connection);
        Statement statement = connection.createStatement();
        statement.execute("DROP SCHEMA IF EXISTS FT CASCADE");
        FullText.removeAllTriggers(connection, TRIGGER_PREFIX);
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        fullTextSettings.removeAllIndexes();
        fullTextSettings.clearIgnored();
        fullTextSettings.clearWordList();
    }

    public static ResultSet search(Connection connection, String string, int n, int n2) throws SQLException {
        try {
            return FullText.search(connection, string, n, n2, false);
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    public static ResultSet searchData(Connection connection, String string, int n, int n2) throws SQLException {
        try {
            return FullText.search(connection, string, n, n2, true);
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    public static void setIgnoreList(Connection connection, String string) throws SQLException {
        try {
            FullText.init(connection);
            FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
            FullText.setIgnoreList(fullTextSettings, string);
            Statement statement = connection.createStatement();
            statement.execute("TRUNCATE TABLE FT.IGNORELIST");
            PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO FT.IGNORELIST VALUES(?)");
            preparedStatement.setString(1, string);
            preparedStatement.execute();
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    public static void setWhitespaceChars(Connection connection, String string) throws SQLException {
        try {
            FullText.init(connection);
            FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
            fullTextSettings.setWhitespaceChars(string);
            PreparedStatement preparedStatement = connection.prepareStatement("MERGE INTO FT.SETTINGS VALUES(?, ?)");
            preparedStatement.setString(1, "whitespaceChars");
            preparedStatement.setString(2, string);
            preparedStatement.execute();
        }
        catch (DbException dbException) {
            throw DbException.toSQLException(dbException);
        }
    }

    protected static String asString(Object object, int n) throws SQLException {
        if (object == null) {
            return "NULL";
        }
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                return object.toString();
            }
            case 2005: {
                try {
                    if (object instanceof Clob) {
                        object = ((Clob)object).getCharacterStream();
                    }
                    return IOUtils.readStringAndClose((Reader)object, -1);
                }
                catch (IOException iOException) {
                    throw DbException.toSQLException(iOException);
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2006: {
                throw FullText.throwException("Unsupported column data type: " + n);
            }
        }
        return "";
    }

    protected static SimpleResultSet createResultSet(boolean bl) {
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        if (bl) {
            simpleResultSet.addColumn(FIELD_SCHEMA, 12, 0, 0);
            simpleResultSet.addColumn(FIELD_TABLE, 12, 0, 0);
            simpleResultSet.addColumn(FIELD_COLUMNS, 2003, 0, 0);
            simpleResultSet.addColumn(FIELD_KEYS, 2003, 0, 0);
        } else {
            simpleResultSet.addColumn(FIELD_QUERY, 12, 0, 0);
        }
        simpleResultSet.addColumn(FIELD_SCORE, 6, 0, 0);
        return simpleResultSet;
    }

    protected static Object[][] parseKey(Connection connection, String string) {
        ArrayList<String> arrayList = New.arrayList();
        ArrayList<String> arrayList2 = New.arrayList();
        JdbcConnection jdbcConnection = (JdbcConnection)connection;
        Session session = (Session)jdbcConnection.getSession();
        Parser parser = new Parser(session);
        Expression expression = parser.parseExpression(string);
        FullText.addColumnData(arrayList, arrayList2, expression);
        Object[] objectArray = arrayList.toArray();
        Object[] objectArray2 = arrayList2.toArray();
        Object[][] objectArray3 = new Object[][]{objectArray, objectArray2};
        return objectArray3;
    }

    protected static String quoteSQL(Object object, int n) throws SQLException {
        if (object == null) {
            return "NULL";
        }
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return object.toString();
            }
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return FullText.quoteString(object.toString());
            }
            case -4: 
            case -3: 
            case -2: {
                if (object instanceof UUID) {
                    return "'" + object.toString() + "'";
                }
                return "'" + StringUtils.convertBytesToHex((byte[])object) + "'";
            }
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw FullText.throwException("Unsupported key data type: " + n);
            }
        }
        return "";
    }

    protected static void removeAllTriggers(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM INFORMATION_SCHEMA.TRIGGERS");
        Statement statement2 = connection.createStatement();
        while (resultSet.next()) {
            String string2 = resultSet.getString("TRIGGER_SCHEMA");
            String string3 = resultSet.getString("TRIGGER_NAME");
            if (!string3.startsWith(string)) continue;
            string3 = StringUtils.quoteIdentifier(string2) + "." + StringUtils.quoteIdentifier(string3);
            statement2.execute("DROP TRIGGER " + string3);
        }
    }

    protected static void setColumns(int[] nArray, ArrayList<String> arrayList, ArrayList<String> arrayList2) throws SQLException {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = arrayList.get(i);
            int n2 = -1;
            int n3 = arrayList2.size();
            for (int j = 0; n2 == -1 && j < n3; ++j) {
                String string2 = arrayList2.get(j);
                if (!string2.equals(string)) continue;
                n2 = j;
            }
            if (n2 < 0) {
                throw FullText.throwException("Column not found: " + string);
            }
            nArray[i] = n2;
        }
    }

    protected static ResultSet search(Connection connection, String string, int n, int n2, boolean bl) throws SQLException {
        Object object;
        Object object2;
        SimpleResultSet simpleResultSet = FullText.createResultSet(bl);
        if (connection.getMetaData().getURL().startsWith("jdbc:columnlist:")) {
            return simpleResultSet;
        }
        if (string == null || string.trim().length() == 0) {
            return simpleResultSet;
        }
        FullTextSettings fullTextSettings = FullTextSettings.getInstance(connection);
        if (!fullTextSettings.isInitialized()) {
            FullText.init(connection);
        }
        HashSet<String> hashSet = new HashSet<String>();
        FullText.addWords(fullTextSettings, hashSet, string);
        HashSet<Object> hashSet2 = null;
        PreparedStatement preparedStatement = fullTextSettings.prepare(connection, SELECT_MAP_BY_WORD_ID);
        for (String string2 : hashSet) {
            HashSet<Object> hashSet3 = hashSet2;
            hashSet2 = new HashSet<Object>();
            object2 = fullTextSettings.getWordId(string2);
            if (object2 == null) continue;
            preparedStatement.setInt(1, (Integer)object2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = resultSet.getInt(1);
                if (hashSet3 != null && !hashSet3.contains(object)) continue;
                hashSet2.add(object);
            }
        }
        if (hashSet2 == null || hashSet2.isEmpty()) {
            return simpleResultSet;
        }
        PreparedStatement preparedStatement2 = fullTextSettings.prepare(connection, SELECT_ROW_BY_ID);
        int n3 = 0;
        object2 = hashSet2.iterator();
        while (object2.hasNext()) {
            Object object3;
            int n4 = (Integer)object2.next();
            preparedStatement2.setInt(1, n4);
            object = preparedStatement2.executeQuery();
            if (!object.next()) continue;
            if (n2 > 0) {
                --n2;
                continue;
            }
            String string3 = object.getString(1);
            int n5 = object.getInt(2);
            IndexInfo indexInfo = fullTextSettings.getIndexInfo(n5);
            if (bl) {
                object3 = FullText.parseKey(connection, string3);
                simpleResultSet.addRow(indexInfo.schema, indexInfo.table, object3[0], object3[1], 1.0);
            } else {
                object3 = StringUtils.quoteIdentifier(indexInfo.schema) + "." + StringUtils.quoteIdentifier(indexInfo.table) + " WHERE " + string3;
                simpleResultSet.addRow(object3, 1.0);
            }
            if (n <= 0 || ++n3 < n) continue;
            break;
        }
        return simpleResultSet;
    }

    private static void addColumnData(ArrayList<String> arrayList, ArrayList<String> arrayList2, Expression expression) {
        if (expression instanceof ConditionAndOr) {
            ConditionAndOr conditionAndOr = (ConditionAndOr)expression;
            Expression expression2 = conditionAndOr.getExpression(true);
            Expression expression3 = conditionAndOr.getExpression(false);
            FullText.addColumnData(arrayList, arrayList2, expression2);
            FullText.addColumnData(arrayList, arrayList2, expression3);
        } else {
            Comparison comparison = (Comparison)expression;
            ExpressionColumn expressionColumn = (ExpressionColumn)comparison.getExpression(true);
            ValueExpression valueExpression = (ValueExpression)comparison.getExpression(false);
            String string = expressionColumn.getColumnName();
            arrayList.add(string);
            if (valueExpression == null) {
                arrayList2.add(null);
            } else {
                arrayList2.add(valueExpression.getValue(null).getString());
            }
        }
    }

    protected static void addWords(FullTextSettings fullTextSettings, Set<String> set, Reader reader) {
        char[] cArray;
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 255);
        for (char c : cArray = fullTextSettings.getWhitespaceChars().toCharArray()) {
            streamTokenizer.whitespaceChars(c, c);
        }
        try {
            int n;
            while ((n = streamTokenizer.nextToken()) != -1) {
                if (n != -3) continue;
                String string = streamTokenizer.sval;
                if ((string = fullTextSettings.convertWord(string)) == null) continue;
                set.add(string);
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, "Tokenizer error");
        }
    }

    protected static void addWords(FullTextSettings fullTextSettings, Set<String> set, String string) {
        String string2 = fullTextSettings.getWhitespaceChars();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if ((string3 = fullTextSettings.convertWord(string3)) == null) continue;
            set.add(string3);
        }
    }

    private static void createTrigger(Connection connection, String string, String string2) throws SQLException {
        FullText.createOrDropTrigger(connection, string, string2, true);
    }

    private static void createOrDropTrigger(Connection connection, String string, String string2, boolean bl) throws SQLException {
        try (Statement statement = connection.createStatement();){
            String string3 = StringUtils.quoteIdentifier(string) + "." + StringUtils.quoteIdentifier(TRIGGER_PREFIX + string2);
            statement.execute("DROP TRIGGER IF EXISTS " + string3);
            if (bl) {
                boolean bl2 = FullTextTrigger.isMultiThread(connection);
                StringBuilder stringBuilder = new StringBuilder("CREATE TRIGGER IF NOT EXISTS ");
                stringBuilder.append(string3).append(" AFTER INSERT, UPDATE, DELETE");
                if (!bl2) {
                    stringBuilder.append(", ROLLBACK");
                }
                stringBuilder.append(" ON ").append(StringUtils.quoteIdentifier(string)).append('.').append(StringUtils.quoteIdentifier(string2)).append(" FOR EACH ROW CALL \"").append(FullTextTrigger.class.getName()).append('\"');
                statement.execute(stringBuilder.toString());
            }
        }
    }

    private static void indexExistingRows(Connection connection, String string, String string2) throws SQLException {
        FullTextTrigger fullTextTrigger = new FullTextTrigger();
        fullTextTrigger.init(connection, string, null, string2, false, 1);
        String string3 = "SELECT * FROM " + StringUtils.quoteIdentifier(string) + "." + StringUtils.quoteIdentifier(string2);
        ResultSet resultSet = connection.createStatement().executeQuery(string3);
        int n = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = resultSet.getObject(i + 1);
            }
            fullTextTrigger.fire(connection, null, objectArray);
        }
    }

    private static String quoteString(String string) {
        if (string.indexOf(39) < 0) {
            return "'" + string + "'";
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 2);
        stringBuilder.append('\'');
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuilder.append(c);
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    private static void setIgnoreList(FullTextSettings fullTextSettings, String string) {
        String[] stringArray = StringUtils.arraySplit(string, ',', true);
        fullTextSettings.addIgnored(Arrays.asList(stringArray));
    }

    protected static boolean hasChanged(Object[] objectArray, Object[] objectArray2, int[] nArray) {
        for (int n : nArray) {
            Object object = objectArray[n];
            Object object2 = objectArray2[n];
            if (!(object == null ? object2 != null : !object.equals(object2))) continue;
            return true;
        }
        return false;
    }

    public static void closeAll() {
        FullTextSettings.closeAll();
    }

    protected static SQLException throwException(String string) throws SQLException {
        throw new SQLException(string, "FULLTEXT");
    }

    public static final class FullTextTrigger
    implements Trigger {
        private FullTextSettings setting;
        private IndexInfo index;
        private int[] columnTypes;
        private final PreparedStatement[] prepStatements = new PreparedStatement[SQL.length];
        private boolean useOwnConnection;
        private static final int INSERT_WORD = 0;
        private static final int INSERT_ROW = 1;
        private static final int INSERT_MAP = 2;
        private static final int DELETE_ROW = 3;
        private static final int DELETE_MAP = 4;
        private static final int SELECT_ROW = 5;
        private static final String[] SQL = new String[]{"MERGE INTO FT.WORDS(NAME) KEY(NAME) VALUES(?)", "INSERT INTO FT.ROWS(HASH, INDEXID, KEY) VALUES(?, ?, ?)", "INSERT INTO FT.MAP(ROWID, WORDID) VALUES(?, ?)", "DELETE FROM FT.ROWS WHERE HASH=? AND INDEXID=? AND KEY=?", "DELETE FROM FT.MAP WHERE ROWID=? AND WORDID=?", "SELECT ID FROM FT.ROWS WHERE HASH=? AND INDEXID=? AND KEY=?"};

        @Override
        public void init(Connection connection, String string, String string2, String string3, boolean bl, int n) throws SQLException {
            this.setting = FullTextSettings.getInstance(connection);
            if (!this.setting.isInitialized()) {
                FullText.init(connection);
            }
            ArrayList<String> arrayList = New.arrayList();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(null, StringUtils.escapeMetaDataPattern(string), StringUtils.escapeMetaDataPattern(string3), null);
            ArrayList<String> arrayList2 = New.arrayList();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getString("COLUMN_NAME"));
            }
            this.columnTypes = new int[arrayList2.size()];
            this.index = new IndexInfo();
            this.index.schema = string;
            this.index.table = string3;
            this.index.columns = arrayList2.toArray(new String[0]);
            resultSet = databaseMetaData.getColumns(null, StringUtils.escapeMetaDataPattern(string), StringUtils.escapeMetaDataPattern(string3), null);
            int n2 = 0;
            while (resultSet.next()) {
                this.columnTypes[n2] = resultSet.getInt("DATA_TYPE");
                ++n2;
            }
            if (arrayList.isEmpty()) {
                resultSet = databaseMetaData.getPrimaryKeys(null, StringUtils.escapeMetaDataPattern(string), string3);
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString("COLUMN_NAME"));
                }
            }
            if (arrayList.isEmpty()) {
                throw FullText.throwException("No primary key for table " + string3);
            }
            ArrayList<String> arrayList3 = New.arrayList();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT ID, COLUMNS FROM FT.INDEXES WHERE SCHEMA=? AND TABLE=?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string3);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                this.index.id = resultSet.getInt(1);
                String string4 = resultSet.getString(2);
                if (string4 != null) {
                    Collections.addAll(arrayList3, StringUtils.arraySplit(string4, ',', true));
                }
            }
            if (arrayList3.isEmpty()) {
                arrayList3.addAll(arrayList2);
            }
            this.index.keys = new int[arrayList.size()];
            FullText.setColumns(this.index.keys, arrayList, arrayList2);
            this.index.indexColumns = new int[arrayList3.size()];
            FullText.setColumns(this.index.indexColumns, arrayList3, arrayList2);
            this.setting.addIndexInfo(this.index);
            this.useOwnConnection = FullTextTrigger.isMultiThread(connection);
            if (!this.useOwnConnection) {
                for (int i = 0; i < SQL.length; ++i) {
                    this.prepStatements[i] = connection.prepareStatement(SQL[i], 1);
                }
            }
        }

        static boolean isMultiThread(Connection connection) throws SQLException {
            try (Statement statement = connection.createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT value FROM information_schema.settings WHERE name = 'MULTI_THREADED'");
                boolean bl = resultSet.next() && !"0".equals(resultSet.getString(1));
                return bl;
            }
        }

        @Override
        public void fire(Connection connection, Object[] objectArray, Object[] objectArray2) throws SQLException {
            if (objectArray != null) {
                if (objectArray2 != null) {
                    if (FullText.hasChanged(objectArray, objectArray2, this.index.indexColumns)) {
                        this.delete(connection, objectArray);
                        this.insert(connection, objectArray2);
                    }
                } else {
                    this.delete(connection, objectArray);
                }
            } else if (objectArray2 != null) {
                this.insert(connection, objectArray2);
            }
        }

        @Override
        public void close() {
            this.setting.removeIndexInfo(this.index);
        }

        @Override
        public void remove() {
            this.setting.removeIndexInfo(this.index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void insert(Connection connection, Object[] objectArray) throws SQLException {
            PreparedStatement preparedStatement = null;
            PreparedStatement preparedStatement2 = null;
            try {
                int[] nArray;
                String string = this.getKey(objectArray);
                int n = string.hashCode();
                preparedStatement = this.getStatement(connection, 1);
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, this.index.id);
                preparedStatement.setString(3, string);
                preparedStatement.execute();
                ResultSet resultSet = preparedStatement.getGeneratedKeys();
                resultSet.next();
                int n2 = resultSet.getInt(1);
                preparedStatement2 = this.getStatement(connection, 2);
                preparedStatement2.setInt(1, n2);
                for (int n3 : nArray = this.getWordIds(connection, objectArray)) {
                    preparedStatement2.setInt(2, n3);
                    preparedStatement2.execute();
                }
                if (!this.useOwnConnection) return;
            }
            catch (Throwable throwable) {
                if (!this.useOwnConnection) throw throwable;
                IOUtils.closeSilently(preparedStatement);
                IOUtils.closeSilently(preparedStatement2);
                throw throwable;
            }
            IOUtils.closeSilently(preparedStatement);
            IOUtils.closeSilently(preparedStatement2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void delete(Connection connection, Object[] objectArray) throws SQLException {
            PreparedStatement preparedStatement = null;
            PreparedStatement preparedStatement2 = null;
            PreparedStatement preparedStatement3 = null;
            try {
                String string = this.getKey(objectArray);
                int n = string.hashCode();
                preparedStatement = this.getStatement(connection, 5);
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, this.index.id);
                preparedStatement.setString(3, string);
                ResultSet resultSet = preparedStatement.executeQuery();
                preparedStatement2 = this.getStatement(connection, 4);
                preparedStatement3 = this.getStatement(connection, 3);
                if (resultSet.next()) {
                    int[] nArray;
                    int n2 = resultSet.getInt(1);
                    preparedStatement2.setInt(1, n2);
                    for (int n3 : nArray = this.getWordIds(connection, objectArray)) {
                        preparedStatement2.setInt(2, n3);
                        preparedStatement2.executeUpdate();
                    }
                    preparedStatement3.setInt(1, n);
                    preparedStatement3.setInt(2, this.index.id);
                    preparedStatement3.setString(3, string);
                    preparedStatement3.executeUpdate();
                }
                if (!this.useOwnConnection) return;
            }
            catch (Throwable throwable) {
                if (!this.useOwnConnection) throw throwable;
                IOUtils.closeSilently(preparedStatement);
                IOUtils.closeSilently(preparedStatement2);
                IOUtils.closeSilently(preparedStatement3);
                throw throwable;
            }
            IOUtils.closeSilently(preparedStatement);
            IOUtils.closeSilently(preparedStatement2);
            IOUtils.closeSilently(preparedStatement3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int[] getWordIds(Connection connection, Object[] objectArray) throws SQLException {
            Object object;
            HashSet<String> hashSet = new HashSet<String>();
            for (int n : this.index.indexColumns) {
                int n2 = this.columnTypes[n];
                Object object2 = objectArray[n];
                if (n2 == 2005 && object2 != null) {
                    object = object2 instanceof Reader ? (Reader)object2 : ((Clob)object2).getCharacterStream();
                    FullText.addWords(this.setting, hashSet, (Reader)object);
                    continue;
                }
                object = FullText.asString(object2, n2);
                FullText.addWords(this.setting, hashSet, (String)object);
            }
            Object object3 = null;
            try {
                object3 = this.getStatement(connection, 0);
                int[] nArray = new int[hashSet.size()];
                int n = 0;
                for (String string : hashSet) {
                    while ((object = this.setting.getWordId(string)) == null) {
                        int n3;
                        object3.setString(1, string);
                        object3.execute();
                        ResultSet resultSet = object3.getGeneratedKeys();
                        if (!resultSet.next() || (n3 = resultSet.getInt(1)) == 0) continue;
                        this.setting.addWord(string, n3);
                        object = n3;
                        break;
                    }
                    nArray[n++] = (Integer)object;
                }
                Arrays.sort(nArray);
                Object object4 = nArray;
                return object4;
            }
            finally {
                if (this.useOwnConnection) {
                    IOUtils.closeSilently((AutoCloseable)object3);
                }
            }
        }

        private String getKey(Object[] objectArray) throws SQLException {
            StatementBuilder statementBuilder = new StatementBuilder();
            for (int n : this.index.keys) {
                statementBuilder.appendExceptFirst(" AND ");
                statementBuilder.append(StringUtils.quoteIdentifier(this.index.columns[n]));
                Object object = objectArray[n];
                if (object == null) {
                    statementBuilder.append(" IS NULL");
                    continue;
                }
                statementBuilder.append('=').append(FullText.quoteSQL(object, this.columnTypes[n]));
            }
            return statementBuilder.toString();
        }

        private PreparedStatement getStatement(Connection connection, int n) throws SQLException {
            return this.useOwnConnection ? connection.prepareStatement(SQL[n], 1) : this.prepStatements[n];
        }
    }
}

