/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.expression;

import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.expression.AggregateData;
import com.alibaba.schedulerx.shade.org.h2.util.ValueHashMap;
import com.alibaba.schedulerx.shade.org.h2.value.CompareMode;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueArray;
import com.alibaba.schedulerx.shade.org.h2.value.ValueLong;
import java.util.Arrays;
import java.util.Comparator;

class AggregateDataHistogram
extends AggregateData {
    private long count;
    private ValueHashMap<AggregateDataHistogram> distinctValues;

    AggregateDataHistogram() {
    }

    @Override
    void add(Database database, int n, boolean bl, Value value) {
        AggregateDataHistogram aggregateDataHistogram;
        if (this.distinctValues == null) {
            this.distinctValues = ValueHashMap.newInstance();
        }
        if ((aggregateDataHistogram = this.distinctValues.get(value)) == null && this.distinctValues.size() < 10000) {
            aggregateDataHistogram = new AggregateDataHistogram();
            this.distinctValues.put(value, aggregateDataHistogram);
        }
        if (aggregateDataHistogram != null) {
            ++aggregateDataHistogram.count;
        }
    }

    @Override
    Value getValue(Database database, int n, boolean bl) {
        Value value2;
        if (bl) {
            this.count = 0L;
            this.groupDistinct(database, n);
        }
        Value[] valueArray = new ValueArray[this.distinctValues.size()];
        int n2 = 0;
        for (Value value2 : this.distinctValues.keys()) {
            AggregateDataHistogram aggregateDataHistogram = this.distinctValues.get(value2);
            valueArray[n2] = ValueArray.get(new Value[]{value2, ValueLong.get(aggregateDataHistogram.count)});
            ++n2;
        }
        final CompareMode compareMode = database.getCompareMode();
        Arrays.sort(valueArray, new Comparator<ValueArray>(){

            @Override
            public int compare(ValueArray valueArray, ValueArray valueArray2) {
                Value value = valueArray.getList()[0];
                Value value2 = valueArray2.getList()[0];
                return value.compareTo(value2, compareMode);
            }
        });
        value2 = ValueArray.get(valueArray);
        return value2.convertTo(n);
    }

    private void groupDistinct(Database database, int n) {
        if (this.distinctValues == null) {
            return;
        }
        this.count = 0L;
        for (Value value : this.distinctValues.keys()) {
            this.add(database, n, false, value);
        }
    }
}

