/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.dml;

import com.alibaba.schedulerx.shade.org.h2.command.Prepared;
import com.alibaba.schedulerx.shade.org.h2.command.dml.Delete;
import com.alibaba.schedulerx.shade.org.h2.command.dml.Insert;
import com.alibaba.schedulerx.shade.org.h2.command.dml.Merge;
import com.alibaba.schedulerx.shade.org.h2.command.dml.Query;
import com.alibaba.schedulerx.shade.org.h2.command.dml.Select;
import com.alibaba.schedulerx.shade.org.h2.command.dml.Update;
import com.alibaba.schedulerx.shade.org.h2.expression.ConditionAndOr;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.result.ResultInterface;
import com.alibaba.schedulerx.shade.org.h2.result.Row;
import com.alibaba.schedulerx.shade.org.h2.result.RowImpl;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class MergeUsing
extends Prepared {
    private Table targetTable;
    private TableFilter targetTableFilter;
    private Column[] columns;
    private Column[] keys;
    private final ArrayList<Expression[]> valuesExpressionList = New.arrayList();
    private Query query;
    private TableFilter sourceTableFilter;
    private Expression onCondition;
    private Update updateCommand;
    private Delete deleteCommand;
    private Insert insertCommand;
    private String queryAlias;
    private int countUpdatedRows;
    private Column[] sourceKeys;
    private Select targetMatchQuery;
    private final HashMap<Value, Integer> targetRowidsRemembered = new HashMap();
    private int sourceQueryRowNumber;

    public MergeUsing(Merge merge) {
        super(merge.getSession());
        this.targetTable = merge.getTargetTable();
        this.targetTableFilter = merge.getTargetTableFilter();
    }

    @Override
    public int update() {
        this.targetRowidsRemembered.clear();
        if (this.targetTableFilter != null) {
            this.targetTableFilter.startQuery(this.session);
            this.targetTableFilter.reset();
        }
        if (this.sourceTableFilter != null) {
            this.sourceTableFilter.startQuery(this.session);
            this.sourceTableFilter.reset();
        }
        this.sourceQueryRowNumber = 0;
        this.checkRights();
        this.setCurrentRowNumber(0);
        ResultInterface resultInterface = this.query.query(0);
        this.targetTable.fire(this.session, this.evaluateTriggerMasks(), true);
        this.targetTable.lock(this.session, true, false);
        while (resultInterface.next()) {
            ++this.sourceQueryRowNumber;
            Value[] valueArray = resultInterface.currentRow();
            RowImpl rowImpl = new RowImpl(valueArray, 0);
            this.setCurrentRowNumber(this.sourceQueryRowNumber);
            this.merge(rowImpl);
        }
        resultInterface.close();
        this.targetTable.fire(this.session, this.evaluateTriggerMasks(), false);
        return this.countUpdatedRows;
    }

    private int evaluateTriggerMasks() {
        int n = 0;
        if (this.insertCommand != null) {
            n |= 1;
        }
        if (this.updateCommand != null) {
            n |= 2;
        }
        if (this.deleteCommand != null) {
            n |= 4;
        }
        return n;
    }

    private void checkRights() {
        if (this.insertCommand != null) {
            this.session.getUser().checkRight(this.targetTable, 4);
        }
        if (this.updateCommand != null) {
            this.session.getUser().checkRight(this.targetTable, 8);
        }
        if (this.deleteCommand != null) {
            this.session.getUser().checkRight(this.targetTable, 2);
        }
        this.session.getUser().checkRight(this.targetTable, 1);
        this.session.getUser().checkRight(this.sourceTableFilter.getTable(), 1);
    }

    protected void merge(Row row) {
        this.sourceTableFilter.set(row);
        boolean bl = this.isTargetRowFound();
        int n = 0;
        if (bl) {
            if (this.updateCommand != null) {
                n += this.updateCommand.update();
            }
            if (this.deleteCommand != null) {
                int n2 = this.deleteCommand.update();
                if (n == 1 && n2 == 1) {
                    this.countUpdatedRows += n2;
                    n2 = 0;
                } else {
                    n += n2;
                }
            }
        } else if (n == 0) {
            n += this.addRowByCommandInsert(row);
        } else if (n != 1) {
            throw DbException.get(23505, "Duplicate key inserted " + n + " rows at once, only 1 expected:" + this.targetTable.getSQL());
        }
        this.countUpdatedRows += n;
    }

    private boolean isTargetRowFound() {
        ResultInterface resultInterface = this.targetMatchQuery.query(0);
        int n = 0;
        Value[] valueArray = null;
        while (resultInterface.next()) {
            ++n;
            valueArray = resultInterface.currentRow();
            if (this.targetRowidsRemembered.containsKey(valueArray[0])) {
                throw DbException.get(23505, "Merge using ON column expression, duplicate _ROWID_ target record already updated, deleted or inserted:_ROWID_=" + valueArray[0].toString() + ":in:" + this.targetTableFilter.getTable() + ":conflicting source row number:" + this.targetRowidsRemembered.get(valueArray[0]));
            }
            this.targetRowidsRemembered.put(valueArray[0], this.sourceQueryRowNumber);
        }
        resultInterface.close();
        if (n > 1) {
            throw DbException.get(23505, "Duplicate key updated " + n + " rows at once, only 1 expected:_ROWID_=" + valueArray[0].toString() + ":in:" + this.targetTableFilter.getTable() + ":conflicting source row number:" + this.targetRowidsRemembered.get(valueArray[0]));
        }
        return n > 0;
    }

    private int addRowByCommandInsert(Row row) {
        int n = 0;
        if (this.insertCommand != null) {
            n += this.insertCommand.update();
            if (!this.isTargetRowFound()) {
                throw DbException.get(50000, "Expected to find key after row inserted, but none found. Insert does not match ON condition.:" + this.targetTable.getSQL() + ":source row=" + Arrays.asList(row.getValueList()));
            }
        }
        return n;
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("MERGE INTO ");
        statementBuilder.append(this.targetTable.getSQL()).append('(');
        for (Column expressionArray : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expressionArray.getSQL());
        }
        statementBuilder.append(')');
        if (this.keys != null) {
            statementBuilder.append(" KEY(");
            statementBuilder.resetCount();
            for (Column column : this.keys) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(column.getSQL());
            }
            statementBuilder.append(')');
        }
        statementBuilder.append('\n');
        if (!this.valuesExpressionList.isEmpty()) {
            statementBuilder.append("VALUES ");
            int n = 0;
            for (Expression[] expressionArray : this.valuesExpressionList) {
                if (n++ > 0) {
                    statementBuilder.append(", ");
                }
                statementBuilder.append('(');
                statementBuilder.resetCount();
                for (Expression expression : expressionArray) {
                    statementBuilder.appendExceptFirst(", ");
                    if (expression == null) {
                        statementBuilder.append("DEFAULT");
                        continue;
                    }
                    statementBuilder.append(expression.getSQL());
                }
                statementBuilder.append(')');
            }
        } else {
            statementBuilder.append(this.query.getPlanSQL());
        }
        return statementBuilder.toString();
    }

    @Override
    public void prepare() {
        Object object2;
        this.onCondition.addFilterConditions(this.sourceTableFilter, true);
        this.onCondition.addFilterConditions(this.targetTableFilter, true);
        this.onCondition.mapColumns(this.sourceTableFilter, 2);
        this.onCondition.mapColumns(this.targetTableFilter, 1);
        if (this.keys == null) {
            object2 = this.buildColumnListFromOnCondition(this.targetTableFilter);
            this.keys = ((HashSet)object2).toArray(new Column[0]);
        }
        if (this.keys.length == 0) {
            throw DbException.get(42122, "No references to target columns found in ON clause:" + this.targetTableFilter.toString());
        }
        if (this.sourceKeys == null) {
            object2 = this.buildColumnListFromOnCondition(this.sourceTableFilter);
            this.sourceKeys = ((HashSet)object2).toArray(new Column[0]);
        }
        if (this.sourceKeys.length == 0) {
            throw DbException.get(42122, "No references to source columns found in ON clause:" + this.sourceTableFilter.toString());
        }
        this.onCondition = this.onCondition.optimize(this.session);
        this.onCondition.createIndexConditions(this.session, this.sourceTableFilter);
        this.onCondition.createIndexConditions(this.session, this.targetTableFilter);
        if (this.columns == null) {
            this.columns = !this.valuesExpressionList.isEmpty() && this.valuesExpressionList.get(0).length == 0 ? new Column[0] : this.targetTable.getColumns();
        }
        if (!this.valuesExpressionList.isEmpty()) {
            for (Expression[] object3 : this.valuesExpressionList) {
                if (object3.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                for (int i = 0; i < object3.length; ++i) {
                    Expression expression = object3[i];
                    if (expression == null) continue;
                    object3[i] = expression.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
        int n = 0;
        if (this.updateCommand != null) {
            this.updateCommand.setSourceTableFilter(this.sourceTableFilter);
            this.updateCommand.setCondition(this.appendOnCondition(this.updateCommand));
            this.updateCommand.prepare();
            ++n;
        }
        if (this.deleteCommand != null) {
            this.deleteCommand.setSourceTableFilter(this.sourceTableFilter);
            this.deleteCommand.setCondition(this.appendOnCondition(this.deleteCommand));
            this.deleteCommand.prepare();
            ++n;
        }
        if (this.insertCommand != null) {
            this.insertCommand.setSourceTableFilter(this.sourceTableFilter);
            this.insertCommand.prepare();
            ++n;
        }
        if (n == 0) {
            throw DbException.get(42000, "At least UPDATE, DELETE or INSERT embedded statement must be supplied.");
        }
        Expression expression = this.targetMatchQuery.getCondition();
        expression.addFilterConditions(this.sourceTableFilter, true);
        expression.mapColumns(this.sourceTableFilter, 2);
        Expression expression2 = expression.optimize(this.session);
        expression2.createIndexConditions(this.session, this.sourceTableFilter);
        this.targetMatchQuery.prepare();
    }

    private HashSet<Column> buildColumnListFromOnCondition(TableFilter tableFilter) {
        HashSet<Column> hashSet = new HashSet<Column>();
        HashSet<Column> hashSet2 = new HashSet<Column>();
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getColumnsVisitor(hashSet2);
        this.onCondition.isEverything(expressionVisitor);
        for (Column column : hashSet2) {
            if (column == null || column.getTable() != tableFilter.getTable()) continue;
            hashSet.add(column);
        }
        return hashSet;
    }

    private Expression appendOnCondition(Update update) {
        if (update.getCondition() == null) {
            return this.onCondition;
        }
        return new ConditionAndOr(0, update.getCondition(), this.onCondition);
    }

    private Expression appendOnCondition(Delete delete) {
        if (delete.getCondition() == null) {
            return this.onCondition;
        }
        return new ConditionAndOr(0, delete.getCondition(), this.onCondition);
    }

    public void setSourceTableFilter(TableFilter tableFilter) {
        this.sourceTableFilter = tableFilter;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }

    public void setOnCondition(Expression expression) {
        this.onCondition = expression;
    }

    public Expression getOnCondition() {
        return this.onCondition;
    }

    public Prepared getUpdateCommand() {
        return this.updateCommand;
    }

    public void setUpdateCommand(Update update) {
        this.updateCommand = update;
    }

    public Prepared getDeleteCommand() {
        return this.deleteCommand;
    }

    public void setDeleteCommand(Delete delete) {
        this.deleteCommand = delete;
    }

    public Insert getInsertCommand() {
        return this.insertCommand;
    }

    public void setInsertCommand(Insert insert) {
        this.insertCommand = insert;
    }

    public void setQueryAlias(String string) {
        this.queryAlias = string;
    }

    public String getQueryAlias() {
        return this.queryAlias;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void setTargetTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
    }

    public TableFilter getTargetTableFilter() {
        return this.targetTableFilter;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(Table table) {
        this.targetTable = table;
    }

    public Select getTargetMatchQuery() {
        return this.targetMatchQuery;
    }

    public void setTargetMatchQuery(Select select) {
        this.targetMatchQuery = select;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 62;
    }
}

