/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.ddl;

import com.alibaba.schedulerx.shade.org.h2.command.ddl.DefineCommand;
import com.alibaba.schedulerx.shade.org.h2.constraint.ConstraintActionType;
import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.schema.Schema;
import com.alibaba.schedulerx.shade.org.h2.schema.SchemaObject;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;

public class DropSchema
extends DefineCommand {
    private String schemaName;
    private boolean ifExists;
    private ConstraintActionType dropAction;

    public DropSchema(Session session) {
        super(session);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    @Override
    public int update() {
        this.session.getUser().checkSchemaAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Schema schema = database.findSchema(this.schemaName);
        if (schema == null) {
            if (!this.ifExists) {
                throw DbException.get(90079, this.schemaName);
            }
        } else {
            if (!schema.canDrop()) {
                throw DbException.get(90090, this.schemaName);
            }
            if (this.dropAction == ConstraintActionType.RESTRICT && !schema.isEmpty()) {
                StatementBuilder statementBuilder = new StatementBuilder();
                for (SchemaObject schemaObject : schema.getAll()) {
                    statementBuilder.appendExceptFirst(", ");
                    statementBuilder.append(schemaObject.getName());
                }
                if (statementBuilder.length() > 0) {
                    throw DbException.get(90107, this.schemaName, statementBuilder.toString());
                }
            }
            database.removeDatabaseObject(this.session, schema);
        }
        return 0;
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setDropAction(ConstraintActionType constraintActionType) {
        this.dropAction = constraintActionType;
    }

    @Override
    public int getType() {
        return 42;
    }
}

