/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.nio.protocol;

import com.alibaba.schedulerx.shade.org.apache.http.ContentTooLongException;
import com.alibaba.schedulerx.shade.org.apache.http.HttpEntity;
import com.alibaba.schedulerx.shade.org.apache.http.HttpResponse;
import com.alibaba.schedulerx.shade.org.apache.http.annotation.ThreadSafe;
import com.alibaba.schedulerx.shade.org.apache.http.entity.ContentType;
import com.alibaba.schedulerx.shade.org.apache.http.nio.ContentDecoder;
import com.alibaba.schedulerx.shade.org.apache.http.nio.IOControl;
import com.alibaba.schedulerx.shade.org.apache.http.nio.entity.ContentBufferEntity;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.util.HeapByteBufferAllocator;
import com.alibaba.schedulerx.shade.org.apache.http.nio.util.SimpleInputBuffer;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.HttpContext;
import com.alibaba.schedulerx.shade.org.apache.http.util.Asserts;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private volatile HttpResponse response;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onResponseReceived(HttpResponse response) throws IOException {
        this.response = response;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, new HeapByteBufferAllocator());
        this.response.setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.response = null;
        this.buf = null;
    }

    @Override
    protected HttpResponse buildResult(HttpContext context) {
        return this.response;
    }
}

