/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.zaxxer.hikari;

import com.alibaba.schedulerx.shade.com.zaxxer.hikari.HikariConfig;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.HikariConfigMBean;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.IConnectionCustomizer;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.util.PropertyBeanSetter;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.util.UtilityElf;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHikariConfig
implements HikariConfigMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariConfig.class);
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private static final long VALIDATION_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final long IDLE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private static final long MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
    private static int poolNumber;
    private static boolean unitTest;
    private volatile long connectionTimeout;
    private volatile long validationTimeout;
    private volatile long idleTimeout;
    private volatile long leakDetectionThreshold;
    private volatile long maxLifetime;
    private volatile int maxPoolSize = 10;
    private volatile int minIdle = -1;
    private String catalog;
    private String connectionCustomizerClassName;
    private String connectionInitSql;
    private String connectionTestQuery;
    private String dataSourceClassName;
    private String dataSourceJndiName;
    private String driverClassName;
    private String jdbcUrl;
    private String password;
    private String poolName;
    private String transactionIsolationName;
    private String username;
    private boolean isAutoCommit = true;
    private boolean isReadOnly;
    private boolean isInitializationFailFast = true;
    private boolean isIsolateInternalQueries;
    private boolean isRegisterMbeans;
    private boolean isAllowPoolSuspension;
    private DataSource dataSource;
    private Properties dataSourceProperties = new Properties();
    private IConnectionCustomizer customizer;
    private ThreadFactory threadFactory;
    private Object metricRegistry;
    private Object healthCheckRegistry;
    private Properties healthCheckProperties = new Properties();

    public AbstractHikariConfig() {
        this.connectionTimeout = CONNECTION_TIMEOUT;
        this.validationTimeout = VALIDATION_TIMEOUT;
        this.idleTimeout = IDLE_TIMEOUT;
        this.maxLifetime = MAX_LIFETIME;
        this.customizer = new IConnectionCustomizer(){

            @Override
            public void customize(Connection connection) throws SQLException {
            }
        };
        String systemProp = System.getProperty("hikaricp.configurationFile");
        if (systemProp != null) {
            this.loadProperties(systemProp);
        }
    }

    public AbstractHikariConfig(Properties properties) {
        this();
        PropertyBeanSetter.setTargetFromProperties(this, properties);
    }

    public AbstractHikariConfig(String propertyFileName) {
        this();
        this.loadProperties(propertyFileName);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    @Deprecated
    public String getConnectionCustomizerClassName() {
        return this.connectionCustomizerClassName;
    }

    @Deprecated
    public void setConnectionCustomizerClassName(String connectionCustomizerClassName) {
        this.connectionCustomizerClassName = connectionCustomizerClassName;
        LOGGER.warn("The connectionCustomizerClassName property has been deprecated and may be removed in a future release");
    }

    @Deprecated
    public IConnectionCustomizer getConnectionCustomizer() {
        return this.customizer;
    }

    @Deprecated
    public void setConnectionCustomizer(IConnectionCustomizer customizer) {
        this.customizer = customizer;
        LOGGER.warn("The connectionCustomizer property has been deprecated and may be removed in a future release");
    }

    public String getConnectionTestQuery() {
        return this.connectionTestQuery;
    }

    public void setConnectionTestQuery(String connectionTestQuery) {
        this.connectionTestQuery = connectionTestQuery;
    }

    public String getConnectionInitSql() {
        return this.connectionInitSql;
    }

    public void setConnectionInitSql(String connectionInitSql) {
        this.connectionInitSql = connectionInitSql;
    }

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(long connectionTimeoutMs) {
        if (connectionTimeoutMs == 0L) {
            this.connectionTimeout = Integer.MAX_VALUE;
        } else {
            if (connectionTimeoutMs < 1000L) {
                throw new IllegalArgumentException("connectionTimeout cannot be less than 1000ms");
            }
            this.connectionTimeout = connectionTimeoutMs;
        }
    }

    @Override
    public long getValidationTimeout() {
        return this.validationTimeout;
    }

    @Override
    public void setValidationTimeout(long validationTimeoutMs) {
        if (validationTimeoutMs < 1000L) {
            throw new IllegalArgumentException("validationTimeout cannot be less than 1000ms");
        }
        this.validationTimeout = validationTimeoutMs;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public void setDataSourceClassName(String className) {
        this.dataSourceClassName = className;
    }

    public void addDataSourceProperty(String propertyName, Object value) {
        this.dataSourceProperties.put(propertyName, value);
    }

    public String getDataSourceJNDI() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJNDI(String jndiDataSource) {
        this.dataSourceJndiName = jndiDataSource;
    }

    public Properties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public void setDataSourceProperties(Properties dsProperties) {
        this.dataSourceProperties.putAll((Map<?, ?>)dsProperties);
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        try {
            Class<?> driverClass = this.getClass().getClassLoader().loadClass(driverClassName);
            driverClass.newInstance();
            this.driverClassName = driverClassName;
        }
        catch (Exception e) {
            throw new RuntimeException("driverClassName specified class '" + driverClassName + "' could not be loaded", e);
        }
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleTimeout(long idleTimeoutMs) {
        if (idleTimeoutMs < 0L) {
            throw new IllegalArgumentException("idleTimeout cannot be negative");
        }
        this.idleTimeout = idleTimeoutMs;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    public void setAutoCommit(boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    public boolean isAllowPoolSuspension() {
        return this.isAllowPoolSuspension;
    }

    public void setAllowPoolSuspension(boolean isAllowPoolSuspension) {
        this.isAllowPoolSuspension = isAllowPoolSuspension;
    }

    public boolean isInitializationFailFast() {
        return this.isInitializationFailFast;
    }

    public void setInitializationFailFast(boolean failFast) {
        this.isInitializationFailFast = failFast;
    }

    public boolean isIsolateInternalQueries() {
        return this.isIsolateInternalQueries;
    }

    public void setIsolateInternalQueries(boolean isolate) {
        this.isIsolateInternalQueries = isolate;
    }

    @Deprecated
    public boolean isJdbc4ConnectionTest() {
        return false;
    }

    @Deprecated
    public void setJdbc4ConnectionTest(boolean useIsValid) {
        LOGGER.warn("The jdbcConnectionTest property is now deprecated, see the documentation for connectionTestQuery");
    }

    public Object getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(Object metricRegistry) {
        if (metricRegistry != null) {
            if (metricRegistry instanceof String) {
                try {
                    InitialContext initCtx = new InitialContext();
                    metricRegistry = (MetricRegistry)initCtx.lookup((String)metricRegistry);
                }
                catch (NamingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (!(metricRegistry instanceof MetricRegistry)) {
                throw new IllegalArgumentException("Class must be an instance of com.codahale.metrics.MetricRegistry");
            }
        }
        this.metricRegistry = metricRegistry;
    }

    public Object getHealthCheckRegistry() {
        return this.healthCheckRegistry;
    }

    public void setHealthCheckRegistry(Object healthCheckRegistry) {
        if (healthCheckRegistry != null) {
            if (healthCheckRegistry instanceof String) {
                try {
                    InitialContext initCtx = new InitialContext();
                    healthCheckRegistry = (HealthCheckRegistry)initCtx.lookup((String)healthCheckRegistry);
                }
                catch (NamingException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (!(healthCheckRegistry instanceof HealthCheckRegistry)) {
                throw new IllegalArgumentException("Class must be an instance of com.codahale.metrics.health.HealthCheckRegistry");
            }
        }
        this.healthCheckRegistry = healthCheckRegistry;
    }

    public Properties getHealthCheckProperties() {
        return this.healthCheckProperties;
    }

    public void setHealthCheckProperties(Properties healthCheckProperties) {
        this.healthCheckProperties.putAll((Map<?, ?>)healthCheckProperties);
    }

    public void addHealthCheckProperty(String key, String value) {
        this.healthCheckProperties.setProperty(key, value);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    public boolean isRegisterMbeans() {
        return this.isRegisterMbeans;
    }

    public void setRegisterMbeans(boolean register) {
        this.isRegisterMbeans = register;
    }

    @Override
    public long getLeakDetectionThreshold() {
        return this.leakDetectionThreshold;
    }

    @Override
    public void setLeakDetectionThreshold(long leakDetectionThresholdMs) {
        this.leakDetectionThreshold = leakDetectionThresholdMs;
    }

    @Override
    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public void setMaxLifetime(long maxLifetimeMs) {
        this.maxLifetime = maxLifetimeMs;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaximumPoolSize(int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolSize cannot be less than 1");
        }
        this.maxPoolSize = maxPoolSize;
    }

    @Override
    public int getMinimumIdle() {
        return this.minIdle;
    }

    @Override
    public void setMinimumIdle(int minIdle) {
        if (minIdle < 0) {
            throw new IllegalArgumentException("minimumIdle cannot be negative");
        }
        this.minIdle = minIdle;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getTransactionIsolation() {
        return this.transactionIsolationName;
    }

    public void setTransactionIsolation(String isolationLevel) {
        this.transactionIsolationName = isolationLevel;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public void validate() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        this.validateNumerics();
        if (this.connectionCustomizerClassName != null) {
            try {
                this.getClass().getClassLoader().loadClass(this.connectionCustomizerClassName);
            }
            catch (Exception e) {
                logger.warn("connectionCustomizationClass specified class '" + this.connectionCustomizerClassName + "' could not be loaded", (Throwable)e);
                this.connectionCustomizerClassName = null;
            }
        }
        if (this.driverClassName != null && this.jdbcUrl == null) {
            logger.error("when specifying driverClassName, jdbcUrl must also be specified");
            throw new IllegalStateException("when specifying driverClassName, jdbcUrl must also be specified");
        }
        if (this.driverClassName != null && this.dataSourceClassName != null) {
            logger.error("both driverClassName and dataSourceClassName are specified, one or the other should be used");
            throw new IllegalStateException("both driverClassName and dataSourceClassName are specified, one or the other should be used");
        }
        if (this.jdbcUrl == null) {
            if (this.dataSource == null && this.dataSourceClassName == null) {
                logger.error("one of either dataSource, dataSourceClassName, or jdbcUrl and driverClassName must be specified");
                throw new IllegalArgumentException("one of either dataSource or dataSourceClassName must be specified");
            }
            if (this.dataSource != null && this.dataSourceClassName != null) {
                logger.warn("both dataSource and dataSourceClassName are specified, ignoring dataSourceClassName");
            }
        }
        if (this.transactionIsolationName != null) {
            UtilityElf.getTransactionIsolation(this.transactionIsolationName);
        }
        if (this.poolName == null) {
            this.poolName = "HikariPool-" + poolNumber++;
        }
        if (LOGGER.isDebugEnabled() || unitTest) {
            this.logConfiguration();
        }
    }

    private void validateNumerics() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        if (this.validationTimeout > this.connectionTimeout && this.connectionTimeout != 0L) {
            logger.warn("validationTimeout is greater than connectionTimeout, setting validationTimeout to connectionTimeout.");
            this.validationTimeout = this.connectionTimeout;
        }
        if (this.minIdle < 0 || this.minIdle > this.maxPoolSize) {
            this.minIdle = this.maxPoolSize;
        }
        if (this.maxLifetime < 0L) {
            logger.error("maxLifetime cannot be negative.");
            throw new IllegalArgumentException("maxLifetime cannot be negative.");
        }
        if (this.maxLifetime > 0L && this.maxLifetime < TimeUnit.SECONDS.toMillis(30L)) {
            logger.warn("maxLifetime is less than 30000ms, using default {}ms.", (Object)MAX_LIFETIME);
            this.maxLifetime = MAX_LIFETIME;
        }
        if (this.idleTimeout != 0L && this.idleTimeout < TimeUnit.SECONDS.toMillis(10L)) {
            logger.warn("idleTimeout is less than 10000ms, using default {}ms.", (Object)IDLE_TIMEOUT);
            this.idleTimeout = IDLE_TIMEOUT;
        } else if (this.idleTimeout > this.maxLifetime && this.maxLifetime > 0L) {
            logger.warn("idleTimeout is greater than maxLifetime, setting to maxLifetime.");
            this.idleTimeout = this.maxLifetime;
        }
        if (this.leakDetectionThreshold != 0L && this.leakDetectionThreshold < TimeUnit.SECONDS.toMillis(2L) && !unitTest) {
            logger.warn("leakDetectionThreshold is less than 2000ms, setting to minimum 2000ms.");
            this.leakDetectionThreshold = 2000L;
        }
    }

    private void logConfiguration() {
        LOGGER.debug("HikariCP pool {} configuration:", (Object)this.poolName);
        TreeSet<String> propertyNames = new TreeSet<String>(PropertyBeanSetter.getPropertyNames(HikariConfig.class));
        for (String prop : propertyNames) {
            try {
                Object value = PropertyBeanSetter.getProperty(prop, this);
                if ("dataSourceProperties".equals(prop)) {
                    Properties dsProps = PropertyBeanSetter.copyProperties(this.dataSourceProperties);
                    dsProps.setProperty("password", "<masked>");
                    value = dsProps;
                }
                value = prop.contains("password") ? "<masked>" : value;
                LOGGER.debug((prop + "................................................").substring(0, 32) + (value != null ? value : ""));
            }
            catch (Exception e) {}
        }
    }

    protected abstract void loadProperties(String var1);

    public void copyState(AbstractHikariConfig other) {
        for (Field field : AbstractHikariConfig.class.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                field.set(other, field.get(this));
            }
            catch (Exception e) {
                throw new RuntimeException("Exception copying HikariConfig state: " + e.getMessage(), e);
            }
        }
    }
}

