/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util;

import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.InetAddressValidator;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public final class NetworkUtils {
    private NetworkUtils() {
    }

    public static boolean isIPAddr(String str) {
        return InetAddressValidator.getInstance().isValid(str);
    }

    public static String getLocalMachineIP() {
        InetAddressValidator validator = InetAddressValidator.getInstance();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                if (!ni.isUp()) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    String ipAddress;
                    InetAddress address = addresses.nextElement();
                    if (address.isLinkLocalAddress() || address.getHostAddress() == null || (ipAddress = address.getHostAddress()).equals("127.0.0.1") || !validator.isValidInet4Address(ipAddress)) continue;
                    return ipAddress;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }
}

