/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.sample;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.Client;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Alert;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.AlertConfiguration;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Chart;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Dashboard;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.DingTalkNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.EmailNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.JobSchedule;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.JobScheduleType;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.JobState;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Notification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Query;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.TimeSpanType;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.CreateAlertRequest;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.CreateDashboardRequest;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.DisableAlertRequest;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.EnableAlertRequest;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.GetAlertRequest;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.ListAlertRequest;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.UpdateAlertRequest;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.GetAlertResponse;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.ListAlertResponse;
import com.alibaba.schedulerx.shade.net.sf.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class AlertSample {
    public static void main(String[] args) {
        String accessId = "";
        String accessKey = "";
        String project = "ali-cn-devcommon-sls-admin";
        String host = "cn-hangzhou-devcommon-intranet.sls.aliyuncs.com";
        String alertName = "test-alert";
        String dashboardName = "dashboardtest";
        String logstore = "logstore-test";
        Client client = new Client(host, accessId, accessKey);
        try {
            Chart chart;
            block6: {
                Dashboard dashboard = new Dashboard();
                dashboard.setDashboardName(dashboardName);
                dashboard.setDescription("Dashboard");
                chart = new Chart();
                chart.setDisplayName("chart-test");
                chart.setQuery("* | select count(1) as count");
                chart.setLogstore(logstore);
                chart.setTitle("chart-1234567");
                chart.setType("table");
                chart.setTopic("");
                chart.setHeight(5L);
                chart.setWidth(5L);
                chart.setStart("-360s");
                chart.setEnd("now");
                chart.setxPosition(0L);
                chart.setyPosition(-1L);
                JSONObject searchAttr = new JSONObject();
                searchAttr.put("logstore", logstore);
                searchAttr.put("start", chart.getStart());
                searchAttr.put("end", chart.getEnd());
                searchAttr.put("topic", "");
                searchAttr.put("query", chart.getQuery());
                searchAttr.put("timeSpanType", "custom");
                chart.setRawSearchAttr(searchAttr.toString());
                ArrayList<Chart> charts = new ArrayList<Chart>();
                charts.add(chart);
                dashboard.setChartList(charts);
                CreateDashboardRequest createDashboardRequest = new CreateDashboardRequest(project, dashboard);
                try {
                    client.createDashboard(createDashboardRequest);
                }
                catch (LogException ex) {
                    if (ex.GetErrorMessage().equals("specified dashboard already exists")) break block6;
                    throw ex;
                }
            }
            Alert alert = new Alert();
            alert.setName(alertName);
            alert.setState(JobState.ENABLED);
            alert.setDisplayName("count monitoring");
            AlertConfiguration configuration = new AlertConfiguration();
            configuration.setCondition("count > 1");
            configuration.setDashboard(dashboardName);
            ArrayList<Query> queries = new ArrayList<Query>();
            Query query = new Query();
            query.setStart("-360s");
            query.setEnd("now");
            query.setTimeSpanType(TimeSpanType.CUSTOM);
            query.setQuery(chart.getQuery());
            query.setLogStore(logstore);
            query.setChartTitle(chart.getTitle());
            queries.add(query);
            configuration.setQueryList(queries);
            EmailNotification notification = new EmailNotification();
            notification.setEmailList(Collections.singletonList("kel@test.com"));
            notification.setContent("Alerting");
            ArrayList<Notification> notifications = new ArrayList<Notification>();
            notifications.add(notification);
            DingTalkNotification dingTalkNotification = new DingTalkNotification();
            dingTalkNotification.setServiceUri("https://oapi.dingtalk.com/robot/send?access_token=xxx");
            dingTalkNotification.setContent("Ding talk message");
            notifications.add(dingTalkNotification);
            configuration.setNotificationList(notifications);
            configuration.setThrottling("0s");
            configuration.setNotifyThreshold(100);
            alert.setConfiguration(configuration);
            JobSchedule schedule = new JobSchedule();
            schedule.setType(JobScheduleType.FIXED_RATE);
            schedule.setInterval("60s");
            alert.setSchedule(schedule);
            client.createAlert(new CreateAlertRequest(project, alert));
            GetAlertResponse response = client.getAlert(new GetAlertRequest(project, alertName));
            Alert created = response.getAlert();
            System.out.println(created.getName());
            System.out.println(created.getDisplayName());
            System.out.println(created.getCreateTime());
            client.disableAlert(new DisableAlertRequest(project, alertName));
            response = client.getAlert(new GetAlertRequest(project, alertName));
            Alert alert1 = response.getAlert();
            System.out.println((Object)alert1.getState());
            client.enableAlert(new EnableAlertRequest(project, alertName));
            response = client.getAlert(new GetAlertRequest(project, alertName));
            Alert alert2 = response.getAlert();
            System.out.println((Object)alert2.getState());
            DisableAlertRequest disableAlertRequest = new DisableAlertRequest(project, alertName);
            client.disableJob(disableAlertRequest);
            response = client.getAlert(new GetAlertRequest(project, alertName));
            Alert alert3 = response.getAlert();
            System.out.println((Object)alert3.getState());
            JobSchedule schedule1 = alert3.getSchedule();
            System.out.println(schedule1.getInterval());
            System.out.println((Object)schedule1.getType());
            Date muteTo = new Date(System.currentTimeMillis() + 60000L);
            alert3.getConfiguration().setMuteUntil(muteTo);
            client.updateAlert(new UpdateAlertRequest(project, alert3));
            for (int i = 0; i < 10; ++i) {
                alert.setName("alert-" + i);
                client.createAlert(new CreateAlertRequest(project, alert));
            }
            ListAlertRequest listReq = new ListAlertRequest(project);
            listReq.setOffset(0);
            listReq.setSize(10);
            ListAlertResponse listJobsResponse = client.listAlert(listReq);
            System.out.println(listJobsResponse.getTotal());
            System.out.println(listJobsResponse.getCount());
            for (Alert alert4 : listJobsResponse.getResults()) {
                System.out.println(alert4.getName());
            }
        }
        catch (LogException lex) {
            lex.printStackTrace();
        }
    }
}

