/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LZ4Encoder;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.LogGroupData;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.response.Response;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.VarintUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BatchGetLogResponse
extends Response {
    private static final long serialVersionUID = 1682292008312952493L;
    protected List<LogGroupData> mLogGroups = new ArrayList<LogGroupData>();
    protected int mRawSize;

    public int GetRawSize() {
        return this.mRawSize;
    }

    public void ParseFastLogGroupList(byte[] uncompressedData) throws LogException {
        int pos = 0;
        int rawSize = uncompressedData.length;
        while (pos < rawSize) {
            int[] value = VarintUtil.DecodeVarInt32(uncompressedData, pos, rawSize);
            if (value[0] == 0) {
                throw new LogException("InitLogGroupsError", "decode varint32 error", this.GetRequestId());
            }
            pos = value[2];
            int mode = value[1] & 7;
            int index = value[1] >> 3;
            if (mode == 0) {
                value = VarintUtil.DecodeVarInt32(uncompressedData, pos, rawSize);
                if (value[0] == 0) {
                    throw new LogException("InitLogGroupsError", "decode varint32 error", this.GetRequestId());
                }
                pos = value[2];
                continue;
            }
            if (mode == 1) {
                pos += 8;
                continue;
            }
            if (mode == 2) {
                value = VarintUtil.DecodeVarInt32(uncompressedData, pos, rawSize);
                if (value[0] == 0) {
                    throw new LogException("InitLogGroupsError", "decode varint32 error", this.GetRequestId());
                }
                if (index == 1) {
                    this.mLogGroups.add(new LogGroupData(uncompressedData, value[2], value[1], this.GetRequestId()));
                }
                pos = value[1] + value[2];
                continue;
            }
            if (mode == 5) {
                pos += 4;
                continue;
            }
            throw new LogException("InitLogGroupsError", "mode: " + mode, this.GetRequestId());
        }
        if (pos != rawSize) {
            throw new LogException("InitLogGroupsError", "parse LogGroupList fail", this.GetRequestId());
        }
    }

    public BatchGetLogResponse(Map<String, String> headers) {
        super(headers);
    }

    public BatchGetLogResponse(Map<String, String> headers, byte[] rawData) throws LogException {
        super(headers);
        try {
            this.mRawSize = Integer.parseInt(headers.get("x-log-bodyrawsize"));
            if (this.mRawSize > 0) {
                byte[] uncompressedData = LZ4Encoder.decompressFromLhLz4Chunk(rawData, this.mRawSize);
                this.ParseFastLogGroupList(uncompressedData);
            }
        }
        catch (NumberFormatException e) {
            throw new LogException("ParseLogGroupListRawSizeError", e.getMessage(), e, this.GetRequestId());
        }
        if (this.mLogGroups.size() != this.GetCount()) {
            throw new LogException("LogGroupCountNotMatch", "Loggroup count does match with the count in header message", this.GetRequestId());
        }
    }

    public String GetNextCursor() {
        return this.GetHeader("x-log-cursor");
    }

    public int GetCount() {
        return Integer.parseInt(this.GetHeader("x-log-count"));
    }

    public LogGroupData GetLogGroup(int index) throws LogException {
        if (this.GetCount() <= 0) {
            throw new LogException("GetLogGroupError", "No LogGroups in response", this.GetRequestId());
        }
        if (index >= 0 && index < this.GetCount()) {
            return this.mLogGroups.get(index);
        }
        throw new LogException("GetLogGroupError", "Invalid index", this.GetRequestId());
    }

    public List<LogGroupData> GetLogGroups(int offset) throws LogException {
        if (this.GetCount() <= 0) {
            throw new LogException("GetLogGroupError", "No LogGroups in response", this.GetRequestId());
        }
        if (offset < 0 || offset >= this.GetCount()) {
            throw new LogException("GetLogGroupError", "Invalid offset", this.GetRequestId());
        }
        return this.mLogGroups.subList(offset, this.GetCount());
    }

    public List<LogGroupData> GetLogGroups() throws LogException {
        return this.mLogGroups;
    }
}

