/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.HttpMethod;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.RepeatableInputStreamEntity;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.ServiceClient;
import com.alibaba.schedulerx.shade.org.apache.http.client.HttpClient;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpDelete;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpGet;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpHead;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpOptions;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpPost;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpPut;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpRequestBase;
import com.alibaba.schedulerx.shade.org.apache.http.conn.scheme.Scheme;
import com.alibaba.schedulerx.shade.org.apache.http.conn.ssl.SSLSocketFactory;
import com.alibaba.schedulerx.shade.org.apache.http.impl.client.DefaultHttpClient;
import com.alibaba.schedulerx.shade.org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import com.alibaba.schedulerx.shade.org.apache.http.params.BasicHttpParams;
import com.alibaba.schedulerx.shade.org.apache.http.params.HttpConnectionParams;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

class HttpFactory {
    HttpFactory() {
    }

    public HttpClient createHttpClient(ClientConfiguration config) {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(httpParams, config.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout(httpParams, config.getSocketTimeout());
        HttpConnectionParams.setStaleCheckingEnabled(httpParams, true);
        HttpConnectionParams.setTcpNoDelay(httpParams, true);
        ThreadSafeClientConnManager connMgr = this.createThreadSafeClientConnManager(config);
        DefaultHttpClient httpClient = new DefaultHttpClient(connMgr, httpParams);
        if (System.getProperty("com.alibaba.schedulerx.shade.com.aliyun.openservices.disableCertChecking") != null) {
            Scheme sch = new Scheme("https", 443, HttpFactory.getSSLSocketFactory());
            httpClient.getConnectionManager().getSchemeRegistry().register(sch);
        }
        return httpClient;
    }

    private ThreadSafeClientConnManager createThreadSafeClientConnManager(ClientConfiguration clientConfig) {
        ThreadSafeClientConnManager connMgr = new ThreadSafeClientConnManager();
        connMgr.setDefaultMaxPerRoute(clientConfig.getMaxConnections());
        connMgr.setMaxTotal(clientConfig.getMaxConnections());
        return connMgr;
    }

    public HttpRequestBase createHttpRequest(ServiceClient.Request request, String charset) {
        HttpRequestBase httpRequest;
        String uri = request.getUri();
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(uri);
            if (request.getContent() != null) {
                postMethod.setEntity(new RepeatableInputStreamEntity(request));
            }
            httpRequest = postMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(uri);
            if (request.getContent() != null) {
                putMethod.setEntity(new RepeatableInputStreamEntity(request));
            }
            httpRequest = putMethod;
        } else if (method == HttpMethod.GET) {
            httpRequest = new HttpGet(uri);
        } else if (method == HttpMethod.DELETE) {
            httpRequest = new HttpDelete(uri);
        } else if (method == HttpMethod.HEAD) {
            httpRequest = new HttpHead(uri);
        } else if (method == HttpMethod.OPTIONS) {
            httpRequest = new HttpOptions(uri);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported HTTP method\uff1a%s.", request.getMethod().toString()));
        }
        this.configureRequestHeaders(request, charset, httpRequest);
        return httpRequest;
    }

    private void configureRequestHeaders(ServiceClient.Request request, String charset, HttpRequestBase httpRequest) {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        if (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0) {
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + charset.toLowerCase());
        }
    }

    private static SSLSocketFactory getSSLSocketFactory() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, trustAllCerts, null);
            SSLSocketFactory ssf = new SSLSocketFactory(sslcontext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return ssf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

