/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.HttpFactory;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.ResponseMessage;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.ServiceClient;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.utils.ExceptionFactory;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.utils.HttpUtil;
import com.alibaba.schedulerx.shade.org.apache.http.Header;
import com.alibaba.schedulerx.shade.org.apache.http.HttpResponse;
import com.alibaba.schedulerx.shade.org.apache.http.client.HttpClient;
import com.alibaba.schedulerx.shade.org.apache.http.client.methods.HttpRequestBase;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class DefaultServiceClient
extends ServiceClient {
    private HttpClient httpClient;

    public DefaultServiceClient(ClientConfiguration config) {
        super(config);
        this.httpClient = new HttpFactory().createHttpClient(config);
    }

    @Override
    public ResponseMessage sendRequestCore(ServiceClient.Request request, String charset) throws IOException {
        assert (request != null);
        this.httpClient.getConnectionManager().closeIdleConnections(30L, TimeUnit.SECONDS);
        HttpRequestBase httpRequest = new HttpFactory().createHttpRequest(request, charset);
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(httpRequest);
        }
        catch (IOException ex) {
            throw ExceptionFactory.createNetworkException(ex);
        }
        ResponseMessage result = new ResponseMessage();
        result.setUrl(request.getUri());
        if (response.getStatusLine() != null) {
            result.setStatusCode(response.getStatusLine().getStatusCode());
        }
        if (response.getEntity() != null) {
            result.setContent(response.getEntity().getContent());
        }
        Header[] headers = response.getAllHeaders();
        HashMap<String, String> resultHeaders = new HashMap<String, String>();
        for (int i = 0; i < headers.length; ++i) {
            Header h = headers[i];
            resultHeaders.put(h.getName(), h.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(resultHeaders);
        result.setHeaders(resultHeaders);
        return result;
    }
}

