/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Chart;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.net.sf.json.JSONArray;
import com.alibaba.schedulerx.shade.net.sf.json.JSONException;
import com.alibaba.schedulerx.shade.net.sf.json.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;

public class Dashboard
implements Serializable {
    private static final long serialVersionUID = 3152635375534266524L;
    private String dashboardName = "";
    private String description = "";
    private String displayName = "";
    private String attribute = "";
    private ArrayList<Chart> chartList = new ArrayList();

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDashboardName() {
        return this.dashboardName;
    }

    public void setDashboardName(String dashboardName) {
        this.dashboardName = dashboardName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList<Chart> getChartList() {
        return this.chartList;
    }

    public void setChartList(ArrayList<Chart> chartList) {
        this.chartList = new ArrayList();
        for (Chart chart : chartList) {
            this.chartList.add(chart);
        }
    }

    public Dashboard() {
    }

    public Dashboard(String dashboardName, String description, ArrayList<Chart> chartList) {
        this.dashboardName = dashboardName;
        this.description = description;
        this.chartList = chartList;
    }

    public Dashboard(String dashboardName, String displayName, String description, ArrayList<Chart> chartList) {
        this.dashboardName = dashboardName;
        this.description = description;
        this.chartList = chartList;
        this.displayName = displayName;
    }

    public Dashboard(String dashboardName, String displayName, String description, String attribute, ArrayList<Chart> chartList) {
        this.dashboardName = dashboardName;
        this.description = description;
        this.chartList = chartList;
        this.displayName = displayName;
        this.attribute = attribute;
    }

    public JSONObject ToJsonObject() {
        JSONObject dashboardJson = new JSONObject();
        dashboardJson.put("dashboardName", this.getDashboardName());
        dashboardJson.put("description", this.getDescription());
        dashboardJson.put("displayName", this.getDisplayName());
        if (this.getAttribute().length() > 0) {
            dashboardJson.put("attribute", JSONObject.fromObject(this.getAttribute()));
        } else {
            dashboardJson.put("attribute", JSONObject.fromObject("{}"));
        }
        JSONArray chartArray = new JSONArray();
        for (Chart chart : this.getChartList()) {
            chartArray.add(chart.ToJsonObject());
        }
        dashboardJson.put("charts", chartArray);
        return dashboardJson;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            this.setDashboardName(dict.getString("dashboardName"));
            this.setDescription(dict.getString("description"));
            if (dict.has("displayName")) {
                this.setDisplayName(dict.getString("displayName"));
            }
            if (dict.containsKey("attribute")) {
                JSONObject attributeJson = dict.getJSONObject("attribute");
                this.setAttribute(attributeJson.toString());
            }
            ArrayList<Chart> chartList = new ArrayList<Chart>();
            try {
                JSONArray chartJsonArray = dict.getJSONArray("charts");
                for (int index = 0; index != chartJsonArray.size(); ++index) {
                    Chart chart = new Chart();
                    chart.FromJsonObject(chartJsonArray.getJSONObject(index));
                    chartList.add(chart);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.setChartList(chartList);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateDashboard", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String dashboardString) throws LogException {
        try {
            JSONObject dict = JSONObject.fromObject(dashboardString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateDashboard", e.getMessage(), e, "");
        }
    }
}

