/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.CommonConfigInputDetail;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.ConfigInputDetail;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.ConfigOutputDetail;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.PluginLogConfigInputDetail;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.StreamLogConfigInputDetail;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.net.sf.json.JSONException;
import com.alibaba.schedulerx.shade.net.sf.json.JSONObject;
import java.io.Serializable;

public class Config
implements Serializable {
    private static final long serialVersionUID = -8687635889524799595L;
    protected String logSample = "";
    protected String configName = "";
    protected String inputType;
    protected CommonConfigInputDetail inputDetail;
    protected String outputType = "LogService";
    protected ConfigOutputDetail outputDetail = new ConfigOutputDetail();
    protected int createTime = 0;
    protected int lastModifyTime = 0;

    public Config() {
        this.inputType = "file";
        this.inputDetail = new ConfigInputDetail();
    }

    public Config(String configName) {
        this.inputType = "file";
        this.configName = configName;
    }

    public Config(String configName, String inputType) {
        this.inputType = inputType;
        this.configName = configName;
        this.inputDetail = inputType.equals("streamlog") || inputType.equals("syslog") ? new StreamLogConfigInputDetail() : (inputType.equals("plugin") ? new PluginLogConfigInputDetail() : new ConfigInputDetail());
    }

    public Config(Config config) {
        this.inputType = config.GetInputType();
        this.configName = config.GetConfigName();
        this.SetInputDetail(config.GetInputDetail());
        this.SetOutputDetail(config.GetOutputDetail());
        this.createTime = config.GetCreateTime();
        this.lastModifyTime = config.GetLastModifyTime();
        this.logSample = config.GetLogSample();
    }

    public String GetInputType() {
        return this.inputType;
    }

    public void SetInputType(String inputType) {
        this.inputType = inputType;
    }

    public String GetLogSample() {
        return this.logSample;
    }

    public void SetLogSample(String logSample) {
        this.logSample = logSample;
    }

    public String GetConfigName() {
        return this.configName;
    }

    public void SetConfigName(String configName) {
        this.configName = configName;
    }

    public CommonConfigInputDetail GetInputDetail() {
        return this.inputDetail;
    }

    public void SetInputDetail(CommonConfigInputDetail inputDetail) {
        this.inputDetail = inputDetail;
    }

    public void SetInputDetail(String inputDetailString) throws LogException {
        this.inputDetail = CommonConfigInputDetail.FromJsonStringS(this.inputType, inputDetailString);
    }

    public void SetInputDetail(JSONObject inputDetail) throws LogException {
        this.inputDetail = CommonConfigInputDetail.FromJsonObjectS(this.inputType, inputDetail);
    }

    public ConfigOutputDetail GetOutputDetail() {
        return this.outputDetail;
    }

    public void SetOutputDetail(ConfigOutputDetail outputDetail) {
        this.outputDetail = new ConfigOutputDetail(outputDetail);
    }

    public void SetOutputDetail(String outputDetailString) throws LogException {
        this.outputDetail = new ConfigOutputDetail();
        this.outputDetail.FromJsonString(outputDetailString);
    }

    public void SetOutputDetail(JSONObject outputDetail) throws LogException {
        this.outputDetail = new ConfigOutputDetail();
        this.outputDetail.FromJsonObject(outputDetail);
    }

    public int GetCreateTime() {
        return this.createTime;
    }

    public void SetCreateTime(int createTime) {
        this.createTime = createTime;
    }

    public int GetLastModifyTime() {
        return this.lastModifyTime;
    }

    public void SetLastModifyTime(int lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    private JSONObject ToRequestJson() {
        JSONObject configDict = new JSONObject();
        configDict.put("configName", this.GetConfigName());
        configDict.put("logSample", this.logSample);
        configDict.put("inputType", this.inputType);
        configDict.put("inputDetail", this.GetInputDetail().ToJsonObject());
        configDict.put("outputType", this.outputType);
        configDict.put("outputDetail", this.GetOutputDetail().ToJsonObject());
        return configDict;
    }

    public String ToRequestString() {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() {
        JSONObject configDict = this.ToRequestJson();
        configDict.put("createTime", (Object)this.GetCreateTime());
        configDict.put("lastModifyTime", (Object)this.GetLastModifyTime());
        return configDict;
    }

    public String ToJsonString() {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            String configName = dict.getString("configName");
            this.SetConfigName(configName);
            this.SetInputType(dict.getString("inputType"));
            if (dict.containsKey("inputDetail")) {
                this.SetInputDetail(dict.getJSONObject("inputDetail"));
            }
            if (dict.containsKey("outputDetail")) {
                this.SetOutputDetail(dict.getJSONObject("outputDetail"));
            }
            if (dict.containsKey("createTime")) {
                this.SetCreateTime(dict.getInt("createTime"));
            }
            if (dict.containsKey("lastModifyTime")) {
                this.SetLastModifyTime(dict.getInt("lastModifyTime"));
            }
            if (dict.containsKey("logSample")) {
                this.SetLogSample(dict.getString("logSample"));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateConfig", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String configString) throws LogException {
        try {
            JSONObject dict = JSONObject.fromObject(configString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateConfig", e.getMessage(), e, "");
        }
    }
}

