/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.internals;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.internals.ProducerBatch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryQueue {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryQueue.class);
    private final DelayQueue<ProducerBatch> retryBatches = new DelayQueue();
    private final AtomicInteger putsInProgress = new AtomicInteger(0);
    private volatile boolean closed = false;

    public void put(ProducerBatch batch) {
        this.putsInProgress.incrementAndGet();
        try {
            if (this.closed) {
                throw new IllegalStateException("cannot put after the retry queue was closed");
            }
            this.retryBatches.put(batch);
        }
        finally {
            this.putsInProgress.decrementAndGet();
        }
    }

    public List<ProducerBatch> expiredBatches(long timeoutMs) {
        long deadline = System.currentTimeMillis() + timeoutMs;
        ArrayList<ProducerBatch> expiredBatches = new ArrayList<ProducerBatch>();
        this.retryBatches.drainTo(expiredBatches);
        if (!expiredBatches.isEmpty()) {
            return expiredBatches;
        }
        while (timeoutMs >= 0L) {
            ProducerBatch batch;
            try {
                batch = (ProducerBatch)this.retryBatches.poll(timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.info("Interrupted when poll batch from the retry batches");
                break;
            }
            if (batch == null) break;
            expiredBatches.add(batch);
            this.retryBatches.drainTo(expiredBatches);
            if (!expiredBatches.isEmpty()) break;
            timeoutMs = deadline - System.currentTimeMillis();
        }
        return expiredBatches;
    }

    public List<ProducerBatch> remainingBatches() {
        if (!this.closed) {
            throw new IllegalStateException("cannot get the remaining batches before the retry queue closed");
        }
        while (this.putsInProgress()) {
        }
        ArrayList<ProducerBatch> remainingBatches = new ArrayList<ProducerBatch>(this.retryBatches);
        this.retryBatches.clear();
        return remainingBatches;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
    }

    private boolean putsInProgress() {
        return this.putsInProgress.get() > 0;
    }
}

