/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.Client;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProjectConfigs {
    private final Map<String, Client> clientPool = new ConcurrentHashMap<String, Client>();

    public void put(ProjectConfig projectConfig) {
        Client client = this.buildClient(projectConfig);
        this.clientPool.put(projectConfig.getProject(), client);
    }

    public void remove(ProjectConfig projectConfig) {
        this.clientPool.remove(projectConfig.getProject());
    }

    public void clear() {
        this.clientPool.clear();
    }

    public Client getClient(String project) {
        return this.clientPool.get(project);
    }

    private Client buildClient(ProjectConfig projectConfig) {
        String stsToken;
        Client client = new Client(projectConfig.getEndpoint(), projectConfig.getAccessKeyId(), projectConfig.getAccessKeySecret());
        String userAgent = projectConfig.getUserAgent();
        if (userAgent != null) {
            client.setUserAgent(userAgent);
        }
        if ((stsToken = projectConfig.getStsToken()) != null) {
            client.SetSecurityToken(stsToken);
        }
        return client;
    }
}

