/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.sdk.common;

import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.schedulerx.common.sdk.common.JobConfigInfo;
import com.alibaba.schedulerx.common.sdk.common.JobMonitorInfo;
import com.alibaba.schedulerx.common.sdk.common.NotNull;
import com.alibaba.schedulerx.common.sdk.common.TimeConfig;
import java.util.HashMap;
import java.util.Map;

@JSONType(seeAlso={JobConfigInfo.class})
public class JobBaseConfig {
    private long jobId;
    @NotNull(message="name can not be null")
    private String name;
    private String description;
    @NotNull(message="executeMode can not be null")
    private String executeMode;
    private String parameters;
    private int maxConcurrency = 1;
    private int maxAttempt = 0;
    private int attemptInterval = 30;
    private int status;
    @NotNull(message="timeConfig can not be null")
    private TimeConfig timeConfig;
    @NotNull(message="jobMonitorInfo can not be null")
    private JobMonitorInfo jobMonitorInfo;
    private Map<String, Object> paramMap = new HashMap<String, Object>();

    public long getJobId() {
        return this.jobId;
    }

    public void setJobId(long jobId) {
        this.jobId = jobId;
        this.paramMap.put("jobId", jobId);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.paramMap.put("name", name);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.paramMap.put("description", description);
    }

    public String getExecuteMode() {
        return this.executeMode;
    }

    public void setExecuteMode(String executeMode) {
        this.executeMode = executeMode;
        this.paramMap.put("executeMode", executeMode);
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
        this.paramMap.put("parameters", parameters);
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public void setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        this.paramMap.put("maxConcurrency", maxConcurrency);
    }

    public int getMaxAttempt() {
        return this.maxAttempt;
    }

    public void setMaxAttempt(int maxAttempt) {
        this.maxAttempt = maxAttempt;
        this.paramMap.put("maxAttempt", maxAttempt);
    }

    public int getAttemptInterval() {
        return this.attemptInterval;
    }

    public void setAttemptInterval(int attemptInterval) {
        this.attemptInterval = attemptInterval;
        this.paramMap.put("attemptInterval", attemptInterval);
    }

    public TimeConfig getTimeConfig() {
        return this.timeConfig;
    }

    public void setTimeConfig(TimeConfig timeConfig) {
        this.timeConfig = timeConfig;
        this.paramMap.putAll(timeConfig.getParamMap());
    }

    public JobMonitorInfo getJobMonitorInfo() {
        return this.jobMonitorInfo;
    }

    public void setJobMonitorInfo(JobMonitorInfo jobMonitorInfo) {
        this.jobMonitorInfo = jobMonitorInfo;
        this.paramMap.putAll(jobMonitorInfo.getParamMap());
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    public String toString() {
        return "JobBaseConfig{jobId=" + this.jobId + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", executeMode='" + this.executeMode + '\'' + ", parameters='" + this.parameters + '\'' + ", maxConcurrency=" + this.maxConcurrency + ", maxAttempt=" + this.maxAttempt + ", attemptInterval=" + this.attemptInterval + ", status=" + this.status + ", timeConfig=" + this.timeConfig + ", jobMonitorInfo=" + this.jobMonitorInfo + '}';
    }
}

