/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.domain;

import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import java.util.ArrayList;
import java.util.List;

public enum InstanceStatus {
    UNKNOWN(0, "\u672a\u77e5", false, "unknown"),
    WAITING(1, "\u7b49\u5f85", false, "waiting"),
    READY(2, "\u6c60\u5b50", false, "ready"),
    RUNNING(3, "\u8fd0\u884c", false, "running"),
    SUCCESS(4, "\u6210\u529f", true, "success"),
    FAILED(5, "\u5931\u8d25", true, "failed"),
    PAUSED(7, "\u6682\u505c", false, "paused"),
    SUBMITTED(8, "\u5df2\u63d0\u4ea4", false, "submitted"),
    REJECTED(9, "\u62d2\u7edd", false, "rejected"),
    ACCEPTED(10, "\u63a5\u6536", false, "accepted"),
    PARTIAL_FAILED(11, "\u90e8\u5206\u5931\u8d25", false, "partial_failed"),
    REMOVED(99, "\u5220\u9664", true, "removed");

    private int value;
    private String description;
    private boolean isFinish;
    private String enDesc;

    private InstanceStatus(int value, String description, boolean isFinish, String enDesc) {
        this.value = value;
        this.description = description;
        this.isFinish = isFinish;
        this.enDesc = enDesc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isFinish() {
        return this.isFinish;
    }

    public String getEnDesc() {
        return this.enDesc;
    }

    public static InstanceStatus parseValue(int value) {
        InstanceStatus[] statusList;
        for (InstanceStatus s : statusList = InstanceStatus.values()) {
            if (s.getValue() != value) continue;
            return s;
        }
        throw new IllegalArgumentException("InstanceStatus value is invalid. value:" + value);
    }

    public static List<Integer> getFailStatus() {
        ArrayList<Integer> statusList = Lists.newArrayList();
        statusList.add(InstanceStatus.FAILED.value);
        return statusList;
    }

    public static String getUnFinshStatus() {
        ArrayList<String> statusList = Lists.newArrayList();
        statusList.add(Integer.toString(InstanceStatus.WAITING.value));
        statusList.add(Integer.toString(InstanceStatus.READY.value));
        statusList.add(Integer.toString(InstanceStatus.RUNNING.value));
        return StringUtils.join(statusList, ",");
    }

    public static String getFinshStatus() {
        ArrayList<String> statusList = Lists.newArrayList();
        statusList.add(Integer.toString(InstanceStatus.FAILED.value));
        statusList.add(Integer.toString(InstanceStatus.SUCCESS.value));
        return StringUtils.join(statusList, ",");
    }
}

