/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.Interceptor;
import com.aliyun.openservices.shade.org.apache.commons.lang3.ArrayUtils;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

public class StatisticsItem {
    private String statKind;
    private String statObject;
    private String[] itemNames;
    private AtomicLong[] itemAccumulates;
    private AtomicLong invokeTimes;
    private Interceptor interceptor;
    private AtomicLong lastTimeStamp;

    public StatisticsItem(String statKind, String statObject, String ... itemNames) {
        if (itemNames == null || itemNames.length <= 0) {
            throw new InvalidParameterException("StatisticsItem \"itemNames\" is empty");
        }
        this.statKind = statKind;
        this.statObject = statObject;
        this.itemNames = itemNames;
        AtomicLong[] accs = new AtomicLong[itemNames.length];
        for (int i = 0; i < itemNames.length; ++i) {
            accs[i] = new AtomicLong(0L);
        }
        this.itemAccumulates = accs;
        this.invokeTimes = new AtomicLong();
        this.lastTimeStamp = new AtomicLong(System.currentTimeMillis());
    }

    public void incItems(long ... itemIncs) {
        int len = Math.min(itemIncs.length, this.itemAccumulates.length);
        for (int i = 0; i < len; ++i) {
            this.itemAccumulates[i].addAndGet(itemIncs[i]);
        }
        this.invokeTimes.addAndGet(1L);
        this.lastTimeStamp.set(System.currentTimeMillis());
        if (this.interceptor != null) {
            this.interceptor.inc(itemIncs);
        }
    }

    public String getStatKind() {
        return this.statKind;
    }

    public String getStatObject() {
        return this.statObject;
    }

    public String[] getItemNames() {
        return this.itemNames;
    }

    public AtomicLong[] getItemAccumulates() {
        return this.itemAccumulates;
    }

    public AtomicLong getInvokeTimes() {
        return this.invokeTimes;
    }

    public AtomicLong getLastTimeStamp() {
        return this.lastTimeStamp;
    }

    public AtomicLong getItemAccumulate(String itemName) {
        int index = ArrayUtils.indexOf(this.itemNames, itemName);
        if (index < 0) {
            return new AtomicLong(0L);
        }
        return this.itemAccumulates[index];
    }

    public StatisticsItem snapshot() {
        StatisticsItem ret = new StatisticsItem(this.statKind, this.statObject, this.itemNames);
        ret.itemAccumulates = new AtomicLong[this.itemAccumulates.length];
        for (int i = 0; i < this.itemAccumulates.length; ++i) {
            ret.itemAccumulates[i] = new AtomicLong(this.itemAccumulates[i].get());
        }
        ret.invokeTimes = new AtomicLong(this.invokeTimes.longValue());
        ret.lastTimeStamp = new AtomicLong(this.lastTimeStamp.longValue());
        return ret;
    }

    public StatisticsItem subtract(StatisticsItem item) {
        if (item == null) {
            return this.snapshot();
        }
        if (!(this.statKind.equals(item.statKind) && this.statObject.equals(item.statObject) && Arrays.equals(this.itemNames, item.itemNames))) {
            throw new IllegalArgumentException("StatisticsItem's kind, key and itemNames must be exactly the same");
        }
        StatisticsItem ret = new StatisticsItem(this.statKind, this.statObject, this.itemNames);
        ret.invokeTimes = new AtomicLong(this.invokeTimes.get() - item.invokeTimes.get());
        ret.itemAccumulates = new AtomicLong[this.itemAccumulates.length];
        for (int i = 0; i < this.itemAccumulates.length; ++i) {
            ret.itemAccumulates[i] = new AtomicLong(this.itemAccumulates[i].get() - item.itemAccumulates[i].get());
        }
        return ret;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }
}

