/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.zipkin.initialize;

import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.listener.SpanReportListenerHolder;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.tracer.plugins.zipkin.ZipkinSofaTracerRestTemplateCustomizer;
import com.alipay.sofa.tracer.plugins.zipkin.ZipkinSofaTracerSpanRemoteReporter;
import java.util.ArrayList;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.client.RestTemplate;

public class ZipkinReportRegisterBean
implements InitializingBean {
    public void afterPropertiesSet() {
        boolean enabled = false;
        String enabledStr = SofaTracerConfiguration.getProperty((String)"com.alipay.sofa.tracer.zipkin.enabled");
        if (StringUtils.isNotBlank((String)enabledStr) && "true".equalsIgnoreCase(enabledStr)) {
            enabled = true;
        }
        if (!enabled) {
            return;
        }
        boolean gzipped = false;
        String gzippedStr = SofaTracerConfiguration.getProperty((String)"com.alipay.sofa.tracer.zipkin.gzipped");
        if (StringUtils.isNotBlank((String)gzippedStr) && "true".equalsIgnoreCase(gzippedStr)) {
            gzipped = true;
        }
        RestTemplate restTemplate = new RestTemplate();
        ZipkinSofaTracerRestTemplateCustomizer zipkinSofaTracerRestTemplateCustomizer = new ZipkinSofaTracerRestTemplateCustomizer(gzipped);
        zipkinSofaTracerRestTemplateCustomizer.customize(restTemplate);
        String baseUrl = SofaTracerConfiguration.getProperty((String)"com.alipay.sofa.tracer.zipkin.baseUrl");
        ZipkinSofaTracerSpanRemoteReporter spanReportListener = new ZipkinSofaTracerSpanRemoteReporter(restTemplate, baseUrl);
        ArrayList<ZipkinSofaTracerSpanRemoteReporter> spanReportListenerList = new ArrayList<ZipkinSofaTracerSpanRemoteReporter>();
        spanReportListenerList.add(spanReportListener);
        SpanReportListenerHolder.addSpanReportListeners(spanReportListenerList);
    }
}

