/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.zipkin.adapter;

import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.span.LogData;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.tracer.plugins.zipkin.adapter.NetUtils;
import io.opentracing.tag.Tags;
import java.net.InetAddress;
import java.util.Map;
import zipkin2.Endpoint;
import zipkin2.Span;

public class ZipkinV2SpanAdapter {
    private InetAddress localIpAddress = null;

    public Span convertToZipkinSpan(SofaTracerSpan sofaTracerSpan) {
        if (sofaTracerSpan == null) {
            return null;
        }
        Span.Builder zipkinSpanBuilder = Span.newBuilder();
        SofaTracerSpanContext context = sofaTracerSpan.getSofaTracerSpanContext();
        zipkinSpanBuilder.traceId(context.getTraceId());
        zipkinSpanBuilder.id(ZipkinV2SpanAdapter.spanIdToLong(context.getSpanId()));
        if (StringUtils.isNotBlank((String)context.getParentId())) {
            zipkinSpanBuilder.parentId(ZipkinV2SpanAdapter.spanIdToLong(context.getParentId()));
        }
        long start = sofaTracerSpan.getStartTime() * 1000L;
        long finish = sofaTracerSpan.getEndTime() * 1000L;
        zipkinSpanBuilder.timestamp(start);
        zipkinSpanBuilder.duration(finish - start);
        Map tagsWithStr = sofaTracerSpan.getTagsWithStr();
        String kindStr = (String)tagsWithStr.get(Tags.SPAN_KIND.getKey());
        if (StringUtils.isNotBlank((String)kindStr) && kindStr.equals("server")) {
            zipkinSpanBuilder.kind(Span.Kind.SERVER);
        } else {
            zipkinSpanBuilder.kind(Span.Kind.CLIENT);
        }
        Endpoint endpoint = this.getZipkinEndpoint(sofaTracerSpan);
        zipkinSpanBuilder.localEndpoint(endpoint);
        this.addZipkinTags(zipkinSpanBuilder, sofaTracerSpan);
        String operationName = sofaTracerSpan.getOperationName();
        if (StringUtils.isNotBlank((String)operationName)) {
            zipkinSpanBuilder.name(operationName);
        } else {
            zipkinSpanBuilder.name("");
        }
        this.addZipkinAnnotations(zipkinSpanBuilder, sofaTracerSpan);
        return zipkinSpanBuilder.build();
    }

    public static long spanIdToLong(String spanId) {
        return ZipkinV2SpanAdapter.FNV64HashCode(spanId);
    }

    public static long FNV64HashCode(String data) {
        long hash = -3750763034362895579L;
        for (int i = 0; i < data.length(); ++i) {
            char c = data.charAt(i);
            hash ^= (long)c;
            hash *= 1099511628211L;
        }
        return hash;
    }

    private Endpoint getZipkinEndpoint(SofaTracerSpan span) {
        if (this.localIpAddress == null) {
            this.localIpAddress = NetUtils.getLocalAddress();
        }
        String appName = (String)span.getTagsWithStr().get("local.app");
        return Endpoint.newBuilder().serviceName(appName).ip(this.localIpAddress).build();
    }

    private void addZipkinTagsWithBaggage(Span.Builder zipkinSpan, SofaTracerSpan span) {
        SofaTracerSpanContext sofaTracerSpanContext = span.getSofaTracerSpanContext();
        if (sofaTracerSpanContext != null) {
            Map sysBaggage = sofaTracerSpanContext.getSysBaggage();
            for (Map.Entry e : sysBaggage.entrySet()) {
                zipkinSpan.putTag((String)e.getKey(), (String)e.getValue());
            }
            Map bizBaggage = sofaTracerSpanContext.getBizBaggage();
            for (Map.Entry e : bizBaggage.entrySet()) {
                zipkinSpan.putTag((String)e.getKey(), (String)e.getValue());
            }
        }
    }

    private void addZipkinAnnotations(Span.Builder zipkinSpan, SofaTracerSpan span) {
        for (LogData logData : span.getLogs()) {
            Map fields = logData.getFields();
            if (fields == null || fields.size() <= 0) continue;
            for (Map.Entry entry : fields.entrySet()) {
                if (entry.getValue().toString().equals("cr") || entry.getValue().toString().equals("cs") || entry.getValue().toString().equals("sr") || entry.getValue().toString().equals("ss")) continue;
                zipkinSpan.addAnnotation(logData.getTime() * 1000L, entry.getValue().toString());
            }
        }
    }

    private void addZipkinTags(Span.Builder zipkinSpan, SofaTracerSpan span) {
        for (Map.Entry e : span.getTagsWithStr().entrySet()) {
            zipkinSpan.putTag((String)e.getKey(), (String)e.getValue());
        }
        for (Map.Entry e : span.getTagsWithNumber().entrySet()) {
            zipkinSpan.putTag((String)e.getKey(), ((Number)e.getValue()).toString());
        }
        for (Map.Entry e : span.getTagsWithBool().entrySet()) {
            zipkinSpan.putTag((String)e.getKey(), ((Boolean)e.getValue()).toString());
        }
        this.addZipkinTagsWithBaggage(zipkinSpan, span);
    }
}

