/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.zipkin.adapter;

import com.alipay.common.tracer.core.utils.StringUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtils.class);
    public static final String ANYHOST = "0.0.0.0";
    private static final Pattern LOCAL_IP_PATTERN = Pattern.compile("127(\\.\\d{1,3}){3}$");
    public static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");

    private NetUtils() {
    }

    public static boolean isLocalHost(String host) {
        return StringUtils.isNotBlank((String)host) && (LOCAL_IP_PATTERN.matcher(host).matches() || "localhost".equalsIgnoreCase(host));
    }

    public static boolean isAnyHost(String host) {
        return ANYHOST.equals(host);
    }

    public static boolean isIPv4Host(String host) {
        return StringUtils.isNotBlank((String)host) && IPV4_PATTERN.matcher(host).matches();
    }

    private static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !NetUtils.isAnyHost(name) && !NetUtils.isLocalHost(name) && NetUtils.isIPv4Host(name);
    }

    public static String getLocalIpv4() {
        InetAddress address = NetUtils.getLocalAddress();
        return address == null ? null : address.getHostAddress();
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress;
        block14: {
            block13: {
                localAddress = null;
                try {
                    localAddress = InetAddress.getLocalHost();
                    if (NetUtils.isValidAddress(localAddress)) {
                        return localAddress;
                    }
                }
                catch (Throwable e) {
                    if (!LOGGER.isWarnEnabled()) break block13;
                    LOGGER.warn("Error when retrieving ip address: " + e.getMessage(), e);
                }
            }
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                if (interfaces != null) {
                    while (interfaces.hasMoreElements()) {
                        try {
                            NetworkInterface network = interfaces.nextElement();
                            Enumeration<InetAddress> addresses = network.getInetAddresses();
                            while (addresses.hasMoreElements()) {
                                try {
                                    InetAddress address = addresses.nextElement();
                                    if (!NetUtils.isValidAddress(address)) continue;
                                    return address;
                                }
                                catch (Throwable e) {
                                    if (!LOGGER.isWarnEnabled()) continue;
                                    LOGGER.warn("Error when retrieving ip address: " + e.getMessage(), e);
                                }
                            }
                        }
                        catch (Throwable e) {
                            if (!LOGGER.isWarnEnabled()) continue;
                            LOGGER.warn("Error when retrieving ip address: " + e.getMessage(), e);
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (!LOGGER.isWarnEnabled()) break block14;
                LOGGER.warn("Error when retrieving ip address: " + e.getMessage(), e);
            }
        }
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Can't get valid host, will use 127.0.0.1 instead.");
        }
        return localAddress;
    }
}

