/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.zipkin;

import com.alipay.common.tracer.core.listener.SpanReportListener;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.TracerUtils;
import com.alipay.sofa.tracer.plugins.zipkin.adapter.ZipkinV2SpanAdapter;
import com.alipay.sofa.tracer.plugins.zipkin.sender.ZipkinRestTemplateSender;
import java.io.Closeable;
import java.io.Flushable;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import zipkin2.Span;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Sender;

public class ZipkinSofaTracerSpanRemoteReporter
implements SpanReportListener,
Flushable,
Closeable {
    private static String processId = TracerUtils.getPID();
    private final ZipkinRestTemplateSender sender;
    private final AsyncReporter<Span> delegate;
    private final ZipkinV2SpanAdapter zipkinV2SpanAdapter = new ZipkinV2SpanAdapter();

    public ZipkinSofaTracerSpanRemoteReporter(RestTemplate restTemplate, String baseUrl) {
        this.sender = new ZipkinRestTemplateSender(restTemplate, baseUrl);
        this.delegate = AsyncReporter.create((Sender)this.sender);
    }

    public void onSpanReport(SofaTracerSpan span) {
        if (span == null || !span.getSofaTracerSpanContext().isSampled()) {
            return;
        }
        Span zipkinSpan = this.zipkinV2SpanAdapter.convertToZipkinSpan(span);
        this.delegate.report((Object)zipkinSpan);
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public static long traceIdToId(String hexString) {
        Assert.hasText((String)hexString, (String)"Can't convert empty hex string to long");
        int length = hexString.length();
        if (length < 1) {
            throw new IllegalArgumentException("Malformed id(length must be more than zero): " + hexString);
        }
        if (length <= 8) {
            return Long.parseLong(hexString, 16);
        }
        if (hexString.endsWith(processId)) {
            return Long.parseLong(hexString.substring(8, hexString.lastIndexOf(processId)), 10);
        }
        return Long.parseLong(hexString.substring(8), 10);
    }
}

