/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.zipkin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.RestTemplate;

public class ZipkinSofaTracerRestTemplateCustomizer {
    private boolean gzipped;

    public ZipkinSofaTracerRestTemplateCustomizer(boolean gzipped) {
        this.gzipped = gzipped;
    }

    public void customize(RestTemplate restTemplate) {
        if (!this.gzipped || restTemplate == null) {
            return;
        }
        restTemplate.getInterceptors().add(0, new GzipInterceptor());
    }

    private class GzipInterceptor
    implements ClientHttpRequestInterceptor {
        private GzipInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            request.getHeaders().add("Content-Encoding", "gzip");
            ByteArrayOutputStream gzipped = new ByteArrayOutputStream();
            try (GZIPOutputStream compressor = null;){
                compressor = new GZIPOutputStream(gzipped);
                compressor.write(body);
            }
            return execution.execute(request, gzipped.toByteArray());
        }
    }
}

