/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.ConnectionManager;
import com.alipay.remoting.Url;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.log.BoltLoggerFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;

public class ReconnectManager {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    private final LinkedBlockingQueue<ReconnectTask> tasks = new LinkedBlockingQueue();
    protected final List<Url> canceled = new CopyOnWriteArrayList<Url>();
    private volatile boolean started = false;
    private int healConnectionInterval = 1000;
    private final Thread healConnectionThreads;
    private ConnectionManager connectionManager;

    public ReconnectManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.healConnectionThreads = new Thread(new HealConnectionRunner());
        this.healConnectionThreads.start();
        this.started = true;
    }

    private void doReconnectTask(ReconnectTask task) throws InterruptedException, RemotingException {
        this.connectionManager.createConnectionAndHealIfNeed(task.url);
    }

    private void addReconnectTask(ReconnectTask task) {
        this.tasks.add(task);
    }

    public void addCancelUrl(Url url) {
        this.canceled.add(url);
    }

    public void removeCancelUrl(Url url) {
        this.canceled.remove(url);
    }

    public void addReconnectTask(Url url) {
        ReconnectTask task = new ReconnectTask();
        task.url = url;
        this.tasks.add(task);
    }

    private boolean isValidTask(ReconnectTask task) {
        return !this.canceled.contains(task.url);
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.healConnectionThreads.interrupt();
        this.tasks.clear();
        this.canceled.clear();
    }

    private final class HealConnectionRunner
    implements Runnable {
        private long lastConnectTime = -1L;

        private HealConnectionRunner() {
        }

        @Override
        public void run() {
            while (ReconnectManager.this.started) {
                long start = -1L;
                ReconnectTask task = null;
                try {
                    if (this.lastConnectTime > 0L && this.lastConnectTime < (long)ReconnectManager.this.healConnectionInterval || this.lastConnectTime < 0L) {
                        Thread.sleep(ReconnectManager.this.healConnectionInterval);
                    }
                    try {
                        task = (ReconnectTask)ReconnectManager.this.tasks.take();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    start = System.currentTimeMillis();
                    if (ReconnectManager.this.isValidTask(task)) {
                        ReconnectManager.this.doReconnectTask(task);
                    } else {
                        logger.warn("Invalid reconnect request task {}, cancel list size {}", (Object)task.url, (Object)ReconnectManager.this.canceled.size());
                    }
                    this.lastConnectTime = System.currentTimeMillis() - start;
                }
                catch (Exception e) {
                    this.retryWhenException(start, task, e);
                }
            }
        }

        private void retryWhenException(long start, ReconnectTask task, Exception e) {
            if (start != -1L) {
                this.lastConnectTime = System.currentTimeMillis() - start;
            }
            if (task != null) {
                logger.warn("reconnect target: {} failed.", (Object)task.url, (Object)e);
                ReconnectManager.this.addReconnectTask(task);
            }
        }
    }

    class ReconnectTask {
        Url url;

        ReconnectTask() {
        }
    }
}

