/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc.protocol;

import com.alipay.remoting.CommandDecoder;
import com.alipay.remoting.ResponseStatus;
import com.alipay.remoting.rpc.HeartbeatAckCommand;
import com.alipay.remoting.rpc.HeartbeatCommand;
import com.alipay.remoting.rpc.RequestCommand;
import com.alipay.remoting.rpc.ResponseCommand;
import com.alipay.remoting.rpc.protocol.RpcCommandCode;
import com.alipay.remoting.rpc.protocol.RpcProtocolV2;
import com.alipay.remoting.rpc.protocol.RpcRequestCommand;
import com.alipay.remoting.rpc.protocol.RpcResponseCommand;
import com.alipay.remoting.util.CrcUtil;
import com.alipay.remoting.util.ProtocolSwitch;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcCommandDecoderV2
implements CommandDecoder {
    private static final Logger logger = LoggerFactory.getLogger((String)"RpcRemoting");
    private int lessLen = RpcProtocolV2.getResponseHeaderLength() < RpcProtocolV2.getRequestHeaderLength() ? RpcProtocolV2.getResponseHeaderLength() : RpcProtocolV2.getRequestHeaderLength();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < this.lessLen) return;
        in.markReaderIndex();
        byte protocol = in.readByte();
        in.resetReaderIndex();
        if (protocol != 2) {
            String emsg = "Unknown protocol: " + protocol;
            logger.error(emsg);
            throw new RuntimeException(emsg);
        }
        if (in.readableBytes() <= 3) return;
        int startIndex = in.readerIndex();
        in.markReaderIndex();
        in.readByte();
        byte version = in.readByte();
        byte type = in.readByte();
        if (type == 1 || type == 2) {
            if (in.readableBytes() < RpcProtocolV2.getRequestHeaderLength() - 3) {
                in.resetReaderIndex();
                return;
            }
            short cmdCode = in.readShort();
            byte ver2 = in.readByte();
            int requestId = in.readInt();
            byte serializer = in.readByte();
            byte protocolSwitchValue = in.readByte();
            int timeout = in.readInt();
            short classLen = in.readShort();
            short headerLen = in.readShort();
            int contentLen = in.readInt();
            byte[] clazz = null;
            byte[] header = null;
            byte[] content = null;
            int lengthAtLeastForV1 = classLen + headerLen + contentLen;
            boolean crcSwitchOn = ProtocolSwitch.isOn(0, protocolSwitchValue);
            int lengthAtLeastForV2 = classLen + headerLen + contentLen;
            if (crcSwitchOn) {
                lengthAtLeastForV2 += 4;
            }
            if (version == 1 && in.readableBytes() >= lengthAtLeastForV1 || version == 2 && in.readableBytes() >= lengthAtLeastForV2) {
                if (classLen > 0) {
                    clazz = new byte[classLen];
                    in.readBytes(clazz);
                }
                if (headerLen > 0) {
                    header = new byte[headerLen];
                    in.readBytes(header);
                }
                if (contentLen > 0) {
                    content = new byte[contentLen];
                    in.readBytes(content);
                }
                if (version == 2 && crcSwitchOn) {
                    this.checkCRC(in, startIndex);
                }
            } else {
                in.resetReaderIndex();
                return;
            }
            RequestCommand command = cmdCode == 0 ? new HeartbeatCommand() : this.createRequestCommand(cmdCode);
            command.setType(type);
            command.setVersion(ver2);
            command.setId(requestId);
            command.setSerializer(serializer);
            command.setProtocolSwitch(ProtocolSwitch.create(protocolSwitchValue));
            command.setTimeout(timeout);
            command.setClazz(clazz);
            command.setHeader(header);
            command.setContent(content);
            out.add(command);
            return;
        }
        if (type != 0) {
            String emsg = "Unknown command type: " + type;
            logger.error(emsg);
            throw new RuntimeException(emsg);
        }
        if (in.readableBytes() < RpcProtocolV2.getResponseHeaderLength() - 3) {
            in.resetReaderIndex();
            return;
        }
        short cmdCode = in.readShort();
        byte ver2 = in.readByte();
        int requestId = in.readInt();
        byte serializer = in.readByte();
        byte protocolSwitchValue = in.readByte();
        short status = in.readShort();
        short classLen = in.readShort();
        short headerLen = in.readShort();
        int contentLen = in.readInt();
        byte[] clazz = null;
        byte[] header = null;
        byte[] content = null;
        int lengthAtLeastForV1 = classLen + headerLen + contentLen;
        boolean crcSwitchOn = ProtocolSwitch.isOn(0, protocolSwitchValue);
        int lengthAtLeastForV2 = classLen + headerLen + contentLen;
        if (crcSwitchOn) {
            lengthAtLeastForV2 += 4;
        }
        if (version == 1 && in.readableBytes() >= lengthAtLeastForV1 || version == 2 && in.readableBytes() >= lengthAtLeastForV2) {
            if (classLen > 0) {
                clazz = new byte[classLen];
                in.readBytes(clazz);
            }
            if (headerLen > 0) {
                header = new byte[headerLen];
                in.readBytes(header);
            }
            if (contentLen > 0) {
                content = new byte[contentLen];
                in.readBytes(content);
            }
            if (version == 2 && crcSwitchOn) {
                this.checkCRC(in, startIndex);
            }
        } else {
            in.resetReaderIndex();
            return;
        }
        ResponseCommand command = cmdCode == 0 ? new HeartbeatAckCommand() : this.createResponseCommand(cmdCode);
        command.setType(type);
        command.setVersion(ver2);
        command.setId(requestId);
        command.setSerializer(serializer);
        command.setProtocolSwitch(ProtocolSwitch.create(protocolSwitchValue));
        command.setResponseStatus(ResponseStatus.valueOf(status));
        command.setClazz(clazz);
        command.setHeader(header);
        command.setContent(content);
        command.setResponseTimeMillis(System.currentTimeMillis());
        command.setResponseHost((InetSocketAddress)ctx.channel().remoteAddress());
        out.add(command);
    }

    private void checkCRC(ByteBuf in, int startIndex) {
        int endIndex = in.readerIndex();
        int expectedCrc = in.readInt();
        byte[] frame = new byte[endIndex - startIndex];
        in.getBytes(startIndex, frame, 0, endIndex - startIndex);
        int actualCrc = CrcUtil.crc32(frame);
        if (expectedCrc != actualCrc) {
            String err = "CRC check failed!";
            logger.error(err);
            throw new RuntimeException(err);
        }
    }

    private ResponseCommand createResponseCommand(short cmdCode) {
        RpcResponseCommand command = new RpcResponseCommand();
        command.setCmdCode(RpcCommandCode.valueOf(cmdCode));
        return command;
    }

    private RpcRequestCommand createRequestCommand(short cmdCode) {
        RpcRequestCommand command = new RpcRequestCommand();
        command.setCmdCode(RpcCommandCode.valueOf(cmdCode));
        command.setArriveTime(System.currentTimeMillis());
        return command;
    }
}

