/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.set;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import org.jaxen.JaxenException;

public class UnsupportedExceptionWithModifyAsListRule
extends AbstractAliRule {
    private static final String ADD = ".add";
    private static final String REMOVE = ".remove";
    private static final String CLEAR = ".clear";
    private static final String XPATH = "//VariableDeclarator[../Type/ReferenceType/ClassOrInterfaceType[@Image='List']]/VariableInitializer/Expression/PrimaryExpression/PrimaryPrefix/Name[@Image='Arrays.asList']";
    private static final String CHILD_XPATH = "BlockStatement/Statement/StatementExpression/PrimaryExpression/PrimaryPrefix/Name";

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        try {
            List nodes = node.findChildNodesWithXPath(XPATH);
            for (Node item : nodes) {
                List parents;
                if (!(item instanceof ASTName) || (parents = item.getParentsOfType(ASTVariableDeclarator.class)) == null || parents.size() == 0 || parents.size() > 1) continue;
                ASTVariableDeclarator declarator = (ASTVariableDeclarator)parents.get(0);
                ASTVariableDeclaratorId variableName = (ASTVariableDeclaratorId)declarator.getFirstChildOfType(ASTVariableDeclaratorId.class);
                String valName = variableName.getImage();
                ASTBlock blockNode = (ASTBlock)variableName.getFirstParentOfType(ASTBlock.class);
                if (blockNode == null || valName == null) continue;
                List blockNodes = blockNode.findChildNodesWithXPath(CHILD_XPATH);
                for (Node blockItem : blockNodes) {
                    if (blockItem.getBeginLine() < item.getBeginLine() || !this.checkBlockNodesValid(valName, blockItem)) continue;
                    this.addViolationWithMessage(data, blockItem, "java.set.UnsupportedExceptionWithModifyAsListRule.violation.msg", new Object[]{blockItem.getImage()});
                }
            }
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        return super.visit(node, data);
    }

    private boolean checkBlockNodesValid(String variableName, Node item) {
        String name;
        return item instanceof ASTName && this.judgeName(name = item.getImage(), variableName);
    }

    private boolean judgeName(String name, String variableName) {
        return name.equals(variableName + ADD) || name.equals(variableName + REMOVE) || name.equals(variableName + CLEAR);
    }
}

