/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.validator;

import br.com.caelum.vraptor.core.SafeResourceBundle;
import br.com.caelum.vraptor.util.FallbackResourceBundle;
import br.com.caelum.vraptor.validator.I18nMessage;
import br.com.caelum.vraptor.validator.I18nParam;
import br.com.caelum.vraptor.validator.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.hamcrest.Matcher;
import org.hamcrest.ResourceBundleDescription;
import org.hamcrest.SelfDescribing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validations {
    private final List<Message> errors = new ArrayList<Message>();
    private ResourceBundle bundle;

    public Validations(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public Validations() {
        this.bundle = new SafeResourceBundle(ResourceBundle.getBundle("messages"), true);
    }

    public <T> boolean that(T id, Matcher<? super T> matcher) {
        return this.that(id, matcher, "", null, new Object[0]);
    }

    public <T> boolean that(T id, Matcher<? super T> matcher, String category) {
        return this.that(id, matcher, category, null, new Object[0]);
    }

    public <T> boolean that(T id, Matcher<? super T> matcher, I18nParam category) {
        return this.that(id, matcher, category, null, new Object[0]);
    }

    public <T> boolean that(T actual, Matcher<? super T> matcher, String category, String reason, Object ... messageParameters) {
        return this.genericThat(actual, matcher, (Object)category, reason, messageParameters);
    }

    public <T> boolean that(T actual, Matcher<? super T> matcher, I18nParam category, String reason, Object ... messageParameters) {
        return this.genericThat(actual, matcher, category, reason, messageParameters);
    }

    public boolean that(boolean assertion, String category, String reason, Object ... messageParameters) {
        return this.genericThat(assertion, category, reason, messageParameters);
    }

    public boolean that(boolean assertion, I18nParam category, String reason, Object ... messageParameters) {
        return this.genericThat(assertion, category, reason, messageParameters);
    }

    protected I18nParam i18n(String key) {
        return new I18nParam(key);
    }

    public List<Message> getErrors() {
        for (Message message : this.errors) {
            if (!(message instanceof I18nMessage)) continue;
            ((I18nMessage)message).setBundle(this.bundle);
        }
        return this.errors;
    }

    public List<Message> getErrors(ResourceBundle bundle) {
        this.bundle = this.isDefaultBundle(this.bundle) ? new SafeResourceBundle(bundle) : new FallbackResourceBundle(this.bundle, bundle);
        return this.getErrors();
    }

    private boolean isDefaultBundle(ResourceBundle bundle) {
        return bundle instanceof SafeResourceBundle && ((SafeResourceBundle)bundle).isDefault();
    }

    public Validations and(List<Message> errors) {
        this.errors.addAll(errors);
        return this;
    }

    public Validations and(Message error) {
        this.errors.add(error);
        return this;
    }

    private <T> boolean genericThat(T actual, Matcher<? super T> matcher, Object category, String reason, Object ... messageParameters) {
        if (!matcher.matches(actual)) {
            if (reason != null) {
                this.errors.add(this.i18nMessage(category, reason, messageParameters));
            } else {
                ResourceBundleDescription description = new ResourceBundleDescription();
                description.appendDescriptionOf((SelfDescribing)matcher);
                this.errors.add(this.i18nMessage(category, ((Object)((Object)description)).toString(), actual));
            }
            return false;
        }
        return true;
    }

    private I18nMessage i18nMessage(Object category, String reason, Object ... messageParameters) {
        if (category instanceof I18nParam) {
            return new I18nMessage((I18nParam)category, reason, messageParameters);
        }
        return new I18nMessage(category.toString(), reason, messageParameters);
    }

    private boolean genericThat(boolean assertion, Object category, String reason, Object ... messageParameters) {
        if (!assertion) {
            this.errors.add(this.i18nMessage(category, reason, messageParameters));
        }
        return assertion;
    }
}

