/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.validator;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.View;
import br.com.caelum.vraptor.core.Localization;
import br.com.caelum.vraptor.ioc.RequestScoped;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.util.test.MockResult;
import br.com.caelum.vraptor.validator.AbstractValidator;
import br.com.caelum.vraptor.validator.BeanValidator;
import br.com.caelum.vraptor.validator.I18nMessage;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.Outjector;
import br.com.caelum.vraptor.validator.Validations;
import br.com.caelum.vraptor.view.ValidationViewsFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RequestScoped
public class DefaultValidator
extends AbstractValidator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultValidator.class);
    private final Result result;
    private final List<Message> errors = new ArrayList<Message>();
    private final ValidationViewsFactory viewsFactory;
    private final List<BeanValidator> beanValidators;
    private final Outjector outjector;
    private final Proxifier proxifier;
    private final Localization localization;

    public DefaultValidator(Result result, ValidationViewsFactory factory, Outjector outjector, Proxifier proxifier, List<BeanValidator> beanValidators, Localization localization) {
        this.result = result;
        this.viewsFactory = factory;
        this.outjector = outjector;
        this.proxifier = proxifier;
        this.beanValidators = beanValidators;
        this.localization = localization;
    }

    @Override
    public void checking(Validations validations) {
        this.addAll(validations.getErrors(this.localization.getBundle()));
    }

    @Override
    public void validate(Object object) {
        if (this.beanValidators == null || this.beanValidators.isEmpty()) {
            logger.warn("has no validators registered");
        } else {
            for (BeanValidator validator : this.beanValidators) {
                this.addAll(validator.validate(object));
            }
        }
    }

    @Override
    public <T extends View> T onErrorUse(Class<T> view) {
        if (!this.hasErrors()) {
            return new MockResult(this.proxifier).use(view);
        }
        this.result.include("errors", this.errors);
        this.outjector.outjectRequestMap();
        return this.viewsFactory.instanceFor(view, this.errors);
    }

    @Override
    public void addAll(Collection<? extends Message> messages) {
        for (Message message : messages) {
            this.add(message);
        }
    }

    @Override
    public void add(Message message) {
        if (message instanceof I18nMessage && !((I18nMessage)message).hasBundle()) {
            ((I18nMessage)message).setBundle(this.localization.getBundle());
        }
        this.errors.add(message);
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public List<Message> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }
}

