/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.validator;

import br.com.caelum.vraptor.validator.Outjector;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOutjector
implements Outjector {
    private static final String DELIMITERS = "(\\[|\\]|\\.)";
    private static final String DELIM_CHARS = "\\[\\]\\.";
    private final HttpServletRequest request;

    public DefaultOutjector(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public void outjectRequestMap() {
        Set paramNames = this.request.getParameterMap().keySet();
        for (String paramName : paramNames) {
            if (this.isSimple(paramName)) {
                this.request.setAttribute(paramName, (Object)this.request.getParameter(paramName));
                continue;
            }
            String baseName = this.extractBaseParamName(paramName);
            Map<Object, Object> map = this.castMap(this.request.getAttribute(baseName));
            this.request.setAttribute(baseName, map);
            this.processComplexParameter(paramName, this.stripBaseName(paramName, baseName), map);
        }
    }

    private Map<Object, Object> castMap(final Object object) {
        if (object == null) {
            return new HashMap<Object, Object>();
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object instanceof String) {
            return new HashMap<Object, Object>(){

                @Override
                public String toString() {
                    return object.toString();
                }
            };
        }
        throw new IllegalStateException("Some request parameter has the same name as a request attribute. It shouldn't happen, please report this bug.");
    }

    private String stripBaseName(String paramName, String baseName) {
        return paramName.replaceFirst("^" + baseName + DELIMITERS + "+", "");
    }

    private void processComplexParameter(String fullName, String paramName, Map<Object, Object> parent) {
        if (this.isSimple(paramName)) {
            parent.put(this.fixParameter(paramName.replaceFirst("\\]$", "")), this.request.getParameter(fullName));
        } else {
            String baseName = this.extractBaseParamName(paramName);
            Map<Object, Object> map = this.castMap(parent.get(this.fixParameter(baseName)));
            parent.put(this.fixParameter(baseName), map);
            this.processComplexParameter(fullName, this.stripBaseName(paramName, baseName), map);
        }
    }

    private Object fixParameter(String paramName) {
        if (paramName.matches("\\d+")) {
            return Long.valueOf(paramName);
        }
        return paramName;
    }

    private boolean isSimple(String paramName) {
        return paramName.matches("[^\\[\\]\\.]+?\\]?");
    }

    private String extractBaseParamName(String paramName) {
        return paramName.replaceFirst("^([^\\[\\]\\.]+)[\\[\\]\\.].*$", "$1");
    }
}

