/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.serialization.IgnoringSerializer;
import br.com.caelum.vraptor.serialization.Serialization;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.view.Results;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLSerialization
implements Serialization {
    private final Result result;
    private final TypeNameExtractor extractor;

    public HTMLSerialization(Result result, TypeNameExtractor extractor) {
        this.result = result;
        this.extractor = extractor;
    }

    @Override
    public boolean accepts(String format) {
        return "html".equals(format);
    }

    @Override
    public <T> Serializer from(T object, String alias) {
        this.result.include(alias, object);
        this.result.use(Results.page()).defaultView();
        return new IgnoringSerializer();
    }

    @Override
    public <T> Serializer from(T object) {
        this.result.include(this.extractor.nameFor(object.getClass()), object);
        this.result.use(Results.page()).defaultView();
        return new IgnoringSerializer();
    }
}

