/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.scan;

import br.com.caelum.vraptor.scan.ClasspathResolver;
import br.com.caelum.vraptor.scan.ScannerException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneClasspathResolver
implements ClasspathResolver {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneClasspathResolver.class);
    private final File webxml;

    public StandaloneClasspathResolver() {
        String vraptor = "br/com/caelum/vraptor/VRaptor.class";
        URL vraptorJAR = this.getClassLoader().getResource(vraptor);
        String filename = vraptorJAR.getPath();
        int jarSeparationIndex = filename.lastIndexOf(33);
        filename = filename.substring(filename.indexOf(58) + 1, jarSeparationIndex == -1 ? filename.length() - 1 : jarSeparationIndex);
        filename = filename.substring(0, filename.lastIndexOf(47));
        this.webxml = new File(filename.substring(0, filename.lastIndexOf(47)) + "/web.xml");
    }

    public StandaloneClasspathResolver(String webxml) {
        this.webxml = new File(webxml);
    }

    @Override
    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public URL findWebInfClassesLocation() {
        try {
            File webInfClasses = new File(this.getWebxml().getParent() + "/classes");
            if (webInfClasses.exists()) {
                return new URL("file:" + webInfClasses.getAbsolutePath() + "/");
            }
            throw new ScannerException("Could not determine WEB-INF/classes location");
        }
        catch (MalformedURLException e) {
            throw new ScannerException("Could not determine WEB-INF/classes location", e);
        }
    }

    @Override
    public List<String> findBasePackages() {
        ArrayList<String> packages = new ArrayList<String>();
        this.getPackagesFromWebXml(packages);
        this.getPackagesFromPluginsJARs(packages);
        return packages;
    }

    void getPackagesFromWebXml(List<String> result) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(this.getWebxml());
            NodeList params = doc.getElementsByTagName("context-param");
            for (int i = 0; i < params.getLength(); ++i) {
                Element param = (Element)params.item(i);
                NodeList paramName = param.getElementsByTagName("param-name");
                if (!"br.com.caelum.vraptor.packages".equals(paramName.item(0).getTextContent())) continue;
                NodeList paramValue = param.getElementsByTagName("param-value");
                String packages = paramValue.item(0).getTextContent();
                Collections.addAll(result, packages.trim().split("\\s*,\\s*"));
                return;
            }
            logger.debug("No <context-param> found in web.xml");
        }
        catch (Exception e) {
            throw new ScannerException("Problems while parsing web.xml", e);
        }
    }

    void getPackagesFromPluginsJARs(List<String> result) {
        try {
            ClassLoader classLoader = this.getClassLoader();
            Enumeration<URL> urls = classLoader.getResources("META-INF/br.com.caelum.vraptor.packages");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String packagesConfig = new Scanner(url.openStream()).useDelimiter("\\Z").next();
                if (packagesConfig != null) {
                    Collections.addAll(result, packagesConfig.trim().split("\\s*,\\s*"));
                    continue;
                }
                logger.warn("Plugin packages file was empty: {}", (Object)url.getPath());
            }
        }
        catch (IOException e) {
            logger.error("Exception while searching for packages file inside JARs", (Throwable)e);
        }
    }

    private File getWebxml() {
        if (!this.webxml.exists()) {
            throw new ScannerException("Could not locate web.xml. Please use the proper argument in command-line.");
        }
        return this.webxml;
    }
}

