/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.restfulie.headers;

import br.com.caelum.vraptor.ioc.Component;
import br.com.caelum.vraptor.restfulie.RestHeadersHandler;
import br.com.caelum.vraptor.restfulie.headers.RestDefaults;
import br.com.caelum.vraptor.restfulie.hypermedia.HypermediaResource;
import br.com.caelum.vraptor.restfulie.resource.Cacheable;
import br.com.caelum.vraptor.restfulie.resource.RestfulEntity;
import java.util.Calendar;
import javax.servlet.http.HttpServletResponse;

@Component
public class DefaultRestHeadersHandler
implements RestHeadersHandler {
    private final HttpServletResponse response;
    private final RestDefaults defaults;

    public DefaultRestHeadersHandler(HttpServletResponse response, RestDefaults defaults) {
        this.defaults = defaults;
        this.response = response;
    }

    public void handle(HypermediaResource resource) {
        if (Cacheable.class.isAssignableFrom(resource.getClass())) {
            Cacheable cache = (Cacheable)((Object)resource);
            this.response.addHeader("Cache-control", "max-age=" + cache.getMaximumAge());
        }
        if (RestfulEntity.class.isInstance(resource)) {
            RestfulEntity entity = (RestfulEntity)((Object)resource);
            this.restfulHeadersFor(entity.getEtag(), entity.getLastModified());
        } else {
            this.restfulHeadersFor(this.defaults.getEtagFor(resource), this.defaults.getLastModifiedFor(resource));
        }
    }

    private void restfulHeadersFor(String etag, Calendar lastModified) {
        this.response.addHeader("ETag", etag);
        if (lastModified != null) {
            this.response.setDateHeader("Last-modified", lastModified.getTimeInMillis());
        }
    }
}

