/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.resource;

import br.com.caelum.vraptor.resource.DefaultResourceClass;
import br.com.caelum.vraptor.resource.ResourceClass;
import br.com.caelum.vraptor.resource.ResourceMethod;
import br.com.caelum.vraptor.util.Stringnifier;
import com.google.common.base.Objects;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceMethod
implements ResourceMethod {
    private final ResourceClass resource;
    private final Method method;

    public DefaultResourceMethod(ResourceClass resource, Method method) {
        this.resource = resource;
        this.method = method;
    }

    public static ResourceMethod instanceFor(Class<?> type, Method method) {
        return new DefaultResourceMethod(new DefaultResourceClass(type), method);
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public ResourceClass getResource() {
        return this.resource;
    }

    @Override
    public boolean containsAnnotation(Class<? extends Annotation> annotation) {
        return this.method.isAnnotationPresent(annotation);
    }

    public String toString() {
        return "[DefaultResourceMethod: " + this.method.getDeclaringClass().getSimpleName() + "." + this.method.getName() + Stringnifier.simpleNameFor(this.method) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultResourceMethod other = (DefaultResourceMethod)obj;
        return Objects.equal((Object)this.method, (Object)other.method) && Objects.equal((Object)this.resource, (Object)other.resource);
    }
}

