/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.proxy;

import br.com.caelum.vraptor.ioc.ApplicationScoped;
import br.com.caelum.vraptor.proxy.InstanceCreator;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.ProxyInvocationException;
import br.com.caelum.vraptor.proxy.SuperMethod;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class CglibProxifier
implements Proxifier {
    private static final Logger logger = LoggerFactory.getLogger(CglibProxifier.class);
    private static final List<Method> OBJECT_METHODS = Arrays.asList(Object.class.getDeclaredMethods());
    private static final CallbackFilter IGNORE_BRIDGE_AND_OBJECT_METHODS = new CallbackFilter(){

        public int accept(Method method) {
            return method.isBridge() || OBJECT_METHODS.contains(method) ? 1 : 0;
        }
    };
    private final InstanceCreator instanceCreator;

    public CglibProxifier(InstanceCreator instanceCreator) {
        this.instanceCreator = instanceCreator;
    }

    @Override
    public <T> T proxify(Class<T> type, MethodInvocation<? super T> handler) {
        Class proxyClass = this.enhanceTypeWithCGLib(type, handler).createClass();
        Factory proxyInstance = (Factory)this.instanceCreator.instanceFor(proxyClass);
        proxyInstance.setCallbacks(new Callback[]{this.cglibMethodInterceptor(handler), NoOp.INSTANCE});
        logger.debug("a proxy for {} is created as {}", type, (Object)proxyClass);
        return type.cast(proxyInstance);
    }

    @Override
    public boolean isProxy(Object o) {
        return o != null && Factory.class.isAssignableFrom(o.getClass());
    }

    protected <T> Enhancer enhanceTypeWithCGLib(Class<T> type, MethodInvocation<? super T> handler) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(type);
        enhancer.setCallbackFilter(IGNORE_BRIDGE_AND_OBJECT_METHODS);
        enhancer.setCallbackTypes(new Class[]{MethodInterceptor.class, NoOp.class});
        return enhancer;
    }

    protected <T> MethodInterceptor cglibMethodInterceptor(final MethodInvocation<? super T> handler) {
        return new MethodInterceptor(){

            public Object intercept(Object proxy, Method method, Object[] args, final MethodProxy methodProxy) {
                return handler.intercept(proxy, method, args, new SuperMethod(){

                    public Object invoke(Object proxy, Object[] args) {
                        try {
                            logger.debug("proxy invoke, proxy {}, method {}", proxy, (Object)methodProxy);
                            return methodProxy.invokeSuper(proxy, args);
                        }
                        catch (Throwable throwable) {
                            throw new ProxyInvocationException(throwable);
                        }
                    }
                });
            }
        };
    }
}

